/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESElementIndexUint.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESElementIndexUintPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESElementIndexUintPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESElementIndexUintPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESElementIndexUintPrototype>(vm.heap)) JSOESElementIndexUintPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESElementIndexUintPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESElementIndexUintPrototype, JSOESElementIndexUintPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESElementIndexUintPrototype::s_info = { "OESElementIndexUintPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESElementIndexUintPrototype) };

const ClassInfo JSOESElementIndexUint::s_info = { "OESElementIndexUint", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESElementIndexUint) };

JSOESElementIndexUint::JSOESElementIndexUint(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESElementIndexUint>&& impl)
    : JSDOMWrapper<OESElementIndexUint>(structure, globalObject, WTFMove(impl))
{
}

void JSOESElementIndexUint::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OESElementIndexUint>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOESElementIndexUint::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOESElementIndexUintPrototype::create(vm, &globalObject, JSOESElementIndexUintPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSOESElementIndexUint::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESElementIndexUint>(vm, globalObject);
}

void JSOESElementIndexUint::destroy(JSC::JSCell* cell)
{
    JSOESElementIndexUint* thisObject = static_cast<JSOESElementIndexUint*>(cell);
    thisObject->JSOESElementIndexUint::~JSOESElementIndexUint();
}

void JSOESElementIndexUint::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESElementIndexUint*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESElementIndexUintOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOESElementIndexUint = jsCast<JSOESElementIndexUint*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsOESElementIndexUint->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from OESElementIndexUint";
    return visitor.containsOpaqueRoot(root);
}

void JSOESElementIndexUintOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESElementIndexUint = static_cast<JSOESElementIndexUint*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESElementIndexUint->wrapped(), jsOESElementIndexUint);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESElementIndexUint@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19OESElementIndexUintE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESElementIndexUint>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OESElementIndexUint@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19OESElementIndexUintE[2];
#endif

    // If this fails OESElementIndexUint does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OESElementIndexUint>::value, "OESElementIndexUint is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OESElementIndexUint has subclasses. If OESElementIndexUint has subclasses that get passed
    // to toJS() we currently require OESElementIndexUint you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OESElementIndexUint>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESElementIndexUint& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESElementIndexUint* JSOESElementIndexUint::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESElementIndexUint*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
