/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureFloatLinear.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESTextureFloatLinearPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESTextureFloatLinearPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESTextureFloatLinearPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESTextureFloatLinearPrototype>(vm.heap)) JSOESTextureFloatLinearPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESTextureFloatLinearPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureFloatLinearPrototype, JSOESTextureFloatLinearPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESTextureFloatLinearPrototype::s_info = { "OESTextureFloatLinearPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureFloatLinearPrototype) };

const ClassInfo JSOESTextureFloatLinear::s_info = { "OESTextureFloatLinear", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureFloatLinear) };

JSOESTextureFloatLinear::JSOESTextureFloatLinear(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESTextureFloatLinear>&& impl)
    : JSDOMWrapper<OESTextureFloatLinear>(structure, globalObject, WTFMove(impl))
{
}

void JSOESTextureFloatLinear::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OESTextureFloatLinear>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOESTextureFloatLinear::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOESTextureFloatLinearPrototype::create(vm, &globalObject, JSOESTextureFloatLinearPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSOESTextureFloatLinear::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESTextureFloatLinear>(vm, globalObject);
}

void JSOESTextureFloatLinear::destroy(JSC::JSCell* cell)
{
    JSOESTextureFloatLinear* thisObject = static_cast<JSOESTextureFloatLinear*>(cell);
    thisObject->JSOESTextureFloatLinear::~JSOESTextureFloatLinear();
}

void JSOESTextureFloatLinear::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESTextureFloatLinear*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESTextureFloatLinearOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOESTextureFloatLinear = jsCast<JSOESTextureFloatLinear*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsOESTextureFloatLinear->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from OESTextureFloatLinear";
    return visitor.containsOpaqueRoot(root);
}

void JSOESTextureFloatLinearOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESTextureFloatLinear = static_cast<JSOESTextureFloatLinear*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESTextureFloatLinear->wrapped(), jsOESTextureFloatLinear);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESTextureFloatLinear@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21OESTextureFloatLinearE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESTextureFloatLinear>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OESTextureFloatLinear@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21OESTextureFloatLinearE[2];
#endif

    // If this fails OESTextureFloatLinear does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OESTextureFloatLinear>::value, "OESTextureFloatLinear is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OESTextureFloatLinear has subclasses. If OESTextureFloatLinear has subclasses that get passed
    // to toJS() we currently require OESTextureFloatLinear you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OESTextureFloatLinear>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESTextureFloatLinear& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESTextureFloatLinear* JSOESTextureFloatLinear::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESTextureFloatLinear*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
