/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureHalfFloatLinear.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESTextureHalfFloatLinearPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESTextureHalfFloatLinearPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESTextureHalfFloatLinearPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESTextureHalfFloatLinearPrototype>(vm.heap)) JSOESTextureHalfFloatLinearPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESTextureHalfFloatLinearPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureHalfFloatLinearPrototype, JSOESTextureHalfFloatLinearPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESTextureHalfFloatLinearPrototype::s_info = { "OESTextureHalfFloatLinearPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureHalfFloatLinearPrototype) };

const ClassInfo JSOESTextureHalfFloatLinear::s_info = { "OESTextureHalfFloatLinear", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureHalfFloatLinear) };

JSOESTextureHalfFloatLinear::JSOESTextureHalfFloatLinear(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESTextureHalfFloatLinear>&& impl)
    : JSDOMWrapper<OESTextureHalfFloatLinear>(structure, globalObject, WTFMove(impl))
{
}

void JSOESTextureHalfFloatLinear::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OESTextureHalfFloatLinear>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOESTextureHalfFloatLinear::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOESTextureHalfFloatLinearPrototype::create(vm, &globalObject, JSOESTextureHalfFloatLinearPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSOESTextureHalfFloatLinear::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESTextureHalfFloatLinear>(vm, globalObject);
}

void JSOESTextureHalfFloatLinear::destroy(JSC::JSCell* cell)
{
    JSOESTextureHalfFloatLinear* thisObject = static_cast<JSOESTextureHalfFloatLinear*>(cell);
    thisObject->JSOESTextureHalfFloatLinear::~JSOESTextureHalfFloatLinear();
}

void JSOESTextureHalfFloatLinear::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESTextureHalfFloatLinear*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESTextureHalfFloatLinearOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOESTextureHalfFloatLinear = jsCast<JSOESTextureHalfFloatLinear*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsOESTextureHalfFloatLinear->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from OESTextureHalfFloatLinear";
    return visitor.containsOpaqueRoot(root);
}

void JSOESTextureHalfFloatLinearOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESTextureHalfFloatLinear = static_cast<JSOESTextureHalfFloatLinear*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESTextureHalfFloatLinear->wrapped(), jsOESTextureHalfFloatLinear);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESTextureHalfFloatLinear@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25OESTextureHalfFloatLinearE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESTextureHalfFloatLinear>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OESTextureHalfFloatLinear@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25OESTextureHalfFloatLinearE[2];
#endif

    // If this fails OESTextureHalfFloatLinear does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OESTextureHalfFloatLinear>::value, "OESTextureHalfFloatLinear is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OESTextureHalfFloatLinear has subclasses. If OESTextureHalfFloatLinear has subclasses that get passed
    // to toJS() we currently require OESTextureHalfFloatLinear you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OESTextureHalfFloatLinear>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESTextureHalfFloatLinear& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESTextureHalfFloatLinear* JSOESTextureHalfFloatLinear::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESTextureHalfFloatLinear*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
