/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(OFFSCREEN_CANVAS)

#include "JSOffscreenCanvas.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSImageBitmap.h"
#include "JSOffscreenCanvasRenderingContext2D.h"
#include "JSWebGLRenderingContext.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(OffscreenCanvas::RenderingContextType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("2d"),
        MAKE_STATIC_STRING_IMPL("webgl"),
    };
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::_2d) == 0, "OffscreenCanvas::RenderingContextType::_2d is not 0 as expected");
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::Webgl) == 1, "OffscreenCanvas::RenderingContextType::Webgl is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, OffscreenCanvas::RenderingContextType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<OffscreenCanvas::RenderingContextType> parseEnumeration<OffscreenCanvas::RenderingContextType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "2d")
        return OffscreenCanvas::RenderingContextType::_2d;
    if (stringValue == "webgl")
        return OffscreenCanvas::RenderingContextType::Webgl;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<OffscreenCanvas::RenderingContextType>()
{
    return "\"2d\", \"webgl\"";
}

template<> OffscreenCanvas::ImageEncodeOptions convertDictionary<OffscreenCanvas::ImageEncodeOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    OffscreenCanvas::ImageEncodeOptions result;
    JSValue qualityValue;
    if (isNullOrUndefined)
        qualityValue = jsUndefined();
    else {
        qualityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "quality"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!qualityValue.isUndefined()) {
        result.quality = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, qualityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.quality = 1.0;
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLDOMString>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.type = "image/png"_s;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasPrototypeFunctionGetContext(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasPrototypeFunctionTransferToImageBitmap(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasPrototypeFunctionConvertToBlob(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsOffscreenCanvasConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOffscreenCanvasPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOffscreenCanvasPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOffscreenCanvasPrototype* ptr = new (NotNull, JSC::allocateCell<JSOffscreenCanvasPrototype>(vm.heap)) JSOffscreenCanvasPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOffscreenCanvasPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOffscreenCanvasPrototype, JSOffscreenCanvasPrototype::Base);

using JSOffscreenCanvasConstructor = JSDOMConstructor<JSOffscreenCanvas>;

template<> EncodedJSValue JSC_HOST_CALL JSOffscreenCanvasConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSOffscreenCanvasConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "OffscreenCanvas");
    auto width = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = OffscreenCanvas::create(*context, WTFMove(width), WTFMove(height));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<OffscreenCanvas>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSOffscreenCanvasConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSOffscreenCanvasConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOffscreenCanvas::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("OffscreenCanvas"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSOffscreenCanvasConstructor::s_info = { "OffscreenCanvas", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOffscreenCanvasPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasConstructor) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasWidth) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasHeight) } },
    { "getContext", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasPrototypeFunctionGetContext), (intptr_t) (1) } },
    { "transferToImageBitmap", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasPrototypeFunctionTransferToImageBitmap), (intptr_t) (0) } },
    { "convertToBlob", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasPrototypeFunctionConvertToBlob), (intptr_t) (0) } },
};

const ClassInfo JSOffscreenCanvasPrototype::s_info = { "OffscreenCanvasPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasPrototype) };

void JSOffscreenCanvasPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOffscreenCanvas::info(), JSOffscreenCanvasPrototypeTableValues, *this);
}

const ClassInfo JSOffscreenCanvas::s_info = { "OffscreenCanvas", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvas) };

JSOffscreenCanvas::JSOffscreenCanvas(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OffscreenCanvas>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSOffscreenCanvas::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OffscreenCanvas>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOffscreenCanvas::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOffscreenCanvasPrototype::create(vm, &globalObject, JSOffscreenCanvasPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSOffscreenCanvas::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOffscreenCanvas>(vm, globalObject);
}

JSValue JSOffscreenCanvas::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOffscreenCanvasConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSOffscreenCanvas* IDLAttribute<JSOffscreenCanvas>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSOffscreenCanvas*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSOffscreenCanvas* IDLOperation<JSOffscreenCanvas>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSOffscreenCanvas*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsOffscreenCanvasConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOffscreenCanvasPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOffscreenCanvas::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSOffscreenCanvasConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOffscreenCanvasPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsOffscreenCanvasWidthGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsOffscreenCanvasWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvas>::get<jsOffscreenCanvasWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSOffscreenCanvasWidthSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWidth(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvas>::set<setJSOffscreenCanvasWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

static inline JSValue jsOffscreenCanvasHeightGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.height());
    return result;
}

EncodedJSValue jsOffscreenCanvasHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvas>::get<jsOffscreenCanvasHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline bool setJSOffscreenCanvasHeightSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setHeight(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvas>::set<setJSOffscreenCanvasHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "height");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasPrototypeFunctionGetContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvas>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto contextType = convert<IDLEnumeration<OffscreenCanvas::RenderingContextType>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "contextType", "OffscreenCanvas", "getContext", expectedEnumerationValues<OffscreenCanvas::RenderingContextType>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLUnion<IDLInterface<OffscreenCanvasRenderingContext2D>, IDLInterface<WebGLRenderingContext>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getContext(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(contextType), WTFMove(arguments))));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasPrototypeFunctionGetContext(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvas>::call<jsOffscreenCanvasPrototypeFunctionGetContextBody>(*lexicalGlobalObject, *callFrame, "getContext");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasPrototypeFunctionTransferToImageBitmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvas>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<ImageBitmap>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transferToImageBitmap()));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasPrototypeFunctionTransferToImageBitmap(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvas>::call<jsOffscreenCanvasPrototypeFunctionTransferToImageBitmapBody>(*lexicalGlobalObject, *callFrame, "transferToImageBitmap");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasPrototypeFunctionConvertToBlobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSOffscreenCanvas>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto options = convert<IDLDictionary<OffscreenCanvas::ImageEncodeOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.convertToBlob(WTFMove(options), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasPrototypeFunctionConvertToBlob(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSOffscreenCanvas>::call<jsOffscreenCanvasPrototypeFunctionConvertToBlobBody>(*lexicalGlobalObject, *callFrame, "convertToBlob");
}

void JSOffscreenCanvas::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOffscreenCanvas*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOffscreenCanvasOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOffscreenCanvas = jsCast<JSOffscreenCanvas*>(handle.slot()->asCell());
    if (jsOffscreenCanvas->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    OffscreenCanvas* root = &jsOffscreenCanvas->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from OffscreenCanvas";
    return visitor.containsOpaqueRoot(root);
}

void JSOffscreenCanvasOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOffscreenCanvas = static_cast<JSOffscreenCanvas*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOffscreenCanvas->wrapped(), jsOffscreenCanvas);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OffscreenCanvas@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15OffscreenCanvasE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OffscreenCanvas>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OffscreenCanvas@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15OffscreenCanvasE[2];
#endif

    // If this fails OffscreenCanvas does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OffscreenCanvas>::value, "OffscreenCanvas is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OffscreenCanvas has subclasses. If OffscreenCanvas has subclasses that get passed
    // to toJS() we currently require OffscreenCanvas you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OffscreenCanvas>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OffscreenCanvas& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OffscreenCanvas* JSOffscreenCanvas::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOffscreenCanvas*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(OFFSCREEN_CANVAS)
