/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(OFFSCREEN_CANVAS)

#include "JSOffscreenCanvasRenderingContext2D.h"

#include "ActiveDOMObject.h"
#include "JSCanvasFillRule.h"
#include "JSCanvasGradient.h"
#include "JSCanvasLineCap.h"
#include "JSCanvasLineJoin.h"
#include "JSCanvasPattern.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageData.h"
#include "JSImageSmoothingQuality.h"
#include "JSOffscreenCanvas.h"
#include "JSPath2D.h"
#include "JSTypedOMCSSImageValue.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionBeginPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreatePattern(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetImageData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionClosePath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionMoveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionLineTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionArc(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionEllipse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetLineDash(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetLineDash(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionClearRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionSave(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionRestore(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionScale(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionRotate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionTranslate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionResetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DCanvas(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DGlobalAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DGlobalAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DGlobalCompositeOperation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DGlobalCompositeOperation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DStrokeStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DStrokeStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DFillStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DFillStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DImageSmoothingQuality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DImageSmoothingQuality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DCurrentX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DCurrentY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DLineWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DLineWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DLineCap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DLineCap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DLineJoin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DLineJoin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DMiterLimit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DMiterLimit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowOffsetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DShadowOffsetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowOffsetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DShadowOffsetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowBlur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DShadowBlur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOffscreenCanvasRenderingContext2DShadowColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOffscreenCanvasRenderingContext2DPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOffscreenCanvasRenderingContext2DPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOffscreenCanvasRenderingContext2DPrototype* ptr = new (NotNull, JSC::allocateCell<JSOffscreenCanvasRenderingContext2DPrototype>(vm.heap)) JSOffscreenCanvasRenderingContext2DPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOffscreenCanvasRenderingContext2DPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOffscreenCanvasRenderingContext2DPrototype, JSOffscreenCanvasRenderingContext2DPrototype::Base);

using JSOffscreenCanvasRenderingContext2DConstructor = JSDOMConstructorNotConstructable<JSOffscreenCanvasRenderingContext2D>;

template<> JSValue JSOffscreenCanvasRenderingContext2DConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSOffscreenCanvasRenderingContext2DConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOffscreenCanvasRenderingContext2D::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("OffscreenCanvasRenderingContext2D"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSOffscreenCanvasRenderingContext2DConstructor::s_info = { "OffscreenCanvasRenderingContext2D", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasRenderingContext2DConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOffscreenCanvasRenderingContext2DPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DConstructor) } },
    { "canvas", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "globalAlpha", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DGlobalAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DGlobalAlpha) } },
    { "globalCompositeOperation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DGlobalCompositeOperation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DGlobalCompositeOperation) } },
    { "strokeStyle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DStrokeStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DStrokeStyle) } },
    { "fillStyle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DFillStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DFillStyle) } },
    { "imageSmoothingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DImageSmoothingEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DImageSmoothingEnabled) } },
    { "imageSmoothingQuality", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DImageSmoothingQuality), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DImageSmoothingQuality) } },
    { "currentX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DCurrentX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DCurrentY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lineWidth", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DLineWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DLineWidth) } },
    { "lineCap", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DLineCap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DLineCap) } },
    { "lineJoin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DLineJoin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DLineJoin) } },
    { "miterLimit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DMiterLimit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DMiterLimit) } },
    { "lineDashOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DLineDashOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DLineDashOffset) } },
    { "shadowOffsetX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DShadowOffsetX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DShadowOffsetX) } },
    { "shadowOffsetY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DShadowOffsetY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DShadowOffsetY) } },
    { "shadowBlur", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DShadowBlur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DShadowBlur) } },
    { "shadowColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOffscreenCanvasRenderingContext2DShadowColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOffscreenCanvasRenderingContext2DShadowColor) } },
    { "drawImage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage), (intptr_t) (3) } },
    { "beginPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionBeginPath), (intptr_t) (0) } },
    { "fill", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill), (intptr_t) (0) } },
    { "stroke", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke), (intptr_t) (0) } },
    { "clip", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip), (intptr_t) (0) } },
    { "isPointInPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t) (2) } },
    { "isPointInStroke", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke), (intptr_t) (2) } },
    { "createLinearGradient", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t) (4) } },
    { "createRadialGradient", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t) (6) } },
    { "createPattern", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t) (2) } },
    { "createImageData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData), (intptr_t) (1) } },
    { "getImageData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetImageData), (intptr_t) (4) } },
    { "putImageData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData), (intptr_t) (3) } },
    { "closePath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionClosePath), (intptr_t) (0) } },
    { "moveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionMoveTo), (intptr_t) (2) } },
    { "lineTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionLineTo), (intptr_t) (2) } },
    { "quadraticCurveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t) (4) } },
    { "bezierCurveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t) (6) } },
    { "arcTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcTo), (intptr_t) (5) } },
    { "rect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionRect), (intptr_t) (4) } },
    { "arc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionArc), (intptr_t) (5) } },
    { "ellipse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionEllipse), (intptr_t) (7) } },
    { "setLineDash", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetLineDash), (intptr_t) (1) } },
    { "getLineDash", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetLineDash), (intptr_t) (0) } },
    { "clearRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionClearRect), (intptr_t) (4) } },
    { "fillRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillRect), (intptr_t) (4) } },
    { "strokeRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t) (4) } },
    { "save", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionSave), (intptr_t) (0) } },
    { "restore", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionRestore), (intptr_t) (0) } },
    { "scale", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionScale), (intptr_t) (2) } },
    { "rotate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionRotate), (intptr_t) (1) } },
    { "translate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionTranslate), (intptr_t) (2) } },
    { "transform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionTransform), (intptr_t) (6) } },
    { "getTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetTransform), (intptr_t) (0) } },
    { "setTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform), (intptr_t) (0) } },
    { "resetTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOffscreenCanvasRenderingContext2DPrototypeFunctionResetTransform), (intptr_t) (0) } },
};

const ClassInfo JSOffscreenCanvasRenderingContext2DPrototype::s_info = { "OffscreenCanvasRenderingContext2DPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasRenderingContext2DPrototype) };

void JSOffscreenCanvasRenderingContext2DPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOffscreenCanvasRenderingContext2D::info(), JSOffscreenCanvasRenderingContext2DPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("currentX"), strlen("currentX"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("currentY"), strlen("currentY"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSOffscreenCanvasRenderingContext2D::s_info = { "OffscreenCanvasRenderingContext2D", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasRenderingContext2D) };

JSOffscreenCanvasRenderingContext2D::JSOffscreenCanvasRenderingContext2D(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OffscreenCanvasRenderingContext2D>&& impl)
    : JSDOMWrapper<OffscreenCanvasRenderingContext2D>(structure, globalObject, WTFMove(impl))
{
}

void JSOffscreenCanvasRenderingContext2D::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OffscreenCanvasRenderingContext2D>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOffscreenCanvasRenderingContext2D::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOffscreenCanvasRenderingContext2DPrototype::create(vm, &globalObject, JSOffscreenCanvasRenderingContext2DPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSOffscreenCanvasRenderingContext2D::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOffscreenCanvasRenderingContext2D>(vm, globalObject);
}

JSValue JSOffscreenCanvasRenderingContext2D::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOffscreenCanvasRenderingContext2DConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSOffscreenCanvasRenderingContext2D::destroy(JSC::JSCell* cell)
{
    JSOffscreenCanvasRenderingContext2D* thisObject = static_cast<JSOffscreenCanvasRenderingContext2D*>(cell);
    thisObject->JSOffscreenCanvasRenderingContext2D::~JSOffscreenCanvasRenderingContext2D();
}

template<> inline JSOffscreenCanvasRenderingContext2D* IDLAttribute<JSOffscreenCanvasRenderingContext2D>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSOffscreenCanvasRenderingContext2D*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSOffscreenCanvasRenderingContext2D* IDLOperation<JSOffscreenCanvasRenderingContext2D>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSOffscreenCanvasRenderingContext2D*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOffscreenCanvasRenderingContext2DPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOffscreenCanvasRenderingContext2D::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSOffscreenCanvasRenderingContext2DConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOffscreenCanvasRenderingContext2DPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsOffscreenCanvasRenderingContext2DCanvasGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<OffscreenCanvas>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DCanvas(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DCanvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canvas");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DGlobalAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.globalAlpha());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DGlobalAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DGlobalAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "globalAlpha");
}

static inline bool setJSOffscreenCanvasRenderingContext2DGlobalAlphaSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalAlpha(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DGlobalAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DGlobalAlphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, "globalAlpha");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DGlobalCompositeOperationGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.globalCompositeOperation());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DGlobalCompositeOperation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DGlobalCompositeOperationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "globalCompositeOperation");
}

static inline bool setJSOffscreenCanvasRenderingContext2DGlobalCompositeOperationSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalCompositeOperation(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DGlobalCompositeOperation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DGlobalCompositeOperationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "globalCompositeOperation");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DStrokeStyleGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.strokeStyle());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DStrokeStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DStrokeStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "strokeStyle");
}

static inline bool setJSOffscreenCanvasRenderingContext2DStrokeStyleSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStrokeStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DStrokeStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DStrokeStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "strokeStyle");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DFillStyleGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fillStyle());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DFillStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DFillStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fillStyle");
}

static inline bool setJSOffscreenCanvasRenderingContext2DFillStyleSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFillStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DFillStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DFillStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "fillStyle");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DImageSmoothingEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.imageSmoothingEnabled());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DImageSmoothingEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "imageSmoothingEnabled");
}

static inline bool setJSOffscreenCanvasRenderingContext2DImageSmoothingEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DImageSmoothingEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "imageSmoothingEnabled");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DImageSmoothingQualityGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ImageSmoothingQuality>>(lexicalGlobalObject, throwScope, impl.imageSmoothingQuality());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DImageSmoothingQuality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DImageSmoothingQualityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "imageSmoothingQuality");
}

static inline bool setJSOffscreenCanvasRenderingContext2DImageSmoothingQualitySetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<ImageSmoothingQuality>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingQuality(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DImageSmoothingQuality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DImageSmoothingQualitySetter>(*lexicalGlobalObject, thisValue, encodedValue, "imageSmoothingQuality");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DCurrentXGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentX());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DCurrentX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DCurrentXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentX");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DCurrentYGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentY());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DCurrentY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DCurrentYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentY");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DLineWidthGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineWidth());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DLineWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DLineWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineWidth");
}

static inline bool setJSOffscreenCanvasRenderingContext2DLineWidthSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineWidth(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DLineWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DLineWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineWidth");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DLineCapGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<CanvasLineCap>>(lexicalGlobalObject, throwScope, impl.lineCap());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DLineCap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DLineCapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineCap");
}

static inline bool setJSOffscreenCanvasRenderingContext2DLineCapSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineCap>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineCap(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DLineCap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DLineCapSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineCap");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DLineJoinGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<CanvasLineJoin>>(lexicalGlobalObject, throwScope, impl.lineJoin());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DLineJoin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DLineJoinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineJoin");
}

static inline bool setJSOffscreenCanvasRenderingContext2DLineJoinSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineJoin>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineJoin(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DLineJoin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DLineJoinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineJoin");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DMiterLimitGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.miterLimit());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DMiterLimit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DMiterLimitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "miterLimit");
}

static inline bool setJSOffscreenCanvasRenderingContext2DMiterLimitSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMiterLimit(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DMiterLimit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DMiterLimitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "miterLimit");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DLineDashOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineDashOffset());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DLineDashOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineDashOffset");
}

static inline bool setJSOffscreenCanvasRenderingContext2DLineDashOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineDashOffset(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DLineDashOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineDashOffset");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DShadowOffsetXGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetX());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowOffsetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DShadowOffsetXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowOffsetX");
}

static inline bool setJSOffscreenCanvasRenderingContext2DShadowOffsetXSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DShadowOffsetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DShadowOffsetXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowOffsetX");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DShadowOffsetYGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetY());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowOffsetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DShadowOffsetYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowOffsetY");
}

static inline bool setJSOffscreenCanvasRenderingContext2DShadowOffsetYSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DShadowOffsetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DShadowOffsetYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowOffsetY");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DShadowBlurGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowBlur());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowBlur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DShadowBlurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowBlur");
}

static inline bool setJSOffscreenCanvasRenderingContext2DShadowBlurSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowBlur(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DShadowBlur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DShadowBlurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowBlur");
}

static inline JSValue jsOffscreenCanvasRenderingContext2DShadowColorGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.shadowColor());
    return result;
}

EncodedJSValue jsOffscreenCanvasRenderingContext2DShadowColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2DShadowColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowColor");
}

static inline bool setJSOffscreenCanvasRenderingContext2DShadowColorSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOffscreenCanvasRenderingContext2DShadowColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2DShadowColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowColor");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(dx), WTFMove(dy)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 3) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 9) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionDrawImageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "drawImage");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionBeginPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.beginPath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionBeginPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionBeginPathBody>(*lexicalGlobalObject, *callFrame, "beginPath");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto fillRule = callFrame->argument(0).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule", "OffscreenCanvasRenderingContext2D", "fill", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fill(WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "OffscreenCanvasRenderingContext2D", "fill", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(1).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule", "OffscreenCanvasRenderingContext2D", "fill", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fill(*path, WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionFill(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "fill");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.stroke();
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "OffscreenCanvasRenderingContext2D", "stroke", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.stroke(*path);
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionStroke(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "stroke");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto fillRule = callFrame->argument(0).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule", "OffscreenCanvasRenderingContext2D", "clip", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clip(WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "OffscreenCanvasRenderingContext2D", "clip", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(1).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule", "OffscreenCanvasRenderingContext2D", "clip", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clip(*path, WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionClipOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionClip(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionClipOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "clip");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(2).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 2, "fillRule", "OffscreenCanvasRenderingContext2D", "isPointInPath", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInPath(WTFMove(x), WTFMove(y), WTFMove(fillRule))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "OffscreenCanvasRenderingContext2D", "isPointInPath", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(3).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 3, "fillRule", "OffscreenCanvasRenderingContext2D", "isPointInPath", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInPath(*path, WTFMove(x), WTFMove(y), WTFMove(fillRule))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPathOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInPathOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInPath");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInStroke(WTFMove(x), WTFMove(y))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "OffscreenCanvasRenderingContext2D", "isPointInStroke", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInStroke(*path, WTFMove(x), WTFMove(y))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStroke(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionIsPointInStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInStroke");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateLinearGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createLinearGradient(WTFMove(x0), WTFMove(y0), WTFMove(x1), WTFMove(y1))));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateLinearGradientBody>(*lexicalGlobalObject, *callFrame, "createLinearGradient");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateRadialGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRadialGradient(WTFMove(x0), WTFMove(y0), WTFMove(r0), WTFMove(x1), WTFMove(y1), WTFMove(r1))));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateRadialGradientBody>(*lexicalGlobalObject, *callFrame, "createRadialGradient");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreatePatternBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto repetition = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<CanvasPattern>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPattern(WTFMove(image), WTFMove(repetition))));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreatePattern(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreatePatternBody>(*lexicalGlobalObject, *callFrame, "createPattern");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto sw = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createImageData(WTFMove(sw), WTFMove(sh))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto imagedata = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata", "OffscreenCanvasRenderingContext2D", "createImageData", "ImageData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createImageData(*imagedata)));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionCreateImageDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "createImageData");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetImageDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sx = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sy = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getImageData(WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh))));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetImageData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetImageDataBody>(*lexicalGlobalObject, *callFrame, "getImageData");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto imagedata = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata", "OffscreenCanvasRenderingContext2D", "putImageData", "ImageData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.putImageData(*imagedata, WTFMove(dx), WTFMove(dy));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto imagedata = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata", "OffscreenCanvasRenderingContext2D", "putImageData", "ImageData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyX = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyY = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyWidth = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyHeight = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.putImageData(*imagedata, WTFMove(dx), WTFMove(dy), WTFMove(dirtyX), WTFMove(dirtyY), WTFMove(dirtyWidth), WTFMove(dirtyHeight));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(7, callFrame->argumentCount());
    if (argsCount == 3) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 7) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionPutImageDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "putImageData");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionClosePathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionClosePath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionClosePathBody>(*lexicalGlobalObject, *callFrame, "closePath");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionMoveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.moveTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionMoveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionMoveToBody>(*lexicalGlobalObject, *callFrame, "moveTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionLineToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.lineTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionLineTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionLineToBody>(*lexicalGlobalObject, *callFrame, "lineTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionQuadraticCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cpx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cpy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.quadraticCurveTo(WTFMove(cpx), WTFMove(cpy), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionQuadraticCurveToBody>(*lexicalGlobalObject, *callFrame, "quadraticCurveTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionBezierCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cp1x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp1y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp2x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp2y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.bezierCurveTo(WTFMove(cp1x), WTFMove(cp1y), WTFMove(cp2x), WTFMove(cp2y), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionBezierCurveToBody>(*lexicalGlobalObject, *callFrame, "bezierCurveTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x1 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x2 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y2 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.arcTo(WTFMove(x1), WTFMove(y1), WTFMove(x2), WTFMove(y2), WTFMove(radius)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcToBody>(*lexicalGlobalObject, *callFrame, "arcTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.rect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionRectBody>(*lexicalGlobalObject, *callFrame, "rect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto startAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto anticlockwise = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.arc(WTFMove(x), WTFMove(y), WTFMove(radius), WTFMove(startAngle), WTFMove(endAngle), WTFMove(anticlockwise)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionArc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionArcBody>(*lexicalGlobalObject, *callFrame, "arc");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionEllipseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radiusX = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radiusY = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotation = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto startAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto anticlockwise = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.ellipse(WTFMove(x), WTFMove(y), WTFMove(radiusX), WTFMove(radiusY), WTFMove(rotation), WTFMove(startAngle), WTFMove(endAngle), WTFMove(anticlockwise)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionEllipse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionEllipseBody>(*lexicalGlobalObject, *callFrame, "ellipse");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto segments = convert<IDLSequence<IDLUnrestrictedFloat>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setLineDash(WTFMove(segments));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetLineDash(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetLineDashBody>(*lexicalGlobalObject, *callFrame, "setLineDash");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLUnrestrictedFloat>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getLineDash()));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetLineDash(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetLineDashBody>(*lexicalGlobalObject, *callFrame, "getLineDash");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionClearRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clearRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionClearRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionClearRectBody>(*lexicalGlobalObject, *callFrame, "clearRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fillRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionFillRectBody>(*lexicalGlobalObject, *callFrame, "fillRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.strokeRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionStrokeRectBody>(*lexicalGlobalObject, *callFrame, "strokeRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionSaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.save();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionSave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionSaveBody>(*lexicalGlobalObject, *callFrame, "save");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionRestoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.restore();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionRestore(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionRestoreBody>(*lexicalGlobalObject, *callFrame, "restore");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionScaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scale(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionScale(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionScaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionRotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto angle = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.rotate(WTFMove(angle));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionRotate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionRotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionTranslateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.translate(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionTranslate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionTranslateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto d = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto e = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto f = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.transform(WTFMove(a), WTFMove(b), WTFMove(c), WTFMove(d), WTFMove(e), WTFMove(f));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionTransformBody>(*lexicalGlobalObject, *callFrame, "transform");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTransform()));
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionGetTransformBody>(*lexicalGlobalObject, *callFrame, "getTransform");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto d = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto e = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto f = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTransform(WTFMove(a), WTFMove(b), WTFMove(c), WTFMove(d), WTFMove(e), WTFMove(f));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto transform = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTransform(WTFMove(transform)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransformOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(6, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 6) {
        return jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionSetTransformOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setTransform");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunctionResetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.resetTransform();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOffscreenCanvasRenderingContext2DPrototypeFunctionResetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunctionResetTransformBody>(*lexicalGlobalObject, *callFrame, "resetTransform");
}

void JSOffscreenCanvasRenderingContext2D::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSOffscreenCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSOffscreenCanvasRenderingContext2D::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSOffscreenCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSOffscreenCanvasRenderingContext2D::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOffscreenCanvasRenderingContext2D*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSOffscreenCanvasRenderingContext2DOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOffscreenCanvasRenderingContext2D = static_cast<JSOffscreenCanvasRenderingContext2D*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOffscreenCanvasRenderingContext2D->wrapped(), jsOffscreenCanvasRenderingContext2D);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OffscreenCanvasRenderingContext2D@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore33OffscreenCanvasRenderingContext2DE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OffscreenCanvasRenderingContext2D>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OffscreenCanvasRenderingContext2D@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore33OffscreenCanvasRenderingContext2DE[2];
#endif

    // If this fails OffscreenCanvasRenderingContext2D does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OffscreenCanvasRenderingContext2D>::value, "OffscreenCanvasRenderingContext2D is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OffscreenCanvasRenderingContext2D has subclasses. If OffscreenCanvasRenderingContext2D has subclasses that get passed
    // to toJS() we currently require OffscreenCanvasRenderingContext2D you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OffscreenCanvasRenderingContext2D>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OffscreenCanvasRenderingContext2D& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OffscreenCanvasRenderingContext2D* JSOffscreenCanvasRenderingContext2D::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOffscreenCanvasRenderingContext2D*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(OFFSCREEN_CANVAS)
