/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_PAINTING_API)

#include "JSPaintRenderingContext2D.h"

#include "ActiveDOMObject.h"
#include "JSCanvasFillRule.h"
#include "JSCanvasGradient.h"
#include "JSCanvasLineCap.h"
#include "JSCanvasLineJoin.h"
#include "JSCanvasPattern.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageSmoothingQuality.h"
#include "JSPath2D.h"
#include "JSTypedOMCSSImageValue.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionDrawImage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionBeginPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionFill(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionStroke(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionClip(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionIsPointInPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionCreateLinearGradient(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionCreateRadialGradient(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionCreatePattern(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionClosePath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionMoveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionLineTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionBezierCurveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionArcTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionArc(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionEllipse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionSetLineDash(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionGetLineDash(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionClearRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionFillRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionStrokeRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionSave(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionRestore(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionScale(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionRotate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionTranslate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionGetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionSetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionResetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPaintRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DGlobalAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DGlobalAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DGlobalCompositeOperation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DGlobalCompositeOperation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DStrokeStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DStrokeStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DFillStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DFillStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DImageSmoothingQuality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DImageSmoothingQuality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DCurrentX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaintRenderingContext2DCurrentY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaintRenderingContext2DLineWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DLineWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DLineCap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DLineCap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DLineJoin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DLineJoin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DMiterLimit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DMiterLimit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DShadowOffsetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DShadowOffsetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DShadowOffsetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DShadowOffsetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DShadowBlur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DShadowBlur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintRenderingContext2DShadowColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintRenderingContext2DShadowColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPaintRenderingContext2DPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPaintRenderingContext2DPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPaintRenderingContext2DPrototype* ptr = new (NotNull, JSC::allocateCell<JSPaintRenderingContext2DPrototype>(vm.heap)) JSPaintRenderingContext2DPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPaintRenderingContext2DPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPaintRenderingContext2DPrototype, JSPaintRenderingContext2DPrototype::Base);

using JSPaintRenderingContext2DConstructor = JSDOMConstructorNotConstructable<JSPaintRenderingContext2D>;

template<> JSValue JSPaintRenderingContext2DConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPaintRenderingContext2DConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPaintRenderingContext2D::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaintRenderingContext2D"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaintRenderingContext2DConstructor::s_info = { "PaintRenderingContext2D", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaintRenderingContext2DConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPaintRenderingContext2DPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DConstructor) } },
    { "globalAlpha", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DGlobalAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DGlobalAlpha) } },
    { "globalCompositeOperation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DGlobalCompositeOperation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DGlobalCompositeOperation) } },
    { "strokeStyle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DStrokeStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DStrokeStyle) } },
    { "fillStyle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DFillStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DFillStyle) } },
    { "imageSmoothingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DImageSmoothingEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DImageSmoothingEnabled) } },
    { "imageSmoothingQuality", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DImageSmoothingQuality), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DImageSmoothingQuality) } },
    { "currentX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DCurrentX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DCurrentY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lineWidth", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DLineWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DLineWidth) } },
    { "lineCap", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DLineCap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DLineCap) } },
    { "lineJoin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DLineJoin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DLineJoin) } },
    { "miterLimit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DMiterLimit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DMiterLimit) } },
    { "lineDashOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DLineDashOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DLineDashOffset) } },
    { "shadowOffsetX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DShadowOffsetX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DShadowOffsetX) } },
    { "shadowOffsetY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DShadowOffsetY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DShadowOffsetY) } },
    { "shadowBlur", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DShadowBlur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DShadowBlur) } },
    { "shadowColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintRenderingContext2DShadowColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintRenderingContext2DShadowColor) } },
    { "drawImage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionDrawImage), (intptr_t) (3) } },
    { "beginPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionBeginPath), (intptr_t) (0) } },
    { "fill", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionFill), (intptr_t) (0) } },
    { "stroke", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionStroke), (intptr_t) (0) } },
    { "clip", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionClip), (intptr_t) (0) } },
    { "isPointInPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t) (2) } },
    { "isPointInStroke", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke), (intptr_t) (2) } },
    { "createLinearGradient", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t) (4) } },
    { "createRadialGradient", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t) (6) } },
    { "createPattern", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t) (2) } },
    { "closePath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionClosePath), (intptr_t) (0) } },
    { "moveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionMoveTo), (intptr_t) (2) } },
    { "lineTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionLineTo), (intptr_t) (2) } },
    { "quadraticCurveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t) (4) } },
    { "bezierCurveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t) (6) } },
    { "arcTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionArcTo), (intptr_t) (5) } },
    { "rect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionRect), (intptr_t) (4) } },
    { "arc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionArc), (intptr_t) (5) } },
    { "ellipse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionEllipse), (intptr_t) (7) } },
    { "setLineDash", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionSetLineDash), (intptr_t) (1) } },
    { "getLineDash", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionGetLineDash), (intptr_t) (0) } },
    { "clearRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionClearRect), (intptr_t) (4) } },
    { "fillRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionFillRect), (intptr_t) (4) } },
    { "strokeRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t) (4) } },
    { "save", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionSave), (intptr_t) (0) } },
    { "restore", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionRestore), (intptr_t) (0) } },
    { "scale", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionScale), (intptr_t) (2) } },
    { "rotate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionRotate), (intptr_t) (1) } },
    { "translate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionTranslate), (intptr_t) (2) } },
    { "transform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionTransform), (intptr_t) (6) } },
    { "getTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionGetTransform), (intptr_t) (0) } },
    { "setTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionSetTransform), (intptr_t) (0) } },
    { "resetTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintRenderingContext2DPrototypeFunctionResetTransform), (intptr_t) (0) } },
};

const ClassInfo JSPaintRenderingContext2DPrototype::s_info = { "PaintRenderingContext2DPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaintRenderingContext2DPrototype) };

void JSPaintRenderingContext2DPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPaintRenderingContext2D::info(), JSPaintRenderingContext2DPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("currentX"), strlen("currentX"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("currentY"), strlen("currentY"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSPaintRenderingContext2D::s_info = { "PaintRenderingContext2D", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaintRenderingContext2D) };

JSPaintRenderingContext2D::JSPaintRenderingContext2D(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PaintRenderingContext2D>&& impl)
    : JSDOMWrapper<PaintRenderingContext2D>(structure, globalObject, WTFMove(impl))
{
}

void JSPaintRenderingContext2D::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PaintRenderingContext2D>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPaintRenderingContext2D::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPaintRenderingContext2DPrototype::create(vm, &globalObject, JSPaintRenderingContext2DPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSPaintRenderingContext2D::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPaintRenderingContext2D>(vm, globalObject);
}

JSValue JSPaintRenderingContext2D::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaintRenderingContext2DConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPaintRenderingContext2D::destroy(JSC::JSCell* cell)
{
    JSPaintRenderingContext2D* thisObject = static_cast<JSPaintRenderingContext2D*>(cell);
    thisObject->JSPaintRenderingContext2D::~JSPaintRenderingContext2D();
}

template<> inline JSPaintRenderingContext2D* IDLAttribute<JSPaintRenderingContext2D>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPaintRenderingContext2D*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPaintRenderingContext2D* IDLOperation<JSPaintRenderingContext2D>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPaintRenderingContext2D*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPaintRenderingContext2DConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaintRenderingContext2DPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaintRenderingContext2D::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaintRenderingContext2DConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaintRenderingContext2DPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPaintRenderingContext2DGlobalAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.globalAlpha());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DGlobalAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DGlobalAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "globalAlpha");
}

static inline bool setJSPaintRenderingContext2DGlobalAlphaSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalAlpha(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DGlobalAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DGlobalAlphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, "globalAlpha");
}

static inline JSValue jsPaintRenderingContext2DGlobalCompositeOperationGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.globalCompositeOperation());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DGlobalCompositeOperation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DGlobalCompositeOperationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "globalCompositeOperation");
}

static inline bool setJSPaintRenderingContext2DGlobalCompositeOperationSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalCompositeOperation(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DGlobalCompositeOperation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DGlobalCompositeOperationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "globalCompositeOperation");
}

static inline JSValue jsPaintRenderingContext2DStrokeStyleGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.strokeStyle());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DStrokeStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DStrokeStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "strokeStyle");
}

static inline bool setJSPaintRenderingContext2DStrokeStyleSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStrokeStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DStrokeStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DStrokeStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "strokeStyle");
}

static inline JSValue jsPaintRenderingContext2DFillStyleGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fillStyle());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DFillStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DFillStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fillStyle");
}

static inline bool setJSPaintRenderingContext2DFillStyleSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFillStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DFillStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DFillStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "fillStyle");
}

static inline JSValue jsPaintRenderingContext2DImageSmoothingEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.imageSmoothingEnabled());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DImageSmoothingEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "imageSmoothingEnabled");
}

static inline bool setJSPaintRenderingContext2DImageSmoothingEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DImageSmoothingEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "imageSmoothingEnabled");
}

static inline JSValue jsPaintRenderingContext2DImageSmoothingQualityGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ImageSmoothingQuality>>(lexicalGlobalObject, throwScope, impl.imageSmoothingQuality());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DImageSmoothingQuality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DImageSmoothingQualityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "imageSmoothingQuality");
}

static inline bool setJSPaintRenderingContext2DImageSmoothingQualitySetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<ImageSmoothingQuality>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingQuality(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DImageSmoothingQuality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DImageSmoothingQualitySetter>(*lexicalGlobalObject, thisValue, encodedValue, "imageSmoothingQuality");
}

static inline JSValue jsPaintRenderingContext2DCurrentXGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentX());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DCurrentX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DCurrentXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentX");
}

static inline JSValue jsPaintRenderingContext2DCurrentYGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentY());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DCurrentY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DCurrentYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentY");
}

static inline JSValue jsPaintRenderingContext2DLineWidthGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineWidth());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DLineWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DLineWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineWidth");
}

static inline bool setJSPaintRenderingContext2DLineWidthSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineWidth(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DLineWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DLineWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineWidth");
}

static inline JSValue jsPaintRenderingContext2DLineCapGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<CanvasLineCap>>(lexicalGlobalObject, throwScope, impl.lineCap());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DLineCap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DLineCapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineCap");
}

static inline bool setJSPaintRenderingContext2DLineCapSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineCap>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineCap(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DLineCap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DLineCapSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineCap");
}

static inline JSValue jsPaintRenderingContext2DLineJoinGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<CanvasLineJoin>>(lexicalGlobalObject, throwScope, impl.lineJoin());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DLineJoin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DLineJoinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineJoin");
}

static inline bool setJSPaintRenderingContext2DLineJoinSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineJoin>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineJoin(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DLineJoin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DLineJoinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineJoin");
}

static inline JSValue jsPaintRenderingContext2DMiterLimitGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.miterLimit());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DMiterLimit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DMiterLimitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "miterLimit");
}

static inline bool setJSPaintRenderingContext2DMiterLimitSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMiterLimit(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DMiterLimit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DMiterLimitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "miterLimit");
}

static inline JSValue jsPaintRenderingContext2DLineDashOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineDashOffset());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DLineDashOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineDashOffset");
}

static inline bool setJSPaintRenderingContext2DLineDashOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineDashOffset(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DLineDashOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineDashOffset");
}

static inline JSValue jsPaintRenderingContext2DShadowOffsetXGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetX());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DShadowOffsetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DShadowOffsetXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowOffsetX");
}

static inline bool setJSPaintRenderingContext2DShadowOffsetXSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DShadowOffsetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DShadowOffsetXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowOffsetX");
}

static inline JSValue jsPaintRenderingContext2DShadowOffsetYGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetY());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DShadowOffsetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DShadowOffsetYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowOffsetY");
}

static inline bool setJSPaintRenderingContext2DShadowOffsetYSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DShadowOffsetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DShadowOffsetYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowOffsetY");
}

static inline JSValue jsPaintRenderingContext2DShadowBlurGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowBlur());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DShadowBlur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DShadowBlurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowBlur");
}

static inline bool setJSPaintRenderingContext2DShadowBlurSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowBlur(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DShadowBlur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DShadowBlurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowBlur");
}

static inline JSValue jsPaintRenderingContext2DShadowColorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.shadowColor());
    return result;
}

EncodedJSValue jsPaintRenderingContext2DShadowColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintRenderingContext2D>::get<jsPaintRenderingContext2DShadowColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowColor");
}

static inline bool setJSPaintRenderingContext2DShadowColorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPaintRenderingContext2DShadowColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintRenderingContext2D>::set<setJSPaintRenderingContext2DShadowColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowColor");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionDrawImage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(dx), WTFMove(dy)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionDrawImage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionDrawImage3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionDrawImageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 3) {
        return jsPaintRenderingContext2DPrototypeFunctionDrawImage1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsPaintRenderingContext2DPrototypeFunctionDrawImage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 9) {
        return jsPaintRenderingContext2DPrototypeFunctionDrawImage3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionDrawImage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionDrawImageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "drawImage");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionBeginPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.beginPath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionBeginPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionBeginPathBody>(*lexicalGlobalObject, *callFrame, "beginPath");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionFill1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto fillRule = callFrame->argument(0).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule", "PaintRenderingContext2D", "fill", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fill(WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionFill2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "PaintRenderingContext2D", "fill", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(1).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule", "PaintRenderingContext2D", "fill", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fill(*path, WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionFillOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsPaintRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsPaintRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsPaintRenderingContext2DPrototypeFunctionFill2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsPaintRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsPaintRenderingContext2DPrototypeFunctionFill2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionFill(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionFillOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "fill");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.stroke();
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "PaintRenderingContext2D", "stroke", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.stroke(*path);
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsPaintRenderingContext2DPrototypeFunctionStroke1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsPaintRenderingContext2DPrototypeFunctionStroke2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionStroke(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "stroke");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionClip1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto fillRule = callFrame->argument(0).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule", "PaintRenderingContext2D", "clip", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clip(WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionClip2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "PaintRenderingContext2D", "clip", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(1).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule", "PaintRenderingContext2D", "clip", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clip(*path, WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionClipOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsPaintRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsPaintRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsPaintRenderingContext2DPrototypeFunctionClip2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsPaintRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsPaintRenderingContext2DPrototypeFunctionClip2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionClip(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionClipOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "clip");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionIsPointInPath1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(2).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 2, "fillRule", "PaintRenderingContext2D", "isPointInPath", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInPath(WTFMove(x), WTFMove(y), WTFMove(fillRule))));
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionIsPointInPath2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "PaintRenderingContext2D", "isPointInPath", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(3).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 3, "fillRule", "PaintRenderingContext2D", "isPointInPath", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInPath(*path, WTFMove(x), WTFMove(y), WTFMove(fillRule))));
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionIsPointInPathOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsPaintRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsPaintRenderingContext2DPrototypeFunctionIsPointInPath2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsPaintRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsPaintRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsPaintRenderingContext2DPrototypeFunctionIsPointInPath2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionIsPointInPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionIsPointInPathOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInPath");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInStroke(WTFMove(x), WTFMove(y))));
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "PaintRenderingContext2D", "isPointInStroke", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInStroke(*path, WTFMove(x), WTFMove(y))));
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionIsPointInStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionIsPointInStroke(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionIsPointInStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInStroke");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionCreateLinearGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createLinearGradient(WTFMove(x0), WTFMove(y0), WTFMove(x1), WTFMove(y1))));
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionCreateLinearGradient(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionCreateLinearGradientBody>(*lexicalGlobalObject, *callFrame, "createLinearGradient");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionCreateRadialGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRadialGradient(WTFMove(x0), WTFMove(y0), WTFMove(r0), WTFMove(x1), WTFMove(y1), WTFMove(r1))));
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionCreateRadialGradient(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionCreateRadialGradientBody>(*lexicalGlobalObject, *callFrame, "createRadialGradient");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionCreatePatternBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto repetition = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<CanvasPattern>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPattern(WTFMove(image), WTFMove(repetition))));
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionCreatePattern(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionCreatePatternBody>(*lexicalGlobalObject, *callFrame, "createPattern");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionClosePathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionClosePath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionClosePathBody>(*lexicalGlobalObject, *callFrame, "closePath");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionMoveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.moveTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionMoveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionMoveToBody>(*lexicalGlobalObject, *callFrame, "moveTo");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionLineToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.lineTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionLineTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionLineToBody>(*lexicalGlobalObject, *callFrame, "lineTo");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionQuadraticCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cpx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cpy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.quadraticCurveTo(WTFMove(cpx), WTFMove(cpy), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionQuadraticCurveToBody>(*lexicalGlobalObject, *callFrame, "quadraticCurveTo");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionBezierCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cp1x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp1y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp2x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp2y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.bezierCurveTo(WTFMove(cp1x), WTFMove(cp1y), WTFMove(cp2x), WTFMove(cp2y), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionBezierCurveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionBezierCurveToBody>(*lexicalGlobalObject, *callFrame, "bezierCurveTo");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionArcToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x1 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x2 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y2 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.arcTo(WTFMove(x1), WTFMove(y1), WTFMove(x2), WTFMove(y2), WTFMove(radius)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionArcTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionArcToBody>(*lexicalGlobalObject, *callFrame, "arcTo");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.rect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionRectBody>(*lexicalGlobalObject, *callFrame, "rect");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionArcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto startAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto anticlockwise = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.arc(WTFMove(x), WTFMove(y), WTFMove(radius), WTFMove(startAngle), WTFMove(endAngle), WTFMove(anticlockwise)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionArc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionArcBody>(*lexicalGlobalObject, *callFrame, "arc");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionEllipseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radiusX = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radiusY = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotation = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto startAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto anticlockwise = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.ellipse(WTFMove(x), WTFMove(y), WTFMove(radiusX), WTFMove(radiusY), WTFMove(rotation), WTFMove(startAngle), WTFMove(endAngle), WTFMove(anticlockwise)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionEllipse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionEllipseBody>(*lexicalGlobalObject, *callFrame, "ellipse");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionSetLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto segments = convert<IDLSequence<IDLUnrestrictedFloat>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setLineDash(WTFMove(segments));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionSetLineDash(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionSetLineDashBody>(*lexicalGlobalObject, *callFrame, "setLineDash");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionGetLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLUnrestrictedFloat>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getLineDash()));
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionGetLineDash(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionGetLineDashBody>(*lexicalGlobalObject, *callFrame, "getLineDash");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionClearRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clearRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionClearRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionClearRectBody>(*lexicalGlobalObject, *callFrame, "clearRect");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionFillRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fillRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionFillRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionFillRectBody>(*lexicalGlobalObject, *callFrame, "fillRect");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionStrokeRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.strokeRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionStrokeRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionStrokeRectBody>(*lexicalGlobalObject, *callFrame, "strokeRect");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionSaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.save();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionSave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionSaveBody>(*lexicalGlobalObject, *callFrame, "save");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionRestoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.restore();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionRestore(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionRestoreBody>(*lexicalGlobalObject, *callFrame, "restore");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionScaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scale(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionScale(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionScaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionRotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto angle = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.rotate(WTFMove(angle));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionRotate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionRotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionTranslateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.translate(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionTranslate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionTranslateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto d = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto e = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto f = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.transform(WTFMove(a), WTFMove(b), WTFMove(c), WTFMove(d), WTFMove(e), WTFMove(f));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionTransformBody>(*lexicalGlobalObject, *callFrame, "transform");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionGetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTransform()));
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionGetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionGetTransformBody>(*lexicalGlobalObject, *callFrame, "getTransform");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionSetTransform1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto d = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto e = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto f = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTransform(WTFMove(a), WTFMove(b), WTFMove(c), WTFMove(d), WTFMove(e), WTFMove(f));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionSetTransform2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto transform = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTransform(WTFMove(transform)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionSetTransformOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(6, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsPaintRenderingContext2DPrototypeFunctionSetTransform2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsPaintRenderingContext2DPrototypeFunctionSetTransform2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 6) {
        return jsPaintRenderingContext2DPrototypeFunctionSetTransform1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionSetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionSetTransformOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setTransform");
}

static inline JSC::EncodedJSValue jsPaintRenderingContext2DPrototypeFunctionResetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.resetTransform();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintRenderingContext2DPrototypeFunctionResetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintRenderingContext2D>::call<jsPaintRenderingContext2DPrototypeFunctionResetTransformBody>(*lexicalGlobalObject, *callFrame, "resetTransform");
}

void JSPaintRenderingContext2D::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaintRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaintRenderingContext2D::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaintRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaintRenderingContext2D::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaintRenderingContext2D*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSPaintRenderingContext2DOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPaintRenderingContext2D = static_cast<JSPaintRenderingContext2D*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPaintRenderingContext2D->wrapped(), jsPaintRenderingContext2D);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PaintRenderingContext2D@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23PaintRenderingContext2DE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PaintRenderingContext2D>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PaintRenderingContext2D@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore23PaintRenderingContext2DE[2];
#endif

    // If this fails PaintRenderingContext2D does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PaintRenderingContext2D>::value, "PaintRenderingContext2D is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PaintRenderingContext2D has subclasses. If PaintRenderingContext2D has subclasses that get passed
    // to toJS() we currently require PaintRenderingContext2D you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PaintRenderingContext2D>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaintRenderingContext2D& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PaintRenderingContext2D* JSPaintRenderingContext2D::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPaintRenderingContext2D*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CSS_PAINTING_API)
