/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPayerErrorFields.h"

#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PayerErrorFields convertDictionary<PayerErrorFields>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PayerErrorFields result;
    JSValue emailValue;
    if (isNullOrUndefined)
        emailValue = jsUndefined();
    else {
        emailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "email"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!emailValue.isUndefined()) {
        result.email = convert<IDLDOMString>(lexicalGlobalObject, emailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue phoneValue;
    if (isNullOrUndefined)
        phoneValue = jsUndefined();
    else {
        phoneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "phone"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!phoneValue.isUndefined()) {
        result.phone = convert<IDLDOMString>(lexicalGlobalObject, phoneValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
