/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentMethodChangeEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PaymentMethodChangeEvent::Init convertDictionary<PaymentMethodChangeEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PaymentMethodChangeEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue methodDetailsValue;
    if (isNullOrUndefined)
        methodDetailsValue = jsUndefined();
    else {
        methodDetailsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "methodDetails"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!methodDetailsValue.isUndefined()) {
        result.methodDetails = convert<IDLNullable<IDLObject>>(lexicalGlobalObject, methodDetailsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue methodNameValue;
    if (isNullOrUndefined)
        methodNameValue = jsUndefined();
    else {
        methodNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "methodName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!methodNameValue.isUndefined()) {
        result.methodName = convert<IDLDOMString>(lexicalGlobalObject, methodNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.methodName = emptyString();
    return result;
}

#endif

// Attributes

JSC::EncodedJSValue jsPaymentMethodChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentMethodChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentMethodChangeEventMethodName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentMethodChangeEventMethodDetails(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPaymentMethodChangeEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPaymentMethodChangeEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPaymentMethodChangeEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPaymentMethodChangeEventPrototype>(vm.heap)) JSPaymentMethodChangeEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPaymentMethodChangeEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPaymentMethodChangeEventPrototype, JSPaymentMethodChangeEventPrototype::Base);

using JSPaymentMethodChangeEventConstructor = JSDOMConstructor<JSPaymentMethodChangeEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSPaymentMethodChangeEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSPaymentMethodChangeEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<PaymentMethodChangeEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = PaymentMethodChangeEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<PaymentMethodChangeEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSPaymentMethodChangeEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSPaymentRequestUpdateEvent::getConstructor(vm, &globalObject);
}

template<> void JSPaymentMethodChangeEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPaymentMethodChangeEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaymentMethodChangeEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaymentMethodChangeEventConstructor::s_info = { "PaymentMethodChangeEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentMethodChangeEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPaymentMethodChangeEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentMethodChangeEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentMethodChangeEventConstructor) } },
    { "methodName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentMethodChangeEventMethodName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "methodDetails", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentMethodChangeEventMethodDetails), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSPaymentMethodChangeEventPrototype::s_info = { "PaymentMethodChangeEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentMethodChangeEventPrototype) };

void JSPaymentMethodChangeEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPaymentMethodChangeEvent::info(), JSPaymentMethodChangeEventPrototypeTableValues, *this);
}

const ClassInfo JSPaymentMethodChangeEvent::s_info = { "PaymentMethodChangeEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentMethodChangeEvent) };

JSPaymentMethodChangeEvent::JSPaymentMethodChangeEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PaymentMethodChangeEvent>&& impl)
    : JSPaymentRequestUpdateEvent(structure, globalObject, WTFMove(impl))
{
}

void JSPaymentMethodChangeEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PaymentMethodChangeEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPaymentMethodChangeEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPaymentMethodChangeEventPrototype::create(vm, &globalObject, JSPaymentMethodChangeEventPrototype::createStructure(vm, &globalObject, JSPaymentRequestUpdateEvent::prototype(vm, globalObject)));
}

JSObject* JSPaymentMethodChangeEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPaymentMethodChangeEvent>(vm, globalObject);
}

JSValue JSPaymentMethodChangeEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaymentMethodChangeEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPaymentMethodChangeEvent* IDLAttribute<JSPaymentMethodChangeEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPaymentMethodChangeEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsPaymentMethodChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentMethodChangeEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaymentMethodChangeEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaymentMethodChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentMethodChangeEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPaymentMethodChangeEventMethodNameGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentMethodChangeEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.methodName());
    return result;
}

EncodedJSValue jsPaymentMethodChangeEventMethodName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentMethodChangeEvent>::get<jsPaymentMethodChangeEventMethodNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "methodName");
}

static inline JSValue jsPaymentMethodChangeEventMethodDetailsGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentMethodChangeEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.methodDetails(lexicalGlobalObject);
}

EncodedJSValue jsPaymentMethodChangeEventMethodDetails(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentMethodChangeEvent>::get<jsPaymentMethodChangeEventMethodDetailsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "methodDetails");
}

void JSPaymentMethodChangeEvent::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaymentMethodChangeEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaymentMethodChangeEvent::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaymentMethodChangeEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaymentMethodChangeEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaymentMethodChangeEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PaymentMethodChangeEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24PaymentMethodChangeEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PaymentMethodChangeEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PaymentMethodChangeEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24PaymentMethodChangeEventE[2];
#endif

    // If this fails PaymentMethodChangeEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PaymentMethodChangeEvent>::value, "PaymentMethodChangeEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PaymentMethodChangeEvent has subclasses. If PaymentMethodChangeEvent has subclasses that get passed
    // to toJS() we currently require PaymentMethodChangeEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PaymentMethodChangeEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentMethodChangeEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(PAYMENT_REQUEST)
