/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSPaymentShippingType.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PaymentOptions convertDictionary<PaymentOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PaymentOptions result;
    JSValue requestPayerEmailValue;
    if (isNullOrUndefined)
        requestPayerEmailValue = jsUndefined();
    else {
        requestPayerEmailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestPayerEmail"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestPayerEmailValue.isUndefined()) {
        result.requestPayerEmail = convert<IDLBoolean>(lexicalGlobalObject, requestPayerEmailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.requestPayerEmail = false;
    JSValue requestPayerNameValue;
    if (isNullOrUndefined)
        requestPayerNameValue = jsUndefined();
    else {
        requestPayerNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestPayerName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestPayerNameValue.isUndefined()) {
        result.requestPayerName = convert<IDLBoolean>(lexicalGlobalObject, requestPayerNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.requestPayerName = false;
    JSValue requestPayerPhoneValue;
    if (isNullOrUndefined)
        requestPayerPhoneValue = jsUndefined();
    else {
        requestPayerPhoneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestPayerPhone"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestPayerPhoneValue.isUndefined()) {
        result.requestPayerPhone = convert<IDLBoolean>(lexicalGlobalObject, requestPayerPhoneValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.requestPayerPhone = false;
    JSValue requestShippingValue;
    if (isNullOrUndefined)
        requestShippingValue = jsUndefined();
    else {
        requestShippingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestShipping"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestShippingValue.isUndefined()) {
        result.requestShipping = convert<IDLBoolean>(lexicalGlobalObject, requestShippingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.requestShipping = false;
    JSValue shippingTypeValue;
    if (isNullOrUndefined)
        shippingTypeValue = jsUndefined();
    else {
        shippingTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shippingType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shippingTypeValue.isUndefined()) {
        result.shippingType = convert<IDLEnumeration<PaymentShippingType>>(lexicalGlobalObject, shippingTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.shippingType = PaymentShippingType::Shipping;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
