/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentRequest.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSPaymentAddress.h"
#include "JSPaymentDetailsUpdate.h"
#include "JSPaymentShippingType.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(PAYMENT_REQUEST)
#include "JSDOMConvertSequences.h"
#include "JSPaymentDetailsInit.h"
#include "JSPaymentMethodData.h"
#include "JSPaymentOptions.h"
#include <JavaScriptCore/JSArray.h>
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPaymentRequestPrototypeFunctionShow(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaymentRequestPrototypeFunctionAbort(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaymentRequestPrototypeFunctionCanMakePayment(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPaymentRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentRequestId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentRequestShippingAddress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentRequestShippingOption(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentRequestShippingType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentRequestOnmerchantvalidation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentRequestOnmerchantvalidation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentRequestOnshippingaddresschange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentRequestOnshippingaddresschange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentRequestOnshippingoptionchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentRequestOnshippingoptionchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentRequestOnpaymentmethodchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentRequestOnpaymentmethodchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPaymentRequestPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPaymentRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPaymentRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSPaymentRequestPrototype>(vm.heap)) JSPaymentRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPaymentRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPaymentRequestPrototype, JSPaymentRequestPrototype::Base);

using JSPaymentRequestConstructor = JSDOMConstructor<JSPaymentRequest>;

template<> EncodedJSValue JSC_HOST_CALL JSPaymentRequestConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSPaymentRequestConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "PaymentRequest");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto methodData = convert<IDLSequence<IDLDictionary<PaymentMethodData>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto details = convert<IDLDictionary<PaymentDetailsInit>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<PaymentOptions>>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = PaymentRequest::create(document, WTFMove(methodData), WTFMove(details), WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<PaymentRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSPaymentRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSPaymentRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPaymentRequest::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaymentRequest"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaymentRequestConstructor::s_info = { "PaymentRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPaymentRequestPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentRequestConstructor) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shippingAddress", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestShippingAddress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shippingOption", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestShippingOption), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shippingType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestShippingType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onmerchantvalidation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestOnmerchantvalidation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentRequestOnmerchantvalidation) } },
    { "onshippingaddresschange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestOnshippingaddresschange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentRequestOnshippingaddresschange) } },
    { "onshippingoptionchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestOnshippingoptionchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentRequestOnshippingoptionchange) } },
    { "onpaymentmethodchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestOnpaymentmethodchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentRequestOnpaymentmethodchange) } },
    { "show", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentRequestPrototypeFunctionShow), (intptr_t) (0) } },
    { "abort", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentRequestPrototypeFunctionAbort), (intptr_t) (0) } },
    { "canMakePayment", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentRequestPrototypeFunctionCanMakePayment), (intptr_t) (0) } },
};

const ClassInfo JSPaymentRequestPrototype::s_info = { "PaymentRequestPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentRequestPrototype) };

void JSPaymentRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPaymentRequest::info(), JSPaymentRequestPrototypeTableValues, *this);
}

const ClassInfo JSPaymentRequest::s_info = { "PaymentRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentRequest) };

JSPaymentRequest::JSPaymentRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PaymentRequest>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSPaymentRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, PaymentRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSPaymentRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPaymentRequestPrototype::create(vm, &globalObject, JSPaymentRequestPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSPaymentRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPaymentRequest>(vm, globalObject);
}

JSValue JSPaymentRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaymentRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPaymentRequest* IDLAttribute<JSPaymentRequest>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPaymentRequest*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPaymentRequest* IDLOperation<JSPaymentRequest>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPaymentRequest*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPaymentRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaymentRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaymentRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPaymentRequestIdGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsPaymentRequestId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSValue jsPaymentRequestShippingAddressGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<PaymentAddress>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.shippingAddress());
    return result;
}

EncodedJSValue jsPaymentRequestShippingAddress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestShippingAddressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shippingAddress");
}

static inline JSValue jsPaymentRequestShippingOptionGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.shippingOption());
    return result;
}

EncodedJSValue jsPaymentRequestShippingOption(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestShippingOptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shippingOption");
}

static inline JSValue jsPaymentRequestShippingTypeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLEnumeration<PaymentShippingType>>>(lexicalGlobalObject, throwScope, impl.shippingType());
    return result;
}

EncodedJSValue jsPaymentRequestShippingType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestShippingTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shippingType");
}

static inline JSValue jsPaymentRequestOnmerchantvalidationGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().merchantvalidationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsPaymentRequestOnmerchantvalidation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestOnmerchantvalidationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmerchantvalidation");
}

static inline bool setJSPaymentRequestOnmerchantvalidationSetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().merchantvalidationEvent, value);
    return true;
}

bool setJSPaymentRequestOnmerchantvalidation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaymentRequest>::set<setJSPaymentRequestOnmerchantvalidationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmerchantvalidation");
}

static inline JSValue jsPaymentRequestOnshippingaddresschangeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().shippingaddresschangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsPaymentRequestOnshippingaddresschange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestOnshippingaddresschangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onshippingaddresschange");
}

static inline bool setJSPaymentRequestOnshippingaddresschangeSetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().shippingaddresschangeEvent, value);
    return true;
}

bool setJSPaymentRequestOnshippingaddresschange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaymentRequest>::set<setJSPaymentRequestOnshippingaddresschangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onshippingaddresschange");
}

static inline JSValue jsPaymentRequestOnshippingoptionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().shippingoptionchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsPaymentRequestOnshippingoptionchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestOnshippingoptionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onshippingoptionchange");
}

static inline bool setJSPaymentRequestOnshippingoptionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().shippingoptionchangeEvent, value);
    return true;
}

bool setJSPaymentRequestOnshippingoptionchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaymentRequest>::set<setJSPaymentRequestOnshippingoptionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onshippingoptionchange");
}

static inline JSValue jsPaymentRequestOnpaymentmethodchangeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().paymentmethodchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsPaymentRequestOnpaymentmethodchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentRequest>::get<jsPaymentRequestOnpaymentmethodchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpaymentmethodchange");
}

static inline bool setJSPaymentRequestOnpaymentmethodchangeSetter(JSGlobalObject& lexicalGlobalObject, JSPaymentRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().paymentmethodchangeEvent, value);
    return true;
}

bool setJSPaymentRequestOnpaymentmethodchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaymentRequest>::set<setJSPaymentRequestOnpaymentmethodchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpaymentmethodchange");
}

static inline JSC::EncodedJSValue jsPaymentRequestPrototypeFunctionShowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPaymentRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto detailsPromise = callFrame->argument(0).isUndefined() ? nullptr : convert<IDLPromise<IDLDictionary<PaymentDetailsUpdate>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.show(document, WTFMove(detailsPromise), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaymentRequestPrototypeFunctionShow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSPaymentRequest>::call<jsPaymentRequestPrototypeFunctionShowBody>(*lexicalGlobalObject, *callFrame, "show");
}

static inline JSC::EncodedJSValue jsPaymentRequestPrototypeFunctionAbortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPaymentRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.abort(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaymentRequestPrototypeFunctionAbort(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSPaymentRequest>::call<jsPaymentRequestPrototypeFunctionAbortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

static inline JSC::EncodedJSValue jsPaymentRequestPrototypeFunctionCanMakePaymentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPaymentRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    impl.canMakePayment(document, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaymentRequestPrototypeFunctionCanMakePayment(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSPaymentRequest>::call<jsPaymentRequestPrototypeFunctionCanMakePaymentBody>(*lexicalGlobalObject, *callFrame, "canMakePayment");
}

void JSPaymentRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaymentRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPaymentRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsPaymentRequest = jsCast<JSPaymentRequest*>(handle.slot()->asCell());
    if (jsPaymentRequest->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsPaymentRequest->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPaymentRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPaymentRequest = static_cast<JSPaymentRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPaymentRequest->wrapped(), jsPaymentRequest);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PaymentRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14PaymentRequestE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PaymentRequest>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PaymentRequest@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14PaymentRequestE[2];
#endif

    // If this fails PaymentRequest does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PaymentRequest>::value, "PaymentRequest is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PaymentRequest has subclasses. If PaymentRequest has subclasses that get passed
    // to toJS() we currently require PaymentRequest you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PaymentRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PaymentRequest* JSPaymentRequest::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPaymentRequest*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(PAYMENT_REQUEST)
