/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentResponse.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSPaymentAddress.h"
#include "JSPaymentComplete.h"
#include "JSPaymentValidationErrors.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPaymentResponsePrototypeFunctionComplete(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaymentResponsePrototypeFunctionRetry(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPaymentResponsePrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPaymentResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentResponseRequestId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponseMethodName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponseDetails(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponseShippingAddress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponseShippingOption(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponsePayerName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponsePayerEmail(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponsePayerPhone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentResponseOnpayerdetailchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentResponseOnpayerdetailchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPaymentResponsePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPaymentResponsePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPaymentResponsePrototype* ptr = new (NotNull, JSC::allocateCell<JSPaymentResponsePrototype>(vm.heap)) JSPaymentResponsePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPaymentResponsePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPaymentResponsePrototype, JSPaymentResponsePrototype::Base);

using JSPaymentResponseConstructor = JSDOMConstructorNotConstructable<JSPaymentResponse>;

template<> JSValue JSPaymentResponseConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSPaymentResponseConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPaymentResponse::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaymentResponse"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaymentResponseConstructor::s_info = { "PaymentResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentResponseConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPaymentResponsePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentResponseConstructor) } },
    { "requestId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseRequestId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "methodName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseMethodName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "details", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseDetails), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shippingAddress", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseShippingAddress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shippingOption", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseShippingOption), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "payerName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponsePayerName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "payerEmail", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponsePayerEmail), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "payerPhone", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponsePayerPhone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onpayerdetailchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentResponseOnpayerdetailchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentResponseOnpayerdetailchange) } },
    { "complete", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentResponsePrototypeFunctionComplete), (intptr_t) (0) } },
    { "retry", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentResponsePrototypeFunctionRetry), (intptr_t) (0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentResponsePrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSPaymentResponsePrototype::s_info = { "PaymentResponsePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentResponsePrototype) };

void JSPaymentResponsePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPaymentResponse::info(), JSPaymentResponsePrototypeTableValues, *this);
}

const ClassInfo JSPaymentResponse::s_info = { "PaymentResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentResponse) };

JSPaymentResponse::JSPaymentResponse(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PaymentResponse>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSPaymentResponse::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, PaymentResponse>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSPaymentResponse::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPaymentResponsePrototype::create(vm, &globalObject, JSPaymentResponsePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSPaymentResponse::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPaymentResponse>(vm, globalObject);
}

JSValue JSPaymentResponse::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaymentResponseConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPaymentResponse* IDLAttribute<JSPaymentResponse>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPaymentResponse*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPaymentResponse* IDLOperation<JSPaymentResponse>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPaymentResponse*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPaymentResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaymentResponse::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaymentResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPaymentResponseRequestIdGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.requestId());
    return result;
}

EncodedJSValue jsPaymentResponseRequestId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponseRequestIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "requestId");
}

static inline JSValue jsPaymentResponseMethodNameGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.methodName());
    return result;
}

EncodedJSValue jsPaymentResponseMethodName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponseMethodNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "methodName");
}

static inline JSValue jsPaymentResponseDetailsGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.details(lexicalGlobalObject);
}

EncodedJSValue jsPaymentResponseDetails(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponseDetailsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "details");
}

static inline JSValue jsPaymentResponseShippingAddressGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<PaymentAddress>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.shippingAddress());
    return result;
}

EncodedJSValue jsPaymentResponseShippingAddress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponseShippingAddressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shippingAddress");
}

static inline JSValue jsPaymentResponseShippingOptionGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.shippingOption());
    return result;
}

EncodedJSValue jsPaymentResponseShippingOption(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponseShippingOptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shippingOption");
}

static inline JSValue jsPaymentResponsePayerNameGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.payerName());
    return result;
}

EncodedJSValue jsPaymentResponsePayerName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponsePayerNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "payerName");
}

static inline JSValue jsPaymentResponsePayerEmailGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.payerEmail());
    return result;
}

EncodedJSValue jsPaymentResponsePayerEmail(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponsePayerEmailGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "payerEmail");
}

static inline JSValue jsPaymentResponsePayerPhoneGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.payerPhone());
    return result;
}

EncodedJSValue jsPaymentResponsePayerPhone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponsePayerPhoneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "payerPhone");
}

static inline JSValue jsPaymentResponseOnpayerdetailchangeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().payerdetailchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsPaymentResponseOnpayerdetailchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentResponse>::get<jsPaymentResponseOnpayerdetailchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpayerdetailchange");
}

static inline bool setJSPaymentResponseOnpayerdetailchangeSetter(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().payerdetailchangeEvent, value);
    return true;
}

bool setJSPaymentResponseOnpayerdetailchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaymentResponse>::set<setJSPaymentResponseOnpayerdetailchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpayerdetailchange");
}

static inline JSC::EncodedJSValue jsPaymentResponsePrototypeFunctionCompleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPaymentResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto result = callFrame->argument(0).isUndefined() ? PaymentComplete::Unknown : convert<IDLEnumeration<PaymentComplete>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "result", "PaymentResponse", "complete", expectedEnumerationValues<PaymentComplete>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.complete(WTFMove(result), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaymentResponsePrototypeFunctionComplete(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSPaymentResponse>::call<jsPaymentResponsePrototypeFunctionCompleteBody>(*lexicalGlobalObject, *callFrame, "complete");
}

static inline JSC::EncodedJSValue jsPaymentResponsePrototypeFunctionRetryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPaymentResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto errorFields = convert<IDLDictionary<PaymentValidationErrors>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.retry(WTFMove(errorFields), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaymentResponsePrototypeFunctionRetry(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSPaymentResponse>::call<jsPaymentResponsePrototypeFunctionRetryBody>(*lexicalGlobalObject, *callFrame, "retry");
}

JSC::JSObject* JSPaymentResponse::serialize(JSGlobalObject& lexicalGlobalObject, JSPaymentResponse& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto requestIdValue = jsPaymentResponseRequestIdGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "requestId"), requestIdValue);

    auto methodNameValue = jsPaymentResponseMethodNameGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "methodName"), methodNameValue);

    auto shippingAddressValue = jsPaymentResponseShippingAddressGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    if (!shippingAddressValue.isNull()) {
        auto* shippingAddressSerializedValue = JSPaymentAddress::serialize(lexicalGlobalObject, *jsCast<JSPaymentAddress*>(shippingAddressValue), globalObject, throwScope);
        result->putDirect(vm, Identifier::fromString(vm, "shippingAddress"), shippingAddressSerializedValue);
    } else
        result->putDirect(vm, Identifier::fromString(vm, "shippingAddress"), shippingAddressValue);

    auto shippingOptionValue = jsPaymentResponseShippingOptionGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "shippingOption"), shippingOptionValue);

    auto payerNameValue = jsPaymentResponsePayerNameGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "payerName"), payerNameValue);

    auto payerEmailValue = jsPaymentResponsePayerEmailGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "payerEmail"), payerEmailValue);

    auto payerPhoneValue = jsPaymentResponsePayerPhoneGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "payerPhone"), payerPhoneValue);

    return result;
}

static inline EncodedJSValue jsPaymentResponsePrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSPaymentResponse* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSPaymentResponse::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsPaymentResponsePrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaymentResponse>::call<jsPaymentResponsePrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSPaymentResponse::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaymentResponse*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaymentResponse::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaymentResponse*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaymentResponse::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaymentResponse*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPaymentResponseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsPaymentResponse = jsCast<JSPaymentResponse*>(handle.slot()->asCell());
    if (jsPaymentResponse->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsPaymentResponse->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPaymentResponseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPaymentResponse = static_cast<JSPaymentResponse*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPaymentResponse->wrapped(), jsPaymentResponse);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PaymentResponse@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15PaymentResponseE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PaymentResponse>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PaymentResponse@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15PaymentResponseE[2];
#endif

    // If this fails PaymentResponse does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PaymentResponse>::value, "PaymentResponse is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PaymentResponse has subclasses. If PaymentResponse has subclasses that get passed
    // to toJS() we currently require PaymentResponse you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PaymentResponse>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentResponse& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PaymentResponse* JSPaymentResponse::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPaymentResponse*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(PAYMENT_REQUEST)
