/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceObserverEntryList.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPerformanceEntry.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceObserverEntryListPrototypeFunctionGetEntries(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByName(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPerformanceObserverEntryListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPerformanceObserverEntryListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPerformanceObserverEntryListPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceObserverEntryListPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceObserverEntryListPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceObserverEntryListPrototype>(vm.heap)) JSPerformanceObserverEntryListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceObserverEntryListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceObserverEntryListPrototype, JSPerformanceObserverEntryListPrototype::Base);

using JSPerformanceObserverEntryListConstructor = JSDOMConstructorNotConstructable<JSPerformanceObserverEntryList>;

template<> JSValue JSPerformanceObserverEntryListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceObserverEntryListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceObserverEntryList::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PerformanceObserverEntryList"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPerformanceObserverEntryListConstructor::s_info = { "PerformanceObserverEntryList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverEntryListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformanceObserverEntryListPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceObserverEntryListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceObserverEntryListConstructor) } },
    { "getEntries", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceObserverEntryListPrototypeFunctionGetEntries), (intptr_t) (0) } },
    { "getEntriesByType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByType), (intptr_t) (1) } },
    { "getEntriesByName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByName), (intptr_t) (1) } },
};

const ClassInfo JSPerformanceObserverEntryListPrototype::s_info = { "PerformanceObserverEntryListPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverEntryListPrototype) };

void JSPerformanceObserverEntryListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceObserverEntryList::info(), JSPerformanceObserverEntryListPrototypeTableValues, *this);
}

const ClassInfo JSPerformanceObserverEntryList::s_info = { "PerformanceObserverEntryList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverEntryList) };

JSPerformanceObserverEntryList::JSPerformanceObserverEntryList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceObserverEntryList>&& impl)
    : JSDOMWrapper<PerformanceObserverEntryList>(structure, globalObject, WTFMove(impl))
{
}

void JSPerformanceObserverEntryList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PerformanceObserverEntryList>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPerformanceObserverEntryList::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPerformanceObserverEntryListPrototype::create(vm, &globalObject, JSPerformanceObserverEntryListPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSPerformanceObserverEntryList::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceObserverEntryList>(vm, globalObject);
}

JSValue JSPerformanceObserverEntryList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceObserverEntryListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPerformanceObserverEntryList::destroy(JSC::JSCell* cell)
{
    JSPerformanceObserverEntryList* thisObject = static_cast<JSPerformanceObserverEntryList*>(cell);
    thisObject->JSPerformanceObserverEntryList::~JSPerformanceObserverEntryList();
}

template<> inline JSPerformanceObserverEntryList* IDLOperation<JSPerformanceObserverEntryList>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPerformanceObserverEntryList*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPerformanceObserverEntryListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceObserverEntryListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceObserverEntryList::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPerformanceObserverEntryListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceObserverEntryListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsPerformanceObserverEntryListPrototypeFunctionGetEntriesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserverEntryList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<PerformanceEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getEntries()));
}

EncodedJSValue JSC_HOST_CALL jsPerformanceObserverEntryListPrototypeFunctionGetEntries(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceObserverEntryList>::call<jsPerformanceObserverEntryListPrototypeFunctionGetEntriesBody>(*lexicalGlobalObject, *callFrame, "getEntries");
}

static inline JSC::EncodedJSValue jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserverEntryList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<PerformanceEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getEntriesByType(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceObserverEntryList>::call<jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByTypeBody>(*lexicalGlobalObject, *callFrame, "getEntriesByType");
}

static inline JSC::EncodedJSValue jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserverEntryList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = callFrame->argument(1).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<PerformanceEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getEntriesByName(WTFMove(name), WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceObserverEntryList>::call<jsPerformanceObserverEntryListPrototypeFunctionGetEntriesByNameBody>(*lexicalGlobalObject, *callFrame, "getEntriesByName");
}

void JSPerformanceObserverEntryList::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceObserverEntryList*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPerformanceObserverEntryListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPerformanceObserverEntryListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceObserverEntryList = static_cast<JSPerformanceObserverEntryList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPerformanceObserverEntryList->wrapped(), jsPerformanceObserverEntryList);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PerformanceObserverEntryList>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PerformanceObserverEntryList.
    static_assert(!std::is_polymorphic<PerformanceObserverEntryList>::value, "PerformanceObserverEntryList is polymorphic but the IDL claims it is not");
    return createWrapper<PerformanceObserverEntryList>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PerformanceObserverEntryList& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PerformanceObserverEntryList* JSPerformanceObserverEntryList::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceObserverEntryList*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
