/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceResourceTiming.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPerformanceServerTiming.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceResourceTimingPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPerformanceResourceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPerformanceResourceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPerformanceResourceTimingInitiatorType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingNextHopProtocol(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingWorkerStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingRedirectStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingRedirectEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingFetchStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingDomainLookupStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingDomainLookupEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingConnectStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingConnectEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingSecureConnectionStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingRequestStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingResponseStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingResponseEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceResourceTimingServerTiming(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPerformanceResourceTimingPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceResourceTimingPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceResourceTimingPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceResourceTimingPrototype>(vm.heap)) JSPerformanceResourceTimingPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceResourceTimingPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceResourceTimingPrototype, JSPerformanceResourceTimingPrototype::Base);

using JSPerformanceResourceTimingConstructor = JSDOMConstructorNotConstructable<JSPerformanceResourceTiming>;

template<> JSValue JSPerformanceResourceTimingConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSPerformanceEntry::getConstructor(vm, &globalObject);
}

template<> void JSPerformanceResourceTimingConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceResourceTiming::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PerformanceResourceTiming"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPerformanceResourceTimingConstructor::s_info = { "PerformanceResourceTiming", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceResourceTimingConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformanceResourceTimingPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceResourceTimingConstructor) } },
    { "initiatorType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingInitiatorType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextHopProtocol", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingNextHopProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "workerStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingWorkerStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingRedirectStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingRedirectEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fetchStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingFetchStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domainLookupStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingDomainLookupStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domainLookupEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingDomainLookupEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingConnectStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingConnectEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "secureConnectionStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingSecureConnectionStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "requestStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingRequestStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingResponseStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingResponseEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "serverTiming", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceResourceTimingServerTiming), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceResourceTimingPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSPerformanceResourceTimingPrototype::s_info = { "PerformanceResourceTimingPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceResourceTimingPrototype) };

void JSPerformanceResourceTimingPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceResourceTiming::info(), JSPerformanceResourceTimingPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().serverTimingEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("serverTiming"), strlen("serverTiming"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSPerformanceResourceTiming::s_info = { "PerformanceResourceTiming", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceResourceTiming) };

JSPerformanceResourceTiming::JSPerformanceResourceTiming(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceResourceTiming>&& impl)
    : JSPerformanceEntry(structure, globalObject, WTFMove(impl))
{
}

void JSPerformanceResourceTiming::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PerformanceResourceTiming>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPerformanceResourceTiming::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPerformanceResourceTimingPrototype::create(vm, &globalObject, JSPerformanceResourceTimingPrototype::createStructure(vm, &globalObject, JSPerformanceEntry::prototype(vm, globalObject)));
}

JSObject* JSPerformanceResourceTiming::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceResourceTiming>(vm, globalObject);
}

JSValue JSPerformanceResourceTiming::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceResourceTimingConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPerformanceResourceTiming* IDLAttribute<JSPerformanceResourceTiming>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPerformanceResourceTiming*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPerformanceResourceTiming* IDLOperation<JSPerformanceResourceTiming>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPerformanceResourceTiming*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPerformanceResourceTimingConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceResourceTimingPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceResourceTiming::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPerformanceResourceTimingConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceResourceTimingPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPerformanceResourceTimingInitiatorTypeGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.initiatorType());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingInitiatorType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingInitiatorTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "initiatorType");
}

static inline JSValue jsPerformanceResourceTimingNextHopProtocolGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.nextHopProtocol());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingNextHopProtocol(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingNextHopProtocolGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "nextHopProtocol");
}

static inline JSValue jsPerformanceResourceTimingWorkerStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.workerStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingWorkerStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingWorkerStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "workerStart");
}

static inline JSValue jsPerformanceResourceTimingRedirectStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.redirectStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingRedirectStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingRedirectStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "redirectStart");
}

static inline JSValue jsPerformanceResourceTimingRedirectEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.redirectEnd());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingRedirectEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingRedirectEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "redirectEnd");
}

static inline JSValue jsPerformanceResourceTimingFetchStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.fetchStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingFetchStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingFetchStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fetchStart");
}

static inline JSValue jsPerformanceResourceTimingDomainLookupStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.domainLookupStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingDomainLookupStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingDomainLookupStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domainLookupStart");
}

static inline JSValue jsPerformanceResourceTimingDomainLookupEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.domainLookupEnd());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingDomainLookupEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingDomainLookupEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domainLookupEnd");
}

static inline JSValue jsPerformanceResourceTimingConnectStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.connectStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingConnectStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingConnectStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "connectStart");
}

static inline JSValue jsPerformanceResourceTimingConnectEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.connectEnd());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingConnectEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingConnectEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "connectEnd");
}

static inline JSValue jsPerformanceResourceTimingSecureConnectionStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.secureConnectionStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingSecureConnectionStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingSecureConnectionStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "secureConnectionStart");
}

static inline JSValue jsPerformanceResourceTimingRequestStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.requestStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingRequestStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingRequestStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "requestStart");
}

static inline JSValue jsPerformanceResourceTimingResponseStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.responseStart());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingResponseStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingResponseStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseStart");
}

static inline JSValue jsPerformanceResourceTimingResponseEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.responseEnd());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingResponseEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingResponseEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseEnd");
}

static inline JSValue jsPerformanceResourceTimingServerTimingGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFrozenArray<IDLInterface<PerformanceServerTiming>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.serverTiming());
    return result;
}

EncodedJSValue jsPerformanceResourceTimingServerTiming(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceResourceTiming>::get<jsPerformanceResourceTimingServerTimingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "serverTiming");
}

JSC::JSObject* JSPerformanceResourceTiming::serialize(JSGlobalObject& lexicalGlobalObject, JSPerformanceResourceTiming& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = JSPerformanceEntry::serialize(lexicalGlobalObject, thisObject, globalObject, throwScope);

    auto initiatorTypeValue = jsPerformanceResourceTimingInitiatorTypeGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "initiatorType"), initiatorTypeValue);

    auto nextHopProtocolValue = jsPerformanceResourceTimingNextHopProtocolGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "nextHopProtocol"), nextHopProtocolValue);

    auto workerStartValue = jsPerformanceResourceTimingWorkerStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "workerStart"), workerStartValue);

    auto redirectStartValue = jsPerformanceResourceTimingRedirectStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "redirectStart"), redirectStartValue);

    auto redirectEndValue = jsPerformanceResourceTimingRedirectEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "redirectEnd"), redirectEndValue);

    auto fetchStartValue = jsPerformanceResourceTimingFetchStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "fetchStart"), fetchStartValue);

    auto domainLookupStartValue = jsPerformanceResourceTimingDomainLookupStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupStart"), domainLookupStartValue);

    auto domainLookupEndValue = jsPerformanceResourceTimingDomainLookupEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupEnd"), domainLookupEndValue);

    auto connectStartValue = jsPerformanceResourceTimingConnectStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "connectStart"), connectStartValue);

    auto connectEndValue = jsPerformanceResourceTimingConnectEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "connectEnd"), connectEndValue);

    auto secureConnectionStartValue = jsPerformanceResourceTimingSecureConnectionStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "secureConnectionStart"), secureConnectionStartValue);

    auto requestStartValue = jsPerformanceResourceTimingRequestStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "requestStart"), requestStartValue);

    auto responseStartValue = jsPerformanceResourceTimingResponseStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "responseStart"), responseStartValue);

    auto responseEndValue = jsPerformanceResourceTimingResponseEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "responseEnd"), responseEndValue);

    return result;
}

static inline EncodedJSValue jsPerformanceResourceTimingPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSPerformanceResourceTiming* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSPerformanceResourceTiming::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsPerformanceResourceTimingPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceResourceTiming>::call<jsPerformanceResourceTimingPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSPerformanceResourceTiming::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceResourceTiming*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
