/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceTiming.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceTimingPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPerformanceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPerformanceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPerformanceTimingNavigationStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingUnloadEventStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingUnloadEventEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingRedirectStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingRedirectEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingFetchStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomainLookupStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomainLookupEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingConnectStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingConnectEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingSecureConnectionStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingRequestStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingResponseStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingResponseEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomLoading(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomInteractive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomContentLoadedEventStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomContentLoadedEventEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingDomComplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingLoadEventStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTimingLoadEventEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPerformanceTimingPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceTimingPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceTimingPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceTimingPrototype>(vm.heap)) JSPerformanceTimingPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceTimingPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceTimingPrototype, JSPerformanceTimingPrototype::Base);

using JSPerformanceTimingConstructor = JSDOMConstructorNotConstructable<JSPerformanceTiming>;

template<> JSValue JSPerformanceTimingConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceTimingConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceTiming::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PerformanceTiming"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPerformanceTimingConstructor::s_info = { "PerformanceTiming", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceTimingConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformanceTimingPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceTimingConstructor) } },
    { "navigationStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingNavigationStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "unloadEventStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingUnloadEventStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "unloadEventEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingUnloadEventEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRedirectStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRedirectEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fetchStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingFetchStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domainLookupStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomainLookupStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domainLookupEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomainLookupEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConnectStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConnectEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "secureConnectionStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingSecureConnectionStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "requestStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRequestStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingResponseStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingResponseEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domLoading", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomLoading), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domInteractive", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomInteractive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domContentLoadedEventStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomContentLoadedEventStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domContentLoadedEventEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomContentLoadedEventEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "domComplete", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomComplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loadEventStart", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingLoadEventStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loadEventEnd", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingLoadEventEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceTimingPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSPerformanceTimingPrototype::s_info = { "PerformanceTimingPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceTimingPrototype) };

void JSPerformanceTimingPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceTiming::info(), JSPerformanceTimingPrototypeTableValues, *this);
}

const ClassInfo JSPerformanceTiming::s_info = { "PerformanceTiming", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceTiming) };

JSPerformanceTiming::JSPerformanceTiming(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceTiming>&& impl)
    : JSDOMWrapper<PerformanceTiming>(structure, globalObject, WTFMove(impl))
{
}

void JSPerformanceTiming::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PerformanceTiming>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPerformanceTiming::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPerformanceTimingPrototype::create(vm, &globalObject, JSPerformanceTimingPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSPerformanceTiming::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceTiming>(vm, globalObject);
}

JSValue JSPerformanceTiming::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceTimingConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPerformanceTiming::destroy(JSC::JSCell* cell)
{
    JSPerformanceTiming* thisObject = static_cast<JSPerformanceTiming*>(cell);
    thisObject->JSPerformanceTiming::~JSPerformanceTiming();
}

template<> inline JSPerformanceTiming* IDLAttribute<JSPerformanceTiming>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPerformanceTiming*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPerformanceTiming* IDLOperation<JSPerformanceTiming>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPerformanceTiming*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPerformanceTimingConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceTimingPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceTiming::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPerformanceTimingConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceTimingPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPerformanceTimingNavigationStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.navigationStart());
    return result;
}

EncodedJSValue jsPerformanceTimingNavigationStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingNavigationStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "navigationStart");
}

static inline JSValue jsPerformanceTimingUnloadEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.unloadEventStart());
    return result;
}

EncodedJSValue jsPerformanceTimingUnloadEventStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingUnloadEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unloadEventStart");
}

static inline JSValue jsPerformanceTimingUnloadEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.unloadEventEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingUnloadEventEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingUnloadEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unloadEventEnd");
}

static inline JSValue jsPerformanceTimingRedirectStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.redirectStart());
    return result;
}

EncodedJSValue jsPerformanceTimingRedirectStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingRedirectStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "redirectStart");
}

static inline JSValue jsPerformanceTimingRedirectEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.redirectEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingRedirectEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingRedirectEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "redirectEnd");
}

static inline JSValue jsPerformanceTimingFetchStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.fetchStart());
    return result;
}

EncodedJSValue jsPerformanceTimingFetchStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingFetchStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fetchStart");
}

static inline JSValue jsPerformanceTimingDomainLookupStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domainLookupStart());
    return result;
}

EncodedJSValue jsPerformanceTimingDomainLookupStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomainLookupStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domainLookupStart");
}

static inline JSValue jsPerformanceTimingDomainLookupEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domainLookupEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingDomainLookupEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomainLookupEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domainLookupEnd");
}

static inline JSValue jsPerformanceTimingConnectStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.connectStart());
    return result;
}

EncodedJSValue jsPerformanceTimingConnectStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingConnectStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "connectStart");
}

static inline JSValue jsPerformanceTimingConnectEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.connectEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingConnectEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingConnectEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "connectEnd");
}

static inline JSValue jsPerformanceTimingSecureConnectionStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.secureConnectionStart());
    return result;
}

EncodedJSValue jsPerformanceTimingSecureConnectionStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingSecureConnectionStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "secureConnectionStart");
}

static inline JSValue jsPerformanceTimingRequestStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.requestStart());
    return result;
}

EncodedJSValue jsPerformanceTimingRequestStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingRequestStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "requestStart");
}

static inline JSValue jsPerformanceTimingResponseStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.responseStart());
    return result;
}

EncodedJSValue jsPerformanceTimingResponseStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingResponseStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseStart");
}

static inline JSValue jsPerformanceTimingResponseEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.responseEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingResponseEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingResponseEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "responseEnd");
}

static inline JSValue jsPerformanceTimingDomLoadingGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domLoading());
    return result;
}

EncodedJSValue jsPerformanceTimingDomLoading(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomLoadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domLoading");
}

static inline JSValue jsPerformanceTimingDomInteractiveGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domInteractive());
    return result;
}

EncodedJSValue jsPerformanceTimingDomInteractive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomInteractiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domInteractive");
}

static inline JSValue jsPerformanceTimingDomContentLoadedEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domContentLoadedEventStart());
    return result;
}

EncodedJSValue jsPerformanceTimingDomContentLoadedEventStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomContentLoadedEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domContentLoadedEventStart");
}

static inline JSValue jsPerformanceTimingDomContentLoadedEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domContentLoadedEventEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingDomContentLoadedEventEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomContentLoadedEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domContentLoadedEventEnd");
}

static inline JSValue jsPerformanceTimingDomCompleteGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.domComplete());
    return result;
}

EncodedJSValue jsPerformanceTimingDomComplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingDomCompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domComplete");
}

static inline JSValue jsPerformanceTimingLoadEventStartGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.loadEventStart());
    return result;
}

EncodedJSValue jsPerformanceTimingLoadEventStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingLoadEventStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loadEventStart");
}

static inline JSValue jsPerformanceTimingLoadEventEndGetter(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.loadEventEnd());
    return result;
}

EncodedJSValue jsPerformanceTimingLoadEventEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceTiming>::get<jsPerformanceTimingLoadEventEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loadEventEnd");
}

JSC::JSObject* JSPerformanceTiming::serialize(JSGlobalObject& lexicalGlobalObject, JSPerformanceTiming& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto navigationStartValue = jsPerformanceTimingNavigationStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "navigationStart"), navigationStartValue);

    auto unloadEventStartValue = jsPerformanceTimingUnloadEventStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "unloadEventStart"), unloadEventStartValue);

    auto unloadEventEndValue = jsPerformanceTimingUnloadEventEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "unloadEventEnd"), unloadEventEndValue);

    auto redirectStartValue = jsPerformanceTimingRedirectStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "redirectStart"), redirectStartValue);

    auto redirectEndValue = jsPerformanceTimingRedirectEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "redirectEnd"), redirectEndValue);

    auto fetchStartValue = jsPerformanceTimingFetchStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "fetchStart"), fetchStartValue);

    auto domainLookupStartValue = jsPerformanceTimingDomainLookupStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupStart"), domainLookupStartValue);

    auto domainLookupEndValue = jsPerformanceTimingDomainLookupEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domainLookupEnd"), domainLookupEndValue);

    auto connectStartValue = jsPerformanceTimingConnectStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "connectStart"), connectStartValue);

    auto connectEndValue = jsPerformanceTimingConnectEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "connectEnd"), connectEndValue);

    auto secureConnectionStartValue = jsPerformanceTimingSecureConnectionStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "secureConnectionStart"), secureConnectionStartValue);

    auto requestStartValue = jsPerformanceTimingRequestStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "requestStart"), requestStartValue);

    auto responseStartValue = jsPerformanceTimingResponseStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "responseStart"), responseStartValue);

    auto responseEndValue = jsPerformanceTimingResponseEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "responseEnd"), responseEndValue);

    auto domLoadingValue = jsPerformanceTimingDomLoadingGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domLoading"), domLoadingValue);

    auto domInteractiveValue = jsPerformanceTimingDomInteractiveGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domInteractive"), domInteractiveValue);

    auto domContentLoadedEventStartValue = jsPerformanceTimingDomContentLoadedEventStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domContentLoadedEventStart"), domContentLoadedEventStartValue);

    auto domContentLoadedEventEndValue = jsPerformanceTimingDomContentLoadedEventEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domContentLoadedEventEnd"), domContentLoadedEventEndValue);

    auto domCompleteValue = jsPerformanceTimingDomCompleteGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "domComplete"), domCompleteValue);

    auto loadEventStartValue = jsPerformanceTimingLoadEventStartGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "loadEventStart"), loadEventStartValue);

    auto loadEventEndValue = jsPerformanceTimingLoadEventEndGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "loadEventEnd"), loadEventEndValue);

    return result;
}

static inline EncodedJSValue jsPerformanceTimingPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSPerformanceTiming* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSPerformanceTiming::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsPerformanceTimingPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceTiming>::call<jsPerformanceTimingPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSPerformanceTiming::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceTiming*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPerformanceTimingOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPerformanceTimingOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceTiming = static_cast<JSPerformanceTiming*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPerformanceTiming->wrapped(), jsPerformanceTiming);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PerformanceTiming>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PerformanceTiming.
    static_assert(!std::is_polymorphic<PerformanceTiming>::value, "PerformanceTiming is polymorphic but the IDL claims it is not");
    return createWrapper<PerformanceTiming>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PerformanceTiming& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PerformanceTiming* JSPerformanceTiming::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceTiming*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
