/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPeriodicWave.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsPeriodicWaveConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPeriodicWaveConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPeriodicWavePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPeriodicWavePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPeriodicWavePrototype* ptr = new (NotNull, JSC::allocateCell<JSPeriodicWavePrototype>(vm.heap)) JSPeriodicWavePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPeriodicWavePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPeriodicWavePrototype, JSPeriodicWavePrototype::Base);

using JSPeriodicWaveConstructor = JSDOMConstructorNotConstructable<JSPeriodicWave>;

template<> JSValue JSPeriodicWaveConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPeriodicWaveConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPeriodicWave::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PeriodicWave"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPeriodicWaveConstructor::s_info = { "PeriodicWave", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPeriodicWaveConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPeriodicWavePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPeriodicWaveConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPeriodicWaveConstructor) } },
};

const ClassInfo JSPeriodicWavePrototype::s_info = { "PeriodicWavePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPeriodicWavePrototype) };

void JSPeriodicWavePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPeriodicWave::info(), JSPeriodicWavePrototypeTableValues, *this);
}

const ClassInfo JSPeriodicWave::s_info = { "PeriodicWave", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPeriodicWave) };

JSPeriodicWave::JSPeriodicWave(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PeriodicWave>&& impl)
    : JSDOMWrapper<PeriodicWave>(structure, globalObject, WTFMove(impl))
{
}

void JSPeriodicWave::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PeriodicWave>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPeriodicWave::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPeriodicWavePrototype::create(vm, &globalObject, JSPeriodicWavePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSPeriodicWave::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPeriodicWave>(vm, globalObject);
}

JSValue JSPeriodicWave::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPeriodicWaveConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPeriodicWave::destroy(JSC::JSCell* cell)
{
    JSPeriodicWave* thisObject = static_cast<JSPeriodicWave*>(cell);
    thisObject->JSPeriodicWave::~JSPeriodicWave();
}

EncodedJSValue jsPeriodicWaveConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPeriodicWavePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPeriodicWave::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPeriodicWaveConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPeriodicWavePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSPeriodicWave::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPeriodicWave*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPeriodicWaveOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPeriodicWaveOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPeriodicWave = static_cast<JSPeriodicWave*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPeriodicWave->wrapped(), jsPeriodicWave);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PeriodicWave>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PeriodicWave.
    static_assert(!std::is_polymorphic<PeriodicWave>::value, "PeriodicWave is polymorphic but the IDL claims it is not");
    return createWrapper<PeriodicWave>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PeriodicWave& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PeriodicWave* JSPeriodicWave::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPeriodicWave*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
