/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPlaybackDirection.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(PlaybackDirection enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("normal"),
        MAKE_STATIC_STRING_IMPL("reverse"),
        MAKE_STATIC_STRING_IMPL("alternate"),
        MAKE_STATIC_STRING_IMPL("alternate-reverse"),
    };
    static_assert(static_cast<size_t>(PlaybackDirection::Normal) == 0, "PlaybackDirection::Normal is not 0 as expected");
    static_assert(static_cast<size_t>(PlaybackDirection::Reverse) == 1, "PlaybackDirection::Reverse is not 1 as expected");
    static_assert(static_cast<size_t>(PlaybackDirection::Alternate) == 2, "PlaybackDirection::Alternate is not 2 as expected");
    static_assert(static_cast<size_t>(PlaybackDirection::AlternateReverse) == 3, "PlaybackDirection::AlternateReverse is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, PlaybackDirection enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<PlaybackDirection> parseEnumeration<PlaybackDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "normal")
        return PlaybackDirection::Normal;
    if (stringValue == "reverse")
        return PlaybackDirection::Reverse;
    if (stringValue == "alternate")
        return PlaybackDirection::Alternate;
    if (stringValue == "alternate-reverse")
        return PlaybackDirection::AlternateReverse;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<PlaybackDirection>()
{
    return "\"normal\", \"reverse\", \"alternate\", \"alternate-reverse\"";
}

} // namespace WebCore
