/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(POINTER_EVENTS)

#include "JSPointerEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> PointerEvent::Init convertDictionary<PointerEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PointerEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!altKeyValue.isUndefined()) {
        result.altKey = convert<IDLBoolean>(lexicalGlobalObject, altKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.altKey = false;
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ctrlKeyValue.isUndefined()) {
        result.ctrlKey = convert<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ctrlKey = false;
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!metaKeyValue.isUndefined()) {
        result.metaKey = convert<IDLBoolean>(lexicalGlobalObject, metaKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.metaKey = false;
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierAltGraphValue.isUndefined()) {
        result.modifierAltGraph = convert<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierAltGraph = false;
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierCapsLockValue.isUndefined()) {
        result.modifierCapsLock = convert<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierCapsLock = false;
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shiftKeyValue.isUndefined()) {
        result.shiftKey = convert<IDLBoolean>(lexicalGlobalObject, shiftKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.shiftKey = false;
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonValue.isUndefined()) {
        result.button = convert<IDLShort>(lexicalGlobalObject, buttonValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.button = 0;
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonsValue.isUndefined()) {
        result.buttons = convert<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.buttons = 0;
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientXValue.isUndefined()) {
        result.clientX = convert<IDLLong>(lexicalGlobalObject, clientXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientX = 0;
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientYValue.isUndefined()) {
        result.clientY = convert<IDLLong>(lexicalGlobalObject, clientYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientY = 0;
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!relatedTargetValue.isUndefined()) {
        result.relatedTarget = convert<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.relatedTarget = nullptr;
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenXValue.isUndefined()) {
        result.screenX = convert<IDLLong>(lexicalGlobalObject, screenXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenX = 0;
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenYValue.isUndefined()) {
        result.screenY = convert<IDLLong>(lexicalGlobalObject, screenYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenY = 0;
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLDouble>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.height = 1;
    JSValue isPrimaryValue;
    if (isNullOrUndefined)
        isPrimaryValue = jsUndefined();
    else {
        isPrimaryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isPrimary"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isPrimaryValue.isUndefined()) {
        result.isPrimary = convert<IDLBoolean>(lexicalGlobalObject, isPrimaryValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isPrimary = false;
    JSValue pointerIdValue;
    if (isNullOrUndefined)
        pointerIdValue = jsUndefined();
    else {
        pointerIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pointerId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pointerIdValue.isUndefined()) {
        result.pointerId = convert<IDLLong>(lexicalGlobalObject, pointerIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pointerId = 0;
    JSValue pointerTypeValue;
    if (isNullOrUndefined)
        pointerTypeValue = jsUndefined();
    else {
        pointerTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pointerType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pointerTypeValue.isUndefined()) {
        result.pointerType = convert<IDLDOMString>(lexicalGlobalObject, pointerTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pointerType = emptyString();
    JSValue pressureValue;
    if (isNullOrUndefined)
        pressureValue = jsUndefined();
    else {
        pressureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pressure"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pressureValue.isUndefined()) {
        result.pressure = convert<IDLFloat>(lexicalGlobalObject, pressureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pressure = 0;
    JSValue tangentialPressureValue;
    if (isNullOrUndefined)
        tangentialPressureValue = jsUndefined();
    else {
        tangentialPressureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tangentialPressure"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tangentialPressureValue.isUndefined()) {
        result.tangentialPressure = convert<IDLFloat>(lexicalGlobalObject, tangentialPressureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tangentialPressure = 0;
    JSValue tiltXValue;
    if (isNullOrUndefined)
        tiltXValue = jsUndefined();
    else {
        tiltXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tiltX"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tiltXValue.isUndefined()) {
        result.tiltX = convert<IDLLong>(lexicalGlobalObject, tiltXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tiltX = 0;
    JSValue tiltYValue;
    if (isNullOrUndefined)
        tiltYValue = jsUndefined();
    else {
        tiltYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tiltY"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tiltYValue.isUndefined()) {
        result.tiltY = convert<IDLLong>(lexicalGlobalObject, tiltYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tiltY = 0;
    JSValue twistValue;
    if (isNullOrUndefined)
        twistValue = jsUndefined();
    else {
        twistValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "twist"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!twistValue.isUndefined()) {
        result.twist = convert<IDLLong>(lexicalGlobalObject, twistValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.twist = 0;
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLDouble>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.width = 1;
    return result;
}

// Attributes

JSC::EncodedJSValue jsPointerEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPointerEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPointerEventPointerId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventPressure(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventTangentialPressure(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventTiltX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventTiltY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventTwist(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventPointerType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPointerEventIsPrimary(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPointerEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPointerEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPointerEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPointerEventPrototype>(vm.heap)) JSPointerEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPointerEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPointerEventPrototype, JSPointerEventPrototype::Base);

using JSPointerEventConstructor = JSDOMConstructor<JSPointerEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSPointerEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSPointerEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<PointerEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = PointerEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<PointerEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSPointerEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSPointerEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPointerEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PointerEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPointerEventConstructor::s_info = { "PointerEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPointerEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPointerEventConstructor) } },
    { "pointerId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventPointerId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pressure", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventPressure), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tangentialPressure", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventTangentialPressure), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tiltX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventTiltX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tiltY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventTiltY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "twist", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventTwist), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pointerType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventPointerType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isPrimary", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPointerEventIsPrimary), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSPointerEventPrototype::s_info = { "PointerEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEventPrototype) };

void JSPointerEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPointerEvent::info(), JSPointerEventPrototypeTableValues, *this);
}

const ClassInfo JSPointerEvent::s_info = { "PointerEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEvent) };

JSPointerEvent::JSPointerEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PointerEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

void JSPointerEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PointerEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPointerEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPointerEventPrototype::create(vm, &globalObject, JSPointerEventPrototype::createStructure(vm, &globalObject, JSMouseEvent::prototype(vm, globalObject)));
}

JSObject* JSPointerEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPointerEvent>(vm, globalObject);
}

JSValue JSPointerEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPointerEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPointerEvent* IDLAttribute<JSPointerEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPointerEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsPointerEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPointerEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPointerEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPointerEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPointerEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPointerEventPointerIdGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.pointerId());
    return result;
}

EncodedJSValue jsPointerEventPointerId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventPointerIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pointerId");
}

static inline JSValue jsPointerEventWidthGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsPointerEventWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsPointerEventHeightGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.height());
    return result;
}

EncodedJSValue jsPointerEventHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsPointerEventPressureGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.pressure());
    return result;
}

EncodedJSValue jsPointerEventPressure(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventPressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pressure");
}

static inline JSValue jsPointerEventTangentialPressureGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.tangentialPressure());
    return result;
}

EncodedJSValue jsPointerEventTangentialPressure(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventTangentialPressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tangentialPressure");
}

static inline JSValue jsPointerEventTiltXGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tiltX());
    return result;
}

EncodedJSValue jsPointerEventTiltX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventTiltXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tiltX");
}

static inline JSValue jsPointerEventTiltYGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tiltY());
    return result;
}

EncodedJSValue jsPointerEventTiltY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventTiltYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tiltY");
}

static inline JSValue jsPointerEventTwistGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.twist());
    return result;
}

EncodedJSValue jsPointerEventTwist(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventTwistGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "twist");
}

static inline JSValue jsPointerEventPointerTypeGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pointerType());
    return result;
}

EncodedJSValue jsPointerEventPointerType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventPointerTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pointerType");
}

static inline JSValue jsPointerEventIsPrimaryGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isPrimary());
    return result;
}

EncodedJSValue jsPointerEventIsPrimary(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEventIsPrimaryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isPrimary");
}

void JSPointerEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPointerEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PointerEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12PointerEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PointerEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PointerEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12PointerEventE[2];
#endif

    // If this fails PointerEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PointerEvent>::value, "PointerEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PointerEvent has subclasses. If PointerEvent has subclasses that get passed
    // to toJS() we currently require PointerEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PointerEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PointerEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(POINTER_EVENTS)
