/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSProcessingInstruction.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSStyleSheet.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsProcessingInstructionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSProcessingInstructionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsProcessingInstructionTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsProcessingInstructionSheet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSProcessingInstructionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSProcessingInstructionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSProcessingInstructionPrototype* ptr = new (NotNull, JSC::allocateCell<JSProcessingInstructionPrototype>(vm.heap)) JSProcessingInstructionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSProcessingInstructionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSProcessingInstructionPrototype, JSProcessingInstructionPrototype::Base);

using JSProcessingInstructionConstructor = JSDOMConstructorNotConstructable<JSProcessingInstruction>;

template<> JSValue JSProcessingInstructionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCharacterData::getConstructor(vm, &globalObject);
}

template<> void JSProcessingInstructionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSProcessingInstruction::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ProcessingInstruction"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSProcessingInstructionConstructor::s_info = { "ProcessingInstruction", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSProcessingInstructionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSProcessingInstructionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSProcessingInstructionConstructor) } },
    { "target", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sheet", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionSheet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSProcessingInstructionPrototype::s_info = { "ProcessingInstructionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSProcessingInstructionPrototype) };

void JSProcessingInstructionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSProcessingInstruction::info(), JSProcessingInstructionPrototypeTableValues, *this);
}

const ClassInfo JSProcessingInstruction::s_info = { "ProcessingInstruction", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSProcessingInstruction) };

JSProcessingInstruction::JSProcessingInstruction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ProcessingInstruction>&& impl)
    : JSCharacterData(structure, globalObject, WTFMove(impl))
{
}

void JSProcessingInstruction::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ProcessingInstruction>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSProcessingInstruction::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSProcessingInstructionPrototype::create(vm, &globalObject, JSProcessingInstructionPrototype::createStructure(vm, &globalObject, JSCharacterData::prototype(vm, globalObject)));
}

JSObject* JSProcessingInstruction::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSProcessingInstruction>(vm, globalObject);
}

JSValue JSProcessingInstruction::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSProcessingInstructionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSProcessingInstruction* IDLAttribute<JSProcessingInstruction>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSProcessingInstruction*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsProcessingInstructionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSProcessingInstructionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSProcessingInstruction::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSProcessingInstructionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSProcessingInstructionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsProcessingInstructionTargetGetter(JSGlobalObject& lexicalGlobalObject, JSProcessingInstruction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.target());
    return result;
}

EncodedJSValue jsProcessingInstructionTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSProcessingInstruction>::get<jsProcessingInstructionTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "target");
}

static inline JSValue jsProcessingInstructionSheetGetter(JSGlobalObject& lexicalGlobalObject, JSProcessingInstruction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<StyleSheet>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sheet());
    return result;
}

EncodedJSValue jsProcessingInstructionSheet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSProcessingInstruction>::get<jsProcessingInstructionSheetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sheet");
}

void JSProcessingInstruction::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSProcessingInstruction*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ProcessingInstruction@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21ProcessingInstructionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ProcessingInstruction>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ProcessingInstruction@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21ProcessingInstructionE[2];
#endif

    // If this fails ProcessingInstruction does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ProcessingInstruction>::value, "ProcessingInstruction is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ProcessingInstruction has subclasses. If ProcessingInstruction has subclasses that get passed
    // to toJS() we currently require ProcessingInstruction you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ProcessingInstruction>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ProcessingInstruction& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
