/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSPublicKeyCredentialRequestOptions.h"

#include "JSAuthenticationExtensionsClientInputs.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSPublicKeyCredentialDescriptor.h"
#include "JSUserVerificationRequirement.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialRequestOptions convertDictionary<PublicKeyCredentialRequestOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialRequestOptions result;
    JSValue allowCredentialsValue;
    if (isNullOrUndefined)
        allowCredentialsValue = jsUndefined();
    else {
        allowCredentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "allowCredentials"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!allowCredentialsValue.isUndefined()) {
        result.allowCredentials = convert<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>(lexicalGlobalObject, allowCredentialsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.allowCredentials = Converter<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>::ReturnType{ };
    JSValue challengeValue;
    if (isNullOrUndefined)
        challengeValue = jsUndefined();
    else {
        challengeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "challenge"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!challengeValue.isUndefined()) {
        result.challenge = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, challengeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "challenge", "PublicKeyCredentialRequestOptions", "(ArrayBufferView or ArrayBuffer)");
        return { };
    }
    JSValue extensionsValue;
    if (isNullOrUndefined)
        extensionsValue = jsUndefined();
    else {
        extensionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "extensions"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!extensionsValue.isUndefined()) {
        result.extensions = convert<IDLDictionary<AuthenticationExtensionsClientInputs>>(lexicalGlobalObject, extensionsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue rpIdValue;
    if (isNullOrUndefined)
        rpIdValue = jsUndefined();
    else {
        rpIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rpId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rpIdValue.isUndefined()) {
        result.rpId = convert<IDLUSVString>(lexicalGlobalObject, rpIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timeoutValue;
    if (isNullOrUndefined)
        timeoutValue = jsUndefined();
    else {
        timeoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timeout"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timeoutValue.isUndefined()) {
        result.timeout = convert<IDLUnsignedLong>(lexicalGlobalObject, timeoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue userVerificationValue;
    if (isNullOrUndefined)
        userVerificationValue = jsUndefined();
    else {
        userVerificationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "userVerification"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!userVerificationValue.isUndefined()) {
        result.userVerification = convert<IDLEnumeration<UserVerificationRequirement>>(lexicalGlobalObject, userVerificationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.userVerification = UserVerificationRequirement::Preferred;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUTHN)
