/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCCertificate.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCCertificate::DtlsFingerprint convertDictionary<RTCCertificate::DtlsFingerprint>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCCertificate::DtlsFingerprint result;
    JSValue algorithmValue;
    if (isNullOrUndefined)
        algorithmValue = jsUndefined();
    else {
        algorithmValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "algorithm"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!algorithmValue.isUndefined()) {
        result.algorithm = convert<IDLDOMString>(lexicalGlobalObject, algorithmValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue valueValue;
    if (isNullOrUndefined)
        valueValue = jsUndefined();
    else {
        valueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "value"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!valueValue.isUndefined()) {
        result.value = convert<IDLDOMString>(lexicalGlobalObject, valueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCCertificate::DtlsFingerprint& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.algorithm)) {
        auto algorithmValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.algorithm));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "algorithm"), algorithmValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.value)) {
        auto valueValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.value));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "value"), valueValue);
    }
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCCertificatePrototypeFunctionGetFingerprints(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCCertificateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCCertificateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCCertificateExpires(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCCertificatePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCCertificatePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCCertificatePrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCCertificatePrototype>(vm.heap)) JSRTCCertificatePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCCertificatePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCCertificatePrototype, JSRTCCertificatePrototype::Base);

using JSRTCCertificateConstructor = JSDOMConstructorNotConstructable<JSRTCCertificate>;

template<> JSValue JSRTCCertificateConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCCertificateConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCCertificate::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCCertificate"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCCertificateConstructor::s_info = { "RTCCertificate", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCCertificateConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCCertificatePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCCertificateConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCCertificateConstructor) } },
    { "expires", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCCertificateExpires), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getFingerprints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCCertificatePrototypeFunctionGetFingerprints), (intptr_t) (0) } },
};

const ClassInfo JSRTCCertificatePrototype::s_info = { "RTCCertificatePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCCertificatePrototype) };

void JSRTCCertificatePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCCertificate::info(), JSRTCCertificatePrototypeTableValues, *this);
}

const ClassInfo JSRTCCertificate::s_info = { "RTCCertificate", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCCertificate) };

JSRTCCertificate::JSRTCCertificate(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCCertificate>&& impl)
    : JSDOMWrapper<RTCCertificate>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCCertificate::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCCertificate>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCCertificate::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCCertificatePrototype::create(vm, &globalObject, JSRTCCertificatePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCCertificate::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCCertificate>(vm, globalObject);
}

JSValue JSRTCCertificate::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCCertificateConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCCertificate::destroy(JSC::JSCell* cell)
{
    JSRTCCertificate* thisObject = static_cast<JSRTCCertificate*>(cell);
    thisObject->JSRTCCertificate::~JSRTCCertificate();
}

template<> inline JSRTCCertificate* IDLAttribute<JSRTCCertificate>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCCertificate*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCCertificate* IDLOperation<JSRTCCertificate>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCCertificate*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCCertificateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCCertificatePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCCertificate::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCCertificateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCCertificatePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCCertificateExpiresGetter(JSGlobalObject& lexicalGlobalObject, JSRTCCertificate& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.expires());
    return result;
}

EncodedJSValue jsRTCCertificateExpires(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCCertificate>::get<jsRTCCertificateExpiresGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "expires");
}

static inline JSC::EncodedJSValue jsRTCCertificatePrototypeFunctionGetFingerprintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCCertificate>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDictionary<RTCCertificate::DtlsFingerprint>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getFingerprints()));
}

EncodedJSValue JSC_HOST_CALL jsRTCCertificatePrototypeFunctionGetFingerprints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCCertificate>::call<jsRTCCertificatePrototypeFunctionGetFingerprintsBody>(*lexicalGlobalObject, *callFrame, "getFingerprints");
}

void JSRTCCertificate::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCCertificate*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCCertificateOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCCertificateOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCCertificate = static_cast<JSRTCCertificate*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCCertificate->wrapped(), jsRTCCertificate);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCCertificate>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RTCCertificate.
    static_assert(!std::is_polymorphic<RTCCertificate>::value, "RTCCertificate is polymorphic but the IDL claims it is not");
    return createWrapper<RTCCertificate>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCCertificate& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCCertificate* JSRTCCertificate::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCCertificate*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
