/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCDTMFSender.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCDTMFSenderPrototypeFunctionInsertDTMF(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCDTMFSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDTMFSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDTMFSenderOntonechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDTMFSenderOntonechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDTMFSenderCanInsertDTMF(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDTMFSenderToneBuffer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCDTMFSenderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCDTMFSenderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCDTMFSenderPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCDTMFSenderPrototype>(vm.heap)) JSRTCDTMFSenderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCDTMFSenderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCDTMFSenderPrototype, JSRTCDTMFSenderPrototype::Base);

using JSRTCDTMFSenderConstructor = JSDOMConstructorNotConstructable<JSRTCDTMFSender>;

template<> JSValue JSRTCDTMFSenderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSRTCDTMFSenderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCDTMFSender::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCDTMFSender"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCDTMFSenderConstructor::s_info = { "RTCDTMFSender", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCDTMFSenderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCDTMFSenderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDTMFSenderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDTMFSenderConstructor) } },
    { "ontonechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDTMFSenderOntonechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDTMFSenderOntonechange) } },
    { "canInsertDTMF", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDTMFSenderCanInsertDTMF), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toneBuffer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDTMFSenderToneBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertDTMF", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCDTMFSenderPrototypeFunctionInsertDTMF), (intptr_t) (1) } },
};

const ClassInfo JSRTCDTMFSenderPrototype::s_info = { "RTCDTMFSenderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCDTMFSenderPrototype) };

void JSRTCDTMFSenderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCDTMFSender::info(), JSRTCDTMFSenderPrototypeTableValues, *this);
}

const ClassInfo JSRTCDTMFSender::s_info = { "RTCDTMFSender", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCDTMFSender) };

JSRTCDTMFSender::JSRTCDTMFSender(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCDTMFSender>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSRTCDTMFSender::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, RTCDTMFSender>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSRTCDTMFSender::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCDTMFSenderPrototype::create(vm, &globalObject, JSRTCDTMFSenderPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSRTCDTMFSender::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCDTMFSender>(vm, globalObject);
}

JSValue JSRTCDTMFSender::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCDTMFSenderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSRTCDTMFSender* IDLAttribute<JSRTCDTMFSender>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCDTMFSender*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCDTMFSender* IDLOperation<JSRTCDTMFSender>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCDTMFSender*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCDTMFSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCDTMFSenderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCDTMFSender::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCDTMFSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCDTMFSenderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCDTMFSenderOntonechangeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDTMFSender& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().tonechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCDTMFSenderOntonechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDTMFSender>::get<jsRTCDTMFSenderOntonechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontonechange");
}

static inline bool setJSRTCDTMFSenderOntonechangeSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDTMFSender& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().tonechangeEvent, value);
    return true;
}

bool setJSRTCDTMFSenderOntonechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDTMFSender>::set<setJSRTCDTMFSenderOntonechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontonechange");
}

static inline JSValue jsRTCDTMFSenderCanInsertDTMFGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDTMFSender& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.canInsertDTMF());
    return result;
}

EncodedJSValue jsRTCDTMFSenderCanInsertDTMF(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDTMFSender>::get<jsRTCDTMFSenderCanInsertDTMFGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canInsertDTMF");
}

static inline JSValue jsRTCDTMFSenderToneBufferGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDTMFSender& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.toneBuffer());
    return result;
}

EncodedJSValue jsRTCDTMFSenderToneBuffer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDTMFSender>::get<jsRTCDTMFSenderToneBufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "toneBuffer");
}

static inline JSC::EncodedJSValue jsRTCDTMFSenderPrototypeFunctionInsertDTMFBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDTMFSender>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto tones = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto duration = callFrame->argument(1).isUndefined() ? 100 : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto interToneGap = callFrame->argument(2).isUndefined() ? 70 : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.insertDTMF(WTFMove(tones), WTFMove(duration), WTFMove(interToneGap)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCDTMFSenderPrototypeFunctionInsertDTMF(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCDTMFSender>::call<jsRTCDTMFSenderPrototypeFunctionInsertDTMFBody>(*lexicalGlobalObject, *callFrame, "insertDTMF");
}

void JSRTCDTMFSender::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCDTMFSender*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCDTMFSenderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsRTCDTMFSender = jsCast<JSRTCDTMFSender*>(handle.slot()->asCell());
    if (jsRTCDTMFSender->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsRTCDTMFSender->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCDTMFSenderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCDTMFSender = static_cast<JSRTCDTMFSender*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCDTMFSender->wrapped(), jsRTCDTMFSender);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7RTCDTMFSender@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13RTCDTMFSenderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCDTMFSender>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7RTCDTMFSender@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13RTCDTMFSenderE[2];
#endif

    // If this fails RTCDTMFSender does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<RTCDTMFSender>::value, "RTCDTMFSender is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // RTCDTMFSender has subclasses. If RTCDTMFSender has subclasses that get passed
    // to toJS() we currently require RTCDTMFSender you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<RTCDTMFSender>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCDTMFSender& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCDTMFSender* JSRTCDTMFSender::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCDTMFSender*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
