/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCIceConnectionState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCIceConnectionState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("new"),
        MAKE_STATIC_STRING_IMPL("checking"),
        MAKE_STATIC_STRING_IMPL("connected"),
        MAKE_STATIC_STRING_IMPL("completed"),
        MAKE_STATIC_STRING_IMPL("failed"),
        MAKE_STATIC_STRING_IMPL("disconnected"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(RTCIceConnectionState::New) == 0, "RTCIceConnectionState::New is not 0 as expected");
    static_assert(static_cast<size_t>(RTCIceConnectionState::Checking) == 1, "RTCIceConnectionState::Checking is not 1 as expected");
    static_assert(static_cast<size_t>(RTCIceConnectionState::Connected) == 2, "RTCIceConnectionState::Connected is not 2 as expected");
    static_assert(static_cast<size_t>(RTCIceConnectionState::Completed) == 3, "RTCIceConnectionState::Completed is not 3 as expected");
    static_assert(static_cast<size_t>(RTCIceConnectionState::Failed) == 4, "RTCIceConnectionState::Failed is not 4 as expected");
    static_assert(static_cast<size_t>(RTCIceConnectionState::Disconnected) == 5, "RTCIceConnectionState::Disconnected is not 5 as expected");
    static_assert(static_cast<size_t>(RTCIceConnectionState::Closed) == 6, "RTCIceConnectionState::Closed is not 6 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCIceConnectionState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCIceConnectionState> parseEnumeration<RTCIceConnectionState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "new")
        return RTCIceConnectionState::New;
    if (stringValue == "checking")
        return RTCIceConnectionState::Checking;
    if (stringValue == "connected")
        return RTCIceConnectionState::Connected;
    if (stringValue == "completed")
        return RTCIceConnectionState::Completed;
    if (stringValue == "failed")
        return RTCIceConnectionState::Failed;
    if (stringValue == "disconnected")
        return RTCIceConnectionState::Disconnected;
    if (stringValue == "closed")
        return RTCIceConnectionState::Closed;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCIceConnectionState>()
{
    return "\"new\", \"checking\", \"connected\", \"completed\", \"failed\", \"disconnected\", \"closed\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
