/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCIceServer.h"

#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCIceServer convertDictionary<RTCIceServer>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCIceServer result;
    JSValue credentialValue;
    if (isNullOrUndefined)
        credentialValue = jsUndefined();
    else {
        credentialValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "credential"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!credentialValue.isUndefined()) {
        result.credential = convert<IDLDOMString>(lexicalGlobalObject, credentialValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue urlsValue;
    if (isNullOrUndefined)
        urlsValue = jsUndefined();
    else {
        urlsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "urls"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlsValue.isUndefined()) {
        result.urls = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, urlsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "urls", "RTCIceServer", "(DOMString or sequence)");
        return { };
    }
    JSValue usernameValue;
    if (isNullOrUndefined)
        usernameValue = jsUndefined();
    else {
        usernameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "username"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usernameValue.isUndefined()) {
        result.username = convert<IDLDOMString>(lexicalGlobalObject, usernameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCIceServer& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.credential)) {
        auto credentialValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.credential));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "credential"), credentialValue);
    }
    auto urlsValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, dictionary.urls);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "urls"), urlsValue);
    if (!IDLDOMString::isNullValue(dictionary.username)) {
        auto usernameValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.username));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "username"), usernameValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
