/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCIceTransport.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSRTCIceGatheringState.h"
#include "JSRTCIceTransportState.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsRTCIceTransportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCIceTransportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCIceTransportState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCIceTransportGatheringState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCIceTransportPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCIceTransportPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCIceTransportPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCIceTransportPrototype>(vm.heap)) JSRTCIceTransportPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCIceTransportPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCIceTransportPrototype, JSRTCIceTransportPrototype::Base);

using JSRTCIceTransportConstructor = JSDOMConstructorNotConstructable<JSRTCIceTransport>;

template<> JSValue JSRTCIceTransportConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCIceTransportConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCIceTransport::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCIceTransport"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCIceTransportConstructor::s_info = { "RTCIceTransport", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCIceTransportConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCIceTransportPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceTransportConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCIceTransportConstructor) } },
    { "state", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceTransportState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gatheringState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceTransportGatheringState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSRTCIceTransportPrototype::s_info = { "RTCIceTransportPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCIceTransportPrototype) };

void JSRTCIceTransportPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCIceTransport::info(), JSRTCIceTransportPrototypeTableValues, *this);
}

const ClassInfo JSRTCIceTransport::s_info = { "RTCIceTransport", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCIceTransport) };

JSRTCIceTransport::JSRTCIceTransport(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCIceTransport>&& impl)
    : JSDOMWrapper<RTCIceTransport>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCIceTransport::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCIceTransport>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCIceTransport::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCIceTransportPrototype::create(vm, &globalObject, JSRTCIceTransportPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCIceTransport::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCIceTransport>(vm, globalObject);
}

JSValue JSRTCIceTransport::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCIceTransportConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCIceTransport::destroy(JSC::JSCell* cell)
{
    JSRTCIceTransport* thisObject = static_cast<JSRTCIceTransport*>(cell);
    thisObject->JSRTCIceTransport::~JSRTCIceTransport();
}

template<> inline JSRTCIceTransport* IDLAttribute<JSRTCIceTransport>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCIceTransport*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsRTCIceTransportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCIceTransportPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCIceTransport::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCIceTransportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCIceTransportPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCIceTransportStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCIceTransport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCIceTransportState>>(lexicalGlobalObject, throwScope, impl.state());
    return result;
}

EncodedJSValue jsRTCIceTransportState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCIceTransport>::get<jsRTCIceTransportStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "state");
}

static inline JSValue jsRTCIceTransportGatheringStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCIceTransport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCIceGatheringState>>(lexicalGlobalObject, throwScope, impl.gatheringState());
    return result;
}

EncodedJSValue jsRTCIceTransportGatheringState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCIceTransport>::get<jsRTCIceTransportGatheringStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "gatheringState");
}

void JSRTCIceTransport::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCIceTransport*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCIceTransportOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCIceTransportOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCIceTransport = static_cast<JSRTCIceTransport*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCIceTransport->wrapped(), jsRTCIceTransport);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7RTCIceTransport@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15RTCIceTransportE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCIceTransport>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7RTCIceTransport@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15RTCIceTransportE[2];
#endif

    // If this fails RTCIceTransport does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<RTCIceTransport>::value, "RTCIceTransport is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // RTCIceTransport has subclasses. If RTCIceTransport has subclasses that get passed
    // to toJS() we currently require RTCIceTransport you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<RTCIceTransport>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCIceTransport& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCIceTransport* JSRTCIceTransport::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCIceTransport*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
