/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCPeerConnection.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMBuiltinConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSMediaStream.h"
#include "JSMediaStreamTrack.h"
#include "JSRTCAnswerOptions.h"
#include "JSRTCConfiguration.h"
#include "JSRTCDataChannel.h"
#include "JSRTCIceCandidate.h"
#include "JSRTCIceConnectionState.h"
#include "JSRTCIceGatheringState.h"
#include "JSRTCOfferOptions.h"
#include "JSRTCPeerConnectionState.h"
#include "JSRTCRtpReceiver.h"
#include "JSRTCRtpSender.h"
#include "JSRTCRtpTransceiver.h"
#include "JSRTCRtpTransceiverDirection.h"
#include "JSRTCSessionDescription.h"
#include "JSRTCSignalingState.h"
#include "RTCPeerConnectionBuiltins.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCPeerConnection::DataChannelInit convertDictionary<RTCPeerConnection::DataChannelInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCPeerConnection::DataChannelInit result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLEnforceRangeAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue maxPacketLifeTimeValue;
    if (isNullOrUndefined)
        maxPacketLifeTimeValue = jsUndefined();
    else {
        maxPacketLifeTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxPacketLifeTime"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxPacketLifeTimeValue.isUndefined()) {
        result.maxPacketLifeTime = convert<IDLUnsignedShort>(lexicalGlobalObject, maxPacketLifeTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue maxRetransmitsValue;
    if (isNullOrUndefined)
        maxRetransmitsValue = jsUndefined();
    else {
        maxRetransmitsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxRetransmits"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxRetransmitsValue.isUndefined()) {
        result.maxRetransmits = convert<IDLUnsignedShort>(lexicalGlobalObject, maxRetransmitsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue negotiatedValue;
    if (isNullOrUndefined)
        negotiatedValue = jsUndefined();
    else {
        negotiatedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "negotiated"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!negotiatedValue.isUndefined()) {
        result.negotiated = convert<IDLBoolean>(lexicalGlobalObject, negotiatedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.negotiated = false;
    JSValue orderedValue;
    if (isNullOrUndefined)
        orderedValue = jsUndefined();
    else {
        orderedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ordered"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!orderedValue.isUndefined()) {
        result.ordered = convert<IDLBoolean>(lexicalGlobalObject, orderedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ordered = true;
    JSValue protocolValue;
    if (isNullOrUndefined)
        protocolValue = jsUndefined();
    else {
        protocolValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "protocol"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!protocolValue.isUndefined()) {
        result.protocol = convert<IDLUSVString>(lexicalGlobalObject, protocolValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.protocol = emptyString();
    return result;
}

#endif

#if ENABLE(WEB_RTC)

template<> RTCPeerConnection::CertificateParameters convertDictionary<RTCPeerConnection::CertificateParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCPeerConnection::CertificateParameters result;
    JSValue expiresValue;
    if (isNullOrUndefined)
        expiresValue = jsUndefined();
    else {
        expiresValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expires"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!expiresValue.isUndefined()) {
        result.expires = convert<IDLDouble>(lexicalGlobalObject, expiresValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hashValue;
    if (isNullOrUndefined)
        hashValue = jsUndefined();
    else {
        hashValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hash"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hashValue.isUndefined()) {
        result.hash = convert<IDLDOMString>(lexicalGlobalObject, hashValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue modulusLengthValue;
    if (isNullOrUndefined)
        modulusLengthValue = jsUndefined();
    else {
        modulusLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modulusLength"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modulusLengthValue.isUndefined()) {
        result.modulusLength = convert<IDLUnsignedLong>(lexicalGlobalObject, modulusLengthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue namedCurveValue;
    if (isNullOrUndefined)
        namedCurveValue = jsUndefined();
    else {
        namedCurveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "namedCurve"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!namedCurveValue.isUndefined()) {
        result.namedCurve = convert<IDLDOMString>(lexicalGlobalObject, namedCurveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue publicExponentValue;
    if (isNullOrUndefined)
        publicExponentValue = jsUndefined();
    else {
        publicExponentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "publicExponent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!publicExponentValue.isUndefined()) {
        result.publicExponent = convert<IDLUint8Array>(lexicalGlobalObject, publicExponentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

#if ENABLE(WEB_RTC)

template<> RTCRtpTransceiverInit convertDictionary<RTCRtpTransceiverInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCRtpTransceiverInit result;
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!directionValue.isUndefined()) {
        result.direction = convert<IDLEnumeration<RTCRtpTransceiverDirection>>(lexicalGlobalObject, directionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.direction = RTCRtpTransceiverDirection::Sendrecv;
    JSValue streamsValue;
    if (isNullOrUndefined)
        streamsValue = jsUndefined();
    else {
        streamsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "streams"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!streamsValue.isUndefined()) {
        result.streams = convert<IDLSequence<IDLInterface<MediaStream>>>(lexicalGlobalObject, streamsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.streams = Converter<IDLSequence<IDLInterface<MediaStream>>>::ReturnType{ };
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionInitializeWith(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetConfiguration(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionSetConfiguration(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedCreateOffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedCreateAnswer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedSetLocalDescription(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedSetRemoteDescription(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedAddIceCandidate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionConstructorFunctionGenerateCertificate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetSenders(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetReceivers(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetTransceivers(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionAddTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionRemoveTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionAddTransceiver(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionCreateDataChannel(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetStats(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCPeerConnectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionLocalDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionCurrentLocalDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionPendingLocalDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionRemoteDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionCurrentRemoteDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionPendingRemoteDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionSignalingState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionIceGatheringState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionIceConnectionState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionConnectionState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCPeerConnectionOnnegotiationneeded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOnnegotiationneeded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOnicecandidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOnicecandidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOnsignalingstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOnsignalingstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOniceconnectionstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOniceconnectionstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOnicegatheringstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOnicegatheringstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOnconnectionstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOnconnectionstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOntrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOntrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCPeerConnectionOndatachannel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCPeerConnectionOndatachannel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSRTCPeerConnectionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCPeerConnectionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCPeerConnectionPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCPeerConnectionPrototype>(vm.heap)) JSRTCPeerConnectionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCPeerConnectionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCPeerConnectionPrototype, JSRTCPeerConnectionPrototype::Base);

using JSRTCPeerConnectionConstructor = JSDOMBuiltinConstructor<JSRTCPeerConnection>;

/* Hash table for constructor */

static const HashTableValue JSRTCPeerConnectionConstructorTableValues[] =
{
    { "generateCertificate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionConstructorFunctionGenerateCertificate), (intptr_t) (1) } },
};

template<> JSValue JSRTCPeerConnectionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSRTCPeerConnectionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCPeerConnection::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCPeerConnection"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSRTCPeerConnection::info(), JSRTCPeerConnectionConstructorTableValues, *this);
}

template<> FunctionExecutable* JSRTCPeerConnectionConstructor::initializeExecutable(VM& vm)
{
    return rtcPeerConnectionInitializeRTCPeerConnectionCodeGenerator(vm);
}

template<> const ClassInfo JSRTCPeerConnectionConstructor::s_info = { "RTCPeerConnection", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCPeerConnectionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCPeerConnectionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionConstructor) } },
    { "localDescription", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionLocalDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentLocalDescription", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionCurrentLocalDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pendingLocalDescription", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionPendingLocalDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "remoteDescription", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionRemoteDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentRemoteDescription", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionCurrentRemoteDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pendingRemoteDescription", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionPendingRemoteDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "signalingState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionSignalingState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "iceGatheringState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionIceGatheringState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "iceConnectionState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionIceConnectionState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "connectionState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionConnectionState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onnegotiationneeded", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOnnegotiationneeded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOnnegotiationneeded) } },
    { "onicecandidate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOnicecandidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOnicecandidate) } },
    { "onsignalingstatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOnsignalingstatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOnsignalingstatechange) } },
    { "oniceconnectionstatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOniceconnectionstatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOniceconnectionstatechange) } },
    { "onicegatheringstatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOnicegatheringstatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOnicegatheringstatechange) } },
    { "onconnectionstatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOnconnectionstatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOnconnectionstatechange) } },
    { "ontrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOntrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOntrack) } },
    { "ondatachannel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCPeerConnectionOndatachannel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCPeerConnectionOndatachannel) } },
    { "createOffer", static_cast<unsigned>(JSC::PropertyAttribute::Builtin), NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(rtcPeerConnectionCreateOfferCodeGenerator), (intptr_t) (0) } },
    { "createAnswer", static_cast<unsigned>(JSC::PropertyAttribute::Builtin), NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(rtcPeerConnectionCreateAnswerCodeGenerator), (intptr_t) (0) } },
    { "setLocalDescription", static_cast<unsigned>(JSC::PropertyAttribute::Builtin), NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(rtcPeerConnectionSetLocalDescriptionCodeGenerator), (intptr_t) (1) } },
    { "setRemoteDescription", static_cast<unsigned>(JSC::PropertyAttribute::Builtin), NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(rtcPeerConnectionSetRemoteDescriptionCodeGenerator), (intptr_t) (1) } },
    { "addIceCandidate", static_cast<unsigned>(JSC::PropertyAttribute::Builtin), NoIntrinsic, { (intptr_t)static_cast<BuiltinGenerator>(rtcPeerConnectionAddIceCandidateCodeGenerator), (intptr_t) (1) } },
    { "getConfiguration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionGetConfiguration), (intptr_t) (0) } },
    { "setConfiguration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionSetConfiguration), (intptr_t) (1) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionClose), (intptr_t) (0) } },
    { "getSenders", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionGetSenders), (intptr_t) (0) } },
    { "getReceivers", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionGetReceivers), (intptr_t) (0) } },
    { "getTransceivers", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionGetTransceivers), (intptr_t) (0) } },
    { "addTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionAddTrack), (intptr_t) (1) } },
    { "removeTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionRemoveTrack), (intptr_t) (1) } },
    { "addTransceiver", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionAddTransceiver), (intptr_t) (1) } },
    { "createDataChannel", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionCreateDataChannel), (intptr_t) (1) } },
    { "getStats", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCPeerConnectionPrototypeFunctionGetStats), (intptr_t) (0) } },
};

const ClassInfo JSRTCPeerConnectionPrototype::s_info = { "RTCPeerConnectionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCPeerConnectionPrototype) };

void JSRTCPeerConnectionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCPeerConnection::info(), JSRTCPeerConnectionPrototypeTableValues, *this);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().initializeWithPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsRTCPeerConnectionPrototypeFunctionInitializeWith), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().queuedCreateOfferPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsRTCPeerConnectionPrototypeFunctionQueuedCreateOffer), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().queuedCreateAnswerPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsRTCPeerConnectionPrototypeFunctionQueuedCreateAnswer), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().queuedSetLocalDescriptionPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsRTCPeerConnectionPrototypeFunctionQueuedSetLocalDescription), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().queuedSetRemoteDescriptionPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsRTCPeerConnectionPrototypeFunctionQueuedSetRemoteDescription), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().queuedAddIceCandidatePrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsRTCPeerConnectionPrototypeFunctionQueuedAddIceCandidate), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

const ClassInfo JSRTCPeerConnection::s_info = { "RTCPeerConnection", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCPeerConnection) };

JSRTCPeerConnection::JSRTCPeerConnection(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCPeerConnection>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSRTCPeerConnection::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, RTCPeerConnection>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSRTCPeerConnection::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCPeerConnectionPrototype::create(vm, &globalObject, JSRTCPeerConnectionPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSRTCPeerConnection::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCPeerConnection>(vm, globalObject);
}

JSValue JSRTCPeerConnection::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCPeerConnectionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSRTCPeerConnection* IDLAttribute<JSRTCPeerConnection>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCPeerConnection*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCPeerConnection* IDLOperation<JSRTCPeerConnection>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCPeerConnection*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCPeerConnectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCPeerConnectionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCPeerConnection::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCPeerConnectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCPeerConnectionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCPeerConnectionLocalDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCSessionDescription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.localDescription());
    return result;
}

EncodedJSValue jsRTCPeerConnectionLocalDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionLocalDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "localDescription");
}

static inline JSValue jsRTCPeerConnectionCurrentLocalDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCSessionDescription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentLocalDescription());
    return result;
}

EncodedJSValue jsRTCPeerConnectionCurrentLocalDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionCurrentLocalDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentLocalDescription");
}

static inline JSValue jsRTCPeerConnectionPendingLocalDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCSessionDescription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pendingLocalDescription());
    return result;
}

EncodedJSValue jsRTCPeerConnectionPendingLocalDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionPendingLocalDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pendingLocalDescription");
}

static inline JSValue jsRTCPeerConnectionRemoteDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCSessionDescription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.remoteDescription());
    return result;
}

EncodedJSValue jsRTCPeerConnectionRemoteDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionRemoteDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "remoteDescription");
}

static inline JSValue jsRTCPeerConnectionCurrentRemoteDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCSessionDescription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentRemoteDescription());
    return result;
}

EncodedJSValue jsRTCPeerConnectionCurrentRemoteDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionCurrentRemoteDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentRemoteDescription");
}

static inline JSValue jsRTCPeerConnectionPendingRemoteDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCSessionDescription>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pendingRemoteDescription());
    return result;
}

EncodedJSValue jsRTCPeerConnectionPendingRemoteDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionPendingRemoteDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pendingRemoteDescription");
}

static inline JSValue jsRTCPeerConnectionSignalingStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCSignalingState>>(lexicalGlobalObject, throwScope, impl.signalingState());
    return result;
}

EncodedJSValue jsRTCPeerConnectionSignalingState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionSignalingStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "signalingState");
}

static inline JSValue jsRTCPeerConnectionIceGatheringStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCIceGatheringState>>(lexicalGlobalObject, throwScope, impl.iceGatheringState());
    return result;
}

EncodedJSValue jsRTCPeerConnectionIceGatheringState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionIceGatheringStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "iceGatheringState");
}

static inline JSValue jsRTCPeerConnectionIceConnectionStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCIceConnectionState>>(lexicalGlobalObject, throwScope, impl.iceConnectionState());
    return result;
}

EncodedJSValue jsRTCPeerConnectionIceConnectionState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionIceConnectionStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "iceConnectionState");
}

static inline JSValue jsRTCPeerConnectionConnectionStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCPeerConnectionState>>(lexicalGlobalObject, throwScope, impl.connectionState());
    return result;
}

EncodedJSValue jsRTCPeerConnectionConnectionState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionConnectionStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "connectionState");
}

static inline JSValue jsRTCPeerConnectionOnnegotiationneededGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().negotiationneededEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOnnegotiationneeded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOnnegotiationneededGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onnegotiationneeded");
}

static inline bool setJSRTCPeerConnectionOnnegotiationneededSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().negotiationneededEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOnnegotiationneeded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOnnegotiationneededSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onnegotiationneeded");
}

static inline JSValue jsRTCPeerConnectionOnicecandidateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().icecandidateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOnicecandidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOnicecandidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onicecandidate");
}

static inline bool setJSRTCPeerConnectionOnicecandidateSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().icecandidateEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOnicecandidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOnicecandidateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onicecandidate");
}

static inline JSValue jsRTCPeerConnectionOnsignalingstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().signalingstatechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOnsignalingstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOnsignalingstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsignalingstatechange");
}

static inline bool setJSRTCPeerConnectionOnsignalingstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().signalingstatechangeEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOnsignalingstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOnsignalingstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsignalingstatechange");
}

static inline JSValue jsRTCPeerConnectionOniceconnectionstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().iceconnectionstatechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOniceconnectionstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOniceconnectionstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oniceconnectionstatechange");
}

static inline bool setJSRTCPeerConnectionOniceconnectionstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().iceconnectionstatechangeEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOniceconnectionstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOniceconnectionstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oniceconnectionstatechange");
}

static inline JSValue jsRTCPeerConnectionOnicegatheringstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().icegatheringstatechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOnicegatheringstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOnicegatheringstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onicegatheringstatechange");
}

static inline bool setJSRTCPeerConnectionOnicegatheringstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().icegatheringstatechangeEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOnicegatheringstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOnicegatheringstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onicegatheringstatechange");
}

static inline JSValue jsRTCPeerConnectionOnconnectionstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().connectionstatechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOnconnectionstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOnconnectionstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onconnectionstatechange");
}

static inline bool setJSRTCPeerConnectionOnconnectionstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().connectionstatechangeEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOnconnectionstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOnconnectionstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onconnectionstatechange");
}

static inline JSValue jsRTCPeerConnectionOntrackGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().trackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOntrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOntrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontrack");
}

static inline bool setJSRTCPeerConnectionOntrackSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().trackEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOntrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOntrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontrack");
}

static inline JSValue jsRTCPeerConnectionOndatachannelGetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().datachannelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCPeerConnectionOndatachannel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCPeerConnection>::get<jsRTCPeerConnectionOndatachannelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondatachannel");
}

static inline bool setJSRTCPeerConnectionOndatachannelSetter(JSGlobalObject& lexicalGlobalObject, JSRTCPeerConnection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().datachannelEvent, value);
    return true;
}

bool setJSRTCPeerConnectionOndatachannel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCPeerConnection>::set<setJSRTCPeerConnectionOndatachannelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondatachannel");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionInitializeWithBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto configuration = convert<IDLDictionary<RTCConfiguration>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.initializeWith(document, WTFMove(configuration)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionInitializeWith(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionInitializeWithBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "initializeWith");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionGetConfigurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<RTCConfiguration>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getConfiguration()));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetConfiguration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionGetConfigurationBody>(*lexicalGlobalObject, *callFrame, "getConfiguration");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionSetConfigurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto configuration = convert<IDLDictionary<RTCConfiguration>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setConfiguration(WTFMove(configuration)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionSetConfiguration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionSetConfigurationBody>(*lexicalGlobalObject, *callFrame, "setConfiguration");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionQueuedCreateOfferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCPeerConnection>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto offerOptions = convert<IDLDictionary<RTCOfferOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queuedCreateOffer(WTFMove(offerOptions), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedCreateOffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionQueuedCreateOfferBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "queuedCreateOffer");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionQueuedCreateAnswerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCPeerConnection>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto answerOptions = convert<IDLDictionary<RTCAnswerOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queuedCreateAnswer(WTFMove(answerOptions), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedCreateAnswer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionQueuedCreateAnswerBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "queuedCreateAnswer");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionQueuedSetLocalDescriptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCPeerConnection>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto description = convert<IDLInterface<RTCSessionDescription>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "description", "RTCPeerConnection", "queuedSetLocalDescription", "RTCSessionDescription"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queuedSetLocalDescription(*description, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedSetLocalDescription(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionQueuedSetLocalDescriptionBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "queuedSetLocalDescription");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionQueuedSetRemoteDescriptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCPeerConnection>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto description = convert<IDLInterface<RTCSessionDescription>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "description", "RTCPeerConnection", "queuedSetRemoteDescription", "RTCSessionDescription"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queuedSetRemoteDescription(*description, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedSetRemoteDescription(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionQueuedSetRemoteDescriptionBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "queuedSetRemoteDescription");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionQueuedAddIceCandidateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCPeerConnection>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto candidate = convert<IDLNullable<IDLInterface<RTCIceCandidate>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "candidate", "RTCPeerConnection", "queuedAddIceCandidate", "RTCIceCandidate"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queuedAddIceCandidate(WTFMove(candidate), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionQueuedAddIceCandidate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionQueuedAddIceCandidateBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "queuedAddIceCandidate");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionConstructorFunctionGenerateCertificateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto keygenAlgorithm = convert<IDLUnion<IDLObject, IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RTCPeerConnection::generateCertificate(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(keygenAlgorithm), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionConstructorFunctionGenerateCertificate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::callStatic<jsRTCPeerConnectionConstructorFunctionGenerateCertificateBody>(*lexicalGlobalObject, *callFrame, "generateCertificate");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionGetSendersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<RTCRtpSender>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSenders()));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetSenders(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionGetSendersBody>(*lexicalGlobalObject, *callFrame, "getSenders");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionGetReceiversBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<RTCRtpReceiver>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getReceivers()));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetReceivers(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionGetReceiversBody>(*lexicalGlobalObject, *callFrame, "getReceivers");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionGetTransceiversBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<RTCRtpTransceiver>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTransceivers()));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetTransceivers(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionGetTransceiversBody>(*lexicalGlobalObject, *callFrame, "getTransceivers");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionAddTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "RTCPeerConnection", "addTrack", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto streams = convertVariadicArguments<IDLInterface<MediaStream>>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<RTCRtpSender>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addTrack(*track, WTFMove(streams))));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionAddTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionAddTrackBody>(*lexicalGlobalObject, *callFrame, "addTrack");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionRemoveTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sender = convert<IDLInterface<RTCRtpSender>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sender", "RTCPeerConnection", "removeTrack", "RTCRtpSender"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.removeTrack(*sender));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionRemoveTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionRemoveTrackBody>(*lexicalGlobalObject, *callFrame, "removeTrack");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionAddTransceiverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLUnion<IDLInterface<MediaStreamTrack>, IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto init = convert<IDLDictionary<RTCRtpTransceiverInit>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<RTCRtpTransceiver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addTransceiver(WTFMove(track), WTFMove(init))));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionAddTransceiver(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionAddTransceiverBody>(*lexicalGlobalObject, *callFrame, "addTransceiver");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionCreateDataChannelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCPeerConnection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto label = convert<IDLTreatNullAsEmptyAdaptor<IDLUSVString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<RTCPeerConnection::DataChannelInit>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<RTCDataChannel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDataChannel(WTFMove(label), WTFMove(options))));
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionCreateDataChannel(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionCreateDataChannelBody>(*lexicalGlobalObject, *callFrame, "createDataChannel");
}

static inline JSC::EncodedJSValue jsRTCPeerConnectionPrototypeFunctionGetStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCPeerConnection>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto selector = convert<IDLNullable<IDLInterface<MediaStreamTrack>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "selector", "RTCPeerConnection", "getStats", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getStats(WTFMove(selector), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCPeerConnectionPrototypeFunctionGetStats(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCPeerConnection>::call<jsRTCPeerConnectionPrototypeFunctionGetStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

void JSRTCPeerConnection::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCPeerConnection*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCPeerConnectionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsRTCPeerConnection = jsCast<JSRTCPeerConnection*>(handle.slot()->asCell());
    if (jsRTCPeerConnection->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsRTCPeerConnection->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCPeerConnectionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCPeerConnection = static_cast<JSRTCPeerConnection*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCPeerConnection->wrapped(), jsRTCPeerConnection);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7RTCPeerConnection@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17RTCPeerConnectionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCPeerConnection>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7RTCPeerConnection@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17RTCPeerConnectionE[2];
#endif

    // If this fails RTCPeerConnection does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<RTCPeerConnection>::value, "RTCPeerConnection is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // RTCPeerConnection has subclasses. If RTCPeerConnection has subclasses that get passed
    // to toJS() we currently require RTCPeerConnection you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<RTCPeerConnection>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCPeerConnection& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCPeerConnection* JSRTCPeerConnection::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCPeerConnection*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
