/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(WEB_RTC)

#include "JSDOMConvertDictionary.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "RTCPeerConnection.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSRTCPeerConnection : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = RTCPeerConnection;
    static JSRTCPeerConnection* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<RTCPeerConnection>&& impl)
    {
        JSRTCPeerConnection* ptr = new (NotNull, JSC::allocateCell<JSRTCPeerConnection>(globalObject->vm().heap)) JSRTCPeerConnection(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static RTCPeerConnection* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    RTCPeerConnection& wrapped() const
    {
        return static_cast<RTCPeerConnection&>(Base::wrapped());
    }
protected:
    JSRTCPeerConnection(JSC::Structure*, JSDOMGlobalObject&, Ref<RTCPeerConnection>&&);

    void finishCreation(JSC::VM&);
};

class JSRTCPeerConnectionOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, RTCPeerConnection*)
{
    static NeverDestroyed<JSRTCPeerConnectionOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(RTCPeerConnection* wrappableObject)
{
    return wrappableObject;
}

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, RTCPeerConnection&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCPeerConnection* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<RTCPeerConnection>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<RTCPeerConnection>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<RTCPeerConnection> {
    using WrapperClass = JSRTCPeerConnection;
    using ToWrappedReturnType = RTCPeerConnection*;
};
#if ENABLE(WEB_RTC)

template<> RTCPeerConnection::DataChannelInit convertDictionary<RTCPeerConnection::DataChannelInit>(JSC::JSGlobalObject&, JSC::JSValue);

#endif

#if ENABLE(WEB_RTC)

template<> RTCPeerConnection::CertificateParameters convertDictionary<RTCPeerConnection::CertificateParameters>(JSC::JSGlobalObject&, JSC::JSValue);

#endif

#if ENABLE(WEB_RTC)

template<> RTCRtpTransceiverInit convertDictionary<RTCRtpTransceiverInit>(JSC::JSGlobalObject&, JSC::JSValue);

#endif


} // namespace WebCore

#endif // ENABLE(WEB_RTC)
