/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpContributingSource.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCRtpContributingSource convertDictionary<RTCRtpContributingSource>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCRtpContributingSource result;
    JSValue audioLevelValue;
    if (isNullOrUndefined)
        audioLevelValue = jsUndefined();
    else {
        audioLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audioLevel"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!audioLevelValue.isUndefined()) {
        result.audioLevel = convert<IDLDouble>(lexicalGlobalObject, audioLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sourceValue.isUndefined()) {
        result.source = convert<IDLUnsignedLong>(lexicalGlobalObject, sourceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "source", "RTCRtpContributingSource", "unsigned long");
        return { };
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "timestamp", "RTCRtpContributingSource", "double");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCRtpContributingSource& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.audioLevel)) {
        auto audioLevelValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.audioLevel));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "audioLevel"), audioLevelValue);
    }
    auto sourceValue = toJS<IDLUnsignedLong>(dictionary.source);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "source"), sourceValue);
    auto timestampValue = toJS<IDLDouble>(dictionary.timestamp);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
