/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpParameters.h"

#include "JSDOMConvertSequences.h"
#include "JSDOMGlobalObject.h"
#include "JSRTCRtpCodecParameters.h"
#include "JSRTCRtpHeaderExtensionParameters.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCRtpParameters convertDictionary<RTCRtpParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCRtpParameters result;
    JSValue codecsValue;
    if (isNullOrUndefined)
        codecsValue = jsUndefined();
    else {
        codecsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecs"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecsValue.isUndefined()) {
        result.codecs = convert<IDLSequence<IDLDictionary<RTCRtpCodecParameters>>>(lexicalGlobalObject, codecsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue headerExtensionsValue;
    if (isNullOrUndefined)
        headerExtensionsValue = jsUndefined();
    else {
        headerExtensionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headerExtensions"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headerExtensionsValue.isUndefined()) {
        result.headerExtensions = convert<IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>>(lexicalGlobalObject, headerExtensionsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCRtpParameters& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLSequence<IDLDictionary<RTCRtpCodecParameters>>::isNullValue(dictionary.codecs)) {
        auto codecsValue = toJS<IDLSequence<IDLDictionary<RTCRtpCodecParameters>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDictionary<RTCRtpCodecParameters>>::extractValueFromNullable(dictionary.codecs));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecs"), codecsValue);
    }
    if (!IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>::isNullValue(dictionary.headerExtensions)) {
        auto headerExtensionsValue = toJS<IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>::extractValueFromNullable(dictionary.headerExtensions));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "headerExtensions"), headerExtensionsValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
