/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpSendParameters.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSRTCDegradationPreference.h"
#include "JSRTCRtpCodecParameters.h"
#include "JSRTCRtpEncodingParameters.h"
#include "JSRTCRtpHeaderExtensionParameters.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCRtpSendParameters convertDictionary<RTCRtpSendParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCRtpSendParameters result;
    JSValue codecsValue;
    if (isNullOrUndefined)
        codecsValue = jsUndefined();
    else {
        codecsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecs"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecsValue.isUndefined()) {
        result.codecs = convert<IDLSequence<IDLDictionary<RTCRtpCodecParameters>>>(lexicalGlobalObject, codecsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue headerExtensionsValue;
    if (isNullOrUndefined)
        headerExtensionsValue = jsUndefined();
    else {
        headerExtensionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headerExtensions"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headerExtensionsValue.isUndefined()) {
        result.headerExtensions = convert<IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>>(lexicalGlobalObject, headerExtensionsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue degradationPreferenceValue;
    if (isNullOrUndefined)
        degradationPreferenceValue = jsUndefined();
    else {
        degradationPreferenceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "degradationPreference"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!degradationPreferenceValue.isUndefined()) {
        result.degradationPreference = convert<IDLEnumeration<RTCDegradationPreference>>(lexicalGlobalObject, degradationPreferenceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.degradationPreference = RTCDegradationPreference::Balanced;
    JSValue encodingsValue;
    if (isNullOrUndefined)
        encodingsValue = jsUndefined();
    else {
        encodingsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "encodings"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!encodingsValue.isUndefined()) {
        result.encodings = convert<IDLSequence<IDLDictionary<RTCRtpEncodingParameters>>>(lexicalGlobalObject, encodingsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "encodings", "RTCRtpSendParameters", "sequence");
        return { };
    }
    JSValue transactionIdValue;
    if (isNullOrUndefined)
        transactionIdValue = jsUndefined();
    else {
        transactionIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transactionId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transactionIdValue.isUndefined()) {
        result.transactionId = convert<IDLDOMString>(lexicalGlobalObject, transactionIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "transactionId", "RTCRtpSendParameters", "DOMString");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCRtpSendParameters& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLSequence<IDLDictionary<RTCRtpCodecParameters>>::isNullValue(dictionary.codecs)) {
        auto codecsValue = toJS<IDLSequence<IDLDictionary<RTCRtpCodecParameters>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDictionary<RTCRtpCodecParameters>>::extractValueFromNullable(dictionary.codecs));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecs"), codecsValue);
    }
    if (!IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>::isNullValue(dictionary.headerExtensions)) {
        auto headerExtensionsValue = toJS<IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDictionary<RTCRtpHeaderExtensionParameters>>::extractValueFromNullable(dictionary.headerExtensions));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "headerExtensions"), headerExtensionsValue);
    }
    auto degradationPreferenceValue = toJS<IDLEnumeration<RTCDegradationPreference>>(lexicalGlobalObject, dictionary.degradationPreference);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "degradationPreference"), degradationPreferenceValue);
    auto encodingsValue = toJS<IDLSequence<IDLDictionary<RTCRtpEncodingParameters>>>(lexicalGlobalObject, globalObject, dictionary.encodings);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "encodings"), encodingsValue);
    auto transactionIdValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.transactionId);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "transactionId"), transactionIdValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
