/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCSessionDescription.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

String convertEnumerationToString(RTCSdpType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("offer"),
        MAKE_STATIC_STRING_IMPL("pranswer"),
        MAKE_STATIC_STRING_IMPL("answer"),
        MAKE_STATIC_STRING_IMPL("rollback"),
    };
    static_assert(static_cast<size_t>(RTCSdpType::Offer) == 0, "RTCSdpType::Offer is not 0 as expected");
    static_assert(static_cast<size_t>(RTCSdpType::Pranswer) == 1, "RTCSdpType::Pranswer is not 1 as expected");
    static_assert(static_cast<size_t>(RTCSdpType::Answer) == 2, "RTCSdpType::Answer is not 2 as expected");
    static_assert(static_cast<size_t>(RTCSdpType::Rollback) == 3, "RTCSdpType::Rollback is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCSdpType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCSdpType> parseEnumeration<RTCSdpType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "offer")
        return RTCSdpType::Offer;
    if (stringValue == "pranswer")
        return RTCSdpType::Pranswer;
    if (stringValue == "answer")
        return RTCSdpType::Answer;
    if (stringValue == "rollback")
        return RTCSdpType::Rollback;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCSdpType>()
{
    return "\"offer\", \"pranswer\", \"answer\", \"rollback\"";
}

#endif

#if ENABLE(WEB_RTC)

template<> RTCSessionDescription::Init convertDictionary<RTCSessionDescription::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCSessionDescription::Init result;
    JSValue sdpValue;
    if (isNullOrUndefined)
        sdpValue = jsUndefined();
    else {
        sdpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sdp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sdpValue.isUndefined()) {
        result.sdp = convert<IDLDOMString>(lexicalGlobalObject, sdpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sdp = emptyString();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCSdpType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type", "RTCSessionDescriptionInit", "RTCSdpType");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCSessionDescription::Init& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto sdpValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.sdp);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sdp"), sdpValue);
    auto typeValue = toJS<IDLEnumeration<RTCSdpType>>(lexicalGlobalObject, dictionary.type);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCSessionDescriptionPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCSessionDescriptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCSessionDescriptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCSessionDescriptionType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCSessionDescriptionSdp(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCSessionDescriptionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCSessionDescriptionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCSessionDescriptionPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCSessionDescriptionPrototype>(vm.heap)) JSRTCSessionDescriptionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCSessionDescriptionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCSessionDescriptionPrototype, JSRTCSessionDescriptionPrototype::Base);

using JSRTCSessionDescriptionConstructor = JSDOMConstructor<JSRTCSessionDescription>;

template<> EncodedJSValue JSC_HOST_CALL JSRTCSessionDescriptionConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSRTCSessionDescriptionConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptionInitDict = convert<IDLDictionary<RTCSessionDescription::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = RTCSessionDescription::create(WTFMove(descriptionInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<RTCSessionDescription>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSRTCSessionDescriptionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCSessionDescriptionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCSessionDescription::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCSessionDescription"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCSessionDescriptionConstructor::s_info = { "RTCSessionDescription", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCSessionDescriptionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCSessionDescriptionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCSessionDescriptionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCSessionDescriptionConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCSessionDescriptionType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sdp", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCSessionDescriptionSdp), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCSessionDescriptionPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSRTCSessionDescriptionPrototype::s_info = { "RTCSessionDescriptionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCSessionDescriptionPrototype) };

void JSRTCSessionDescriptionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCSessionDescription::info(), JSRTCSessionDescriptionPrototypeTableValues, *this);
}

const ClassInfo JSRTCSessionDescription::s_info = { "RTCSessionDescription", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCSessionDescription) };

JSRTCSessionDescription::JSRTCSessionDescription(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCSessionDescription>&& impl)
    : JSDOMWrapper<RTCSessionDescription>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCSessionDescription::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCSessionDescription>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCSessionDescription::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCSessionDescriptionPrototype::create(vm, &globalObject, JSRTCSessionDescriptionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCSessionDescription::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCSessionDescription>(vm, globalObject);
}

JSValue JSRTCSessionDescription::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCSessionDescriptionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCSessionDescription::destroy(JSC::JSCell* cell)
{
    JSRTCSessionDescription* thisObject = static_cast<JSRTCSessionDescription*>(cell);
    thisObject->JSRTCSessionDescription::~JSRTCSessionDescription();
}

template<> inline JSRTCSessionDescription* IDLAttribute<JSRTCSessionDescription>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCSessionDescription*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCSessionDescription* IDLOperation<JSRTCSessionDescription>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCSessionDescription*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCSessionDescriptionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCSessionDescriptionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCSessionDescription::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCSessionDescriptionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCSessionDescriptionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCSessionDescriptionTypeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCSessionDescription& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCSdpType>>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsRTCSessionDescriptionType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCSessionDescription>::get<jsRTCSessionDescriptionTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsRTCSessionDescriptionSdpGetter(JSGlobalObject& lexicalGlobalObject, JSRTCSessionDescription& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.sdp());
    return result;
}

EncodedJSValue jsRTCSessionDescriptionSdp(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCSessionDescription>::get<jsRTCSessionDescriptionSdpGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sdp");
}

JSC::JSObject* JSRTCSessionDescription::serialize(JSGlobalObject& lexicalGlobalObject, JSRTCSessionDescription& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto typeValue = jsRTCSessionDescriptionTypeGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "type"), typeValue);

    auto sdpValue = jsRTCSessionDescriptionSdpGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "sdp"), sdpValue);

    return result;
}

static inline EncodedJSValue jsRTCSessionDescriptionPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSRTCSessionDescription* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSRTCSessionDescription::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsRTCSessionDescriptionPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCSessionDescription>::call<jsRTCSessionDescriptionPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSRTCSessionDescription::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCSessionDescription*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCSessionDescriptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCSessionDescriptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCSessionDescription = static_cast<JSRTCSessionDescription*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCSessionDescription->wrapped(), jsRTCSessionDescription);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCSessionDescription>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RTCSessionDescription.
    static_assert(!std::is_polymorphic<RTCSessionDescription>::value, "RTCSessionDescription is polymorphic but the IDL claims it is not");
    return createWrapper<RTCSessionDescription>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCSessionDescription& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCSessionDescription* JSRTCSessionDescription::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCSessionDescription*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
