/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(WEB_RTC)

#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "RTCSessionDescription.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSRTCSessionDescription : public JSDOMWrapper<RTCSessionDescription> {
public:
    using Base = JSDOMWrapper<RTCSessionDescription>;
    static JSRTCSessionDescription* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<RTCSessionDescription>&& impl)
    {
        JSRTCSessionDescription* ptr = new (NotNull, JSC::allocateCell<JSRTCSessionDescription>(globalObject->vm().heap)) JSRTCSessionDescription(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static RTCSessionDescription* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static JSC::JSObject* serialize(JSC::JSGlobalObject&, JSRTCSessionDescription& thisObject, JSDOMGlobalObject&, JSC::ThrowScope&);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSRTCSessionDescription(JSC::Structure*, JSDOMGlobalObject&, Ref<RTCSessionDescription>&&);

    void finishCreation(JSC::VM&);
};

class JSRTCSessionDescriptionOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, RTCSessionDescription*)
{
    static NeverDestroyed<JSRTCSessionDescriptionOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(RTCSessionDescription* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, RTCSessionDescription&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCSessionDescription* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<RTCSessionDescription>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<RTCSessionDescription>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<RTCSessionDescription> {
    using WrapperClass = JSRTCSessionDescription;
    using ToWrappedReturnType = RTCSessionDescription*;
};
#if ENABLE(WEB_RTC)

String convertEnumerationToString(RTCSdpType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, RTCSdpType);

template<> Optional<RTCSdpType> parseEnumeration<RTCSdpType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<RTCSdpType>();

#endif

#if ENABLE(WEB_RTC)

template<> RTCSessionDescription::Init convertDictionary<RTCSessionDescription::Init>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCSessionDescription::Init&);

#endif


} // namespace WebCore

#endif // ENABLE(WEB_RTC)
