/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCSignalingState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCSignalingState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("stable"),
        MAKE_STATIC_STRING_IMPL("have-local-offer"),
        MAKE_STATIC_STRING_IMPL("have-remote-offer"),
        MAKE_STATIC_STRING_IMPL("have-local-pranswer"),
        MAKE_STATIC_STRING_IMPL("have-remote-pranswer"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(RTCSignalingState::Stable) == 0, "RTCSignalingState::Stable is not 0 as expected");
    static_assert(static_cast<size_t>(RTCSignalingState::HaveLocalOffer) == 1, "RTCSignalingState::HaveLocalOffer is not 1 as expected");
    static_assert(static_cast<size_t>(RTCSignalingState::HaveRemoteOffer) == 2, "RTCSignalingState::HaveRemoteOffer is not 2 as expected");
    static_assert(static_cast<size_t>(RTCSignalingState::HaveLocalPranswer) == 3, "RTCSignalingState::HaveLocalPranswer is not 3 as expected");
    static_assert(static_cast<size_t>(RTCSignalingState::HaveRemotePranswer) == 4, "RTCSignalingState::HaveRemotePranswer is not 4 as expected");
    static_assert(static_cast<size_t>(RTCSignalingState::Closed) == 5, "RTCSignalingState::Closed is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCSignalingState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCSignalingState> parseEnumeration<RTCSignalingState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "stable")
        return RTCSignalingState::Stable;
    if (stringValue == "have-local-offer")
        return RTCSignalingState::HaveLocalOffer;
    if (stringValue == "have-remote-offer")
        return RTCSignalingState::HaveRemoteOffer;
    if (stringValue == "have-local-pranswer")
        return RTCSignalingState::HaveLocalPranswer;
    if (stringValue == "have-remote-pranswer")
        return RTCSignalingState::HaveRemotePranswer;
    if (stringValue == "closed")
        return RTCSignalingState::Closed;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCSignalingState>()
{
    return "\"stable\", \"have-local-offer\", \"have-remote-offer\", \"have-local-pranswer\", \"have-remote-pranswer\", \"closed\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
