/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCStatsReport.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMapLike.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCStatsReport::Type enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("codec"),
        MAKE_STATIC_STRING_IMPL("inbound-rtp"),
        MAKE_STATIC_STRING_IMPL("outbound-rtp"),
        MAKE_STATIC_STRING_IMPL("peer-connection"),
        MAKE_STATIC_STRING_IMPL("data-channel"),
        MAKE_STATIC_STRING_IMPL("track"),
        MAKE_STATIC_STRING_IMPL("transport"),
        MAKE_STATIC_STRING_IMPL("candidate-pair"),
        MAKE_STATIC_STRING_IMPL("local-candidate"),
        MAKE_STATIC_STRING_IMPL("remote-candidate"),
        MAKE_STATIC_STRING_IMPL("certificate"),
    };
    static_assert(static_cast<size_t>(RTCStatsReport::Type::Codec) == 0, "RTCStatsReport::Type::Codec is not 0 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::InboundRtp) == 1, "RTCStatsReport::Type::InboundRtp is not 1 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::OutboundRtp) == 2, "RTCStatsReport::Type::OutboundRtp is not 2 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::PeerConnection) == 3, "RTCStatsReport::Type::PeerConnection is not 3 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::DataChannel) == 4, "RTCStatsReport::Type::DataChannel is not 4 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::Track) == 5, "RTCStatsReport::Type::Track is not 5 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::Transport) == 6, "RTCStatsReport::Type::Transport is not 6 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::CandidatePair) == 7, "RTCStatsReport::Type::CandidatePair is not 7 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::LocalCandidate) == 8, "RTCStatsReport::Type::LocalCandidate is not 8 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::RemoteCandidate) == 9, "RTCStatsReport::Type::RemoteCandidate is not 9 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::Type::Certificate) == 10, "RTCStatsReport::Type::Certificate is not 10 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCStatsReport::Type enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCStatsReport::Type> parseEnumeration<RTCStatsReport::Type>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "codec")
        return RTCStatsReport::Type::Codec;
    if (stringValue == "inbound-rtp")
        return RTCStatsReport::Type::InboundRtp;
    if (stringValue == "outbound-rtp")
        return RTCStatsReport::Type::OutboundRtp;
    if (stringValue == "peer-connection")
        return RTCStatsReport::Type::PeerConnection;
    if (stringValue == "data-channel")
        return RTCStatsReport::Type::DataChannel;
    if (stringValue == "track")
        return RTCStatsReport::Type::Track;
    if (stringValue == "transport")
        return RTCStatsReport::Type::Transport;
    if (stringValue == "candidate-pair")
        return RTCStatsReport::Type::CandidatePair;
    if (stringValue == "local-candidate")
        return RTCStatsReport::Type::LocalCandidate;
    if (stringValue == "remote-candidate")
        return RTCStatsReport::Type::RemoteCandidate;
    if (stringValue == "certificate")
        return RTCStatsReport::Type::Certificate;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCStatsReport::Type>()
{
    return "\"codec\", \"inbound-rtp\", \"outbound-rtp\", \"peer-connection\", \"data-channel\", \"track\", \"transport\", \"candidate-pair\", \"local-candidate\", \"remote-candidate\", \"certificate\"";
}

String convertEnumerationToString(RTCStatsReport::IceCandidatePairState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("frozen"),
        MAKE_STATIC_STRING_IMPL("waiting"),
        MAKE_STATIC_STRING_IMPL("inprogress"),
        MAKE_STATIC_STRING_IMPL("failed"),
        MAKE_STATIC_STRING_IMPL("succeeded"),
        MAKE_STATIC_STRING_IMPL("cancelled"),
    };
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidatePairState::Frozen) == 0, "RTCStatsReport::IceCandidatePairState::Frozen is not 0 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidatePairState::Waiting) == 1, "RTCStatsReport::IceCandidatePairState::Waiting is not 1 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidatePairState::Inprogress) == 2, "RTCStatsReport::IceCandidatePairState::Inprogress is not 2 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidatePairState::Failed) == 3, "RTCStatsReport::IceCandidatePairState::Failed is not 3 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidatePairState::Succeeded) == 4, "RTCStatsReport::IceCandidatePairState::Succeeded is not 4 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidatePairState::Cancelled) == 5, "RTCStatsReport::IceCandidatePairState::Cancelled is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCStatsReport::IceCandidatePairState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCStatsReport::IceCandidatePairState> parseEnumeration<RTCStatsReport::IceCandidatePairState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "frozen")
        return RTCStatsReport::IceCandidatePairState::Frozen;
    if (stringValue == "waiting")
        return RTCStatsReport::IceCandidatePairState::Waiting;
    if (stringValue == "inprogress")
        return RTCStatsReport::IceCandidatePairState::Inprogress;
    if (stringValue == "failed")
        return RTCStatsReport::IceCandidatePairState::Failed;
    if (stringValue == "succeeded")
        return RTCStatsReport::IceCandidatePairState::Succeeded;
    if (stringValue == "cancelled")
        return RTCStatsReport::IceCandidatePairState::Cancelled;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCStatsReport::IceCandidatePairState>()
{
    return "\"frozen\", \"waiting\", \"inprogress\", \"failed\", \"succeeded\", \"cancelled\"";
}

String convertEnumerationToString(RTCStatsReport::IceCandidateType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("host"),
        MAKE_STATIC_STRING_IMPL("srflx"),
        MAKE_STATIC_STRING_IMPL("prflx"),
        MAKE_STATIC_STRING_IMPL("relay"),
    };
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidateType::Host) == 0, "RTCStatsReport::IceCandidateType::Host is not 0 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidateType::Srflx) == 1, "RTCStatsReport::IceCandidateType::Srflx is not 1 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidateType::Prflx) == 2, "RTCStatsReport::IceCandidateType::Prflx is not 2 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::IceCandidateType::Relay) == 3, "RTCStatsReport::IceCandidateType::Relay is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCStatsReport::IceCandidateType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCStatsReport::IceCandidateType> parseEnumeration<RTCStatsReport::IceCandidateType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "host")
        return RTCStatsReport::IceCandidateType::Host;
    if (stringValue == "srflx")
        return RTCStatsReport::IceCandidateType::Srflx;
    if (stringValue == "prflx")
        return RTCStatsReport::IceCandidateType::Prflx;
    if (stringValue == "relay")
        return RTCStatsReport::IceCandidateType::Relay;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCStatsReport::IceCandidateType>()
{
    return "\"host\", \"srflx\", \"prflx\", \"relay\"";
}

String convertEnumerationToString(RTCStatsReport::CodecType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("encode"),
        MAKE_STATIC_STRING_IMPL("decode"),
    };
    static_assert(static_cast<size_t>(RTCStatsReport::CodecType::Encode) == 0, "RTCStatsReport::CodecType::Encode is not 0 as expected");
    static_assert(static_cast<size_t>(RTCStatsReport::CodecType::Decode) == 1, "RTCStatsReport::CodecType::Decode is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCStatsReport::CodecType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCStatsReport::CodecType> parseEnumeration<RTCStatsReport::CodecType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "encode")
        return RTCStatsReport::CodecType::Encode;
    if (stringValue == "decode")
        return RTCStatsReport::CodecType::Decode;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCStatsReport::CodecType>()
{
    return "\"encode\", \"decode\"";
}

template<> RTCStatsReport::Stats convertDictionary<RTCStatsReport::Stats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::Stats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

template<> RTCStatsReport::RTCRTPStreamStats convertDictionary<RTCStatsReport::RTCRTPStreamStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::RTCRTPStreamStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue associateStatsIdValue;
    if (isNullOrUndefined)
        associateStatsIdValue = jsUndefined();
    else {
        associateStatsIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "associateStatsId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!associateStatsIdValue.isUndefined()) {
        result.associateStatsId = convert<IDLDOMString>(lexicalGlobalObject, associateStatsIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue codecIdValue;
    if (isNullOrUndefined)
        codecIdValue = jsUndefined();
    else {
        codecIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecIdValue.isUndefined()) {
        result.codecId = convert<IDLDOMString>(lexicalGlobalObject, codecIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue firCountValue;
    if (isNullOrUndefined)
        firCountValue = jsUndefined();
    else {
        firCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "firCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!firCountValue.isUndefined()) {
        result.firCount = convert<IDLUnsignedLong>(lexicalGlobalObject, firCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isRemoteValue;
    if (isNullOrUndefined)
        isRemoteValue = jsUndefined();
    else {
        isRemoteValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isRemote"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isRemoteValue.isUndefined()) {
        result.isRemote = convert<IDLBoolean>(lexicalGlobalObject, isRemoteValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isRemote = false;
    JSValue mediaTypeValue;
    if (isNullOrUndefined)
        mediaTypeValue = jsUndefined();
    else {
        mediaTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mediaType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mediaTypeValue.isUndefined()) {
        result.mediaType = convert<IDLDOMString>(lexicalGlobalObject, mediaTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nackCountValue;
    if (isNullOrUndefined)
        nackCountValue = jsUndefined();
    else {
        nackCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "nackCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nackCountValue.isUndefined()) {
        result.nackCount = convert<IDLUnsignedLong>(lexicalGlobalObject, nackCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pliCountValue;
    if (isNullOrUndefined)
        pliCountValue = jsUndefined();
    else {
        pliCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pliCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pliCountValue.isUndefined()) {
        result.pliCount = convert<IDLUnsignedLong>(lexicalGlobalObject, pliCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue qpSumValue;
    if (isNullOrUndefined)
        qpSumValue = jsUndefined();
    else {
        qpSumValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "qpSum"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!qpSumValue.isUndefined()) {
        result.qpSum = convert<IDLUnsignedLongLong>(lexicalGlobalObject, qpSumValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sliCountValue;
    if (isNullOrUndefined)
        sliCountValue = jsUndefined();
    else {
        sliCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sliCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sliCountValue.isUndefined()) {
        result.sliCount = convert<IDLUnsignedLong>(lexicalGlobalObject, sliCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ssrcValue;
    if (isNullOrUndefined)
        ssrcValue = jsUndefined();
    else {
        ssrcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ssrc"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ssrcValue.isUndefined()) {
        result.ssrc = convert<IDLUnsignedLong>(lexicalGlobalObject, ssrcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue trackIdValue;
    if (isNullOrUndefined)
        trackIdValue = jsUndefined();
    else {
        trackIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "trackId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!trackIdValue.isUndefined()) {
        result.trackId = convert<IDLDOMString>(lexicalGlobalObject, trackIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue transportIdValue;
    if (isNullOrUndefined)
        transportIdValue = jsUndefined();
    else {
        transportIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transportId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transportIdValue.isUndefined()) {
        result.transportId = convert<IDLDOMString>(lexicalGlobalObject, transportIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

template<> RTCStatsReport::InboundRTPStreamStats convertDictionary<RTCStatsReport::InboundRTPStreamStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::InboundRTPStreamStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue associateStatsIdValue;
    if (isNullOrUndefined)
        associateStatsIdValue = jsUndefined();
    else {
        associateStatsIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "associateStatsId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!associateStatsIdValue.isUndefined()) {
        result.associateStatsId = convert<IDLDOMString>(lexicalGlobalObject, associateStatsIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue codecIdValue;
    if (isNullOrUndefined)
        codecIdValue = jsUndefined();
    else {
        codecIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecIdValue.isUndefined()) {
        result.codecId = convert<IDLDOMString>(lexicalGlobalObject, codecIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue firCountValue;
    if (isNullOrUndefined)
        firCountValue = jsUndefined();
    else {
        firCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "firCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!firCountValue.isUndefined()) {
        result.firCount = convert<IDLUnsignedLong>(lexicalGlobalObject, firCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isRemoteValue;
    if (isNullOrUndefined)
        isRemoteValue = jsUndefined();
    else {
        isRemoteValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isRemote"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isRemoteValue.isUndefined()) {
        result.isRemote = convert<IDLBoolean>(lexicalGlobalObject, isRemoteValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isRemote = false;
    JSValue mediaTypeValue;
    if (isNullOrUndefined)
        mediaTypeValue = jsUndefined();
    else {
        mediaTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mediaType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mediaTypeValue.isUndefined()) {
        result.mediaType = convert<IDLDOMString>(lexicalGlobalObject, mediaTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nackCountValue;
    if (isNullOrUndefined)
        nackCountValue = jsUndefined();
    else {
        nackCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "nackCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nackCountValue.isUndefined()) {
        result.nackCount = convert<IDLUnsignedLong>(lexicalGlobalObject, nackCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pliCountValue;
    if (isNullOrUndefined)
        pliCountValue = jsUndefined();
    else {
        pliCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pliCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pliCountValue.isUndefined()) {
        result.pliCount = convert<IDLUnsignedLong>(lexicalGlobalObject, pliCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue qpSumValue;
    if (isNullOrUndefined)
        qpSumValue = jsUndefined();
    else {
        qpSumValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "qpSum"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!qpSumValue.isUndefined()) {
        result.qpSum = convert<IDLUnsignedLongLong>(lexicalGlobalObject, qpSumValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sliCountValue;
    if (isNullOrUndefined)
        sliCountValue = jsUndefined();
    else {
        sliCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sliCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sliCountValue.isUndefined()) {
        result.sliCount = convert<IDLUnsignedLong>(lexicalGlobalObject, sliCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ssrcValue;
    if (isNullOrUndefined)
        ssrcValue = jsUndefined();
    else {
        ssrcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ssrc"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ssrcValue.isUndefined()) {
        result.ssrc = convert<IDLUnsignedLong>(lexicalGlobalObject, ssrcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue trackIdValue;
    if (isNullOrUndefined)
        trackIdValue = jsUndefined();
    else {
        trackIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "trackId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!trackIdValue.isUndefined()) {
        result.trackId = convert<IDLDOMString>(lexicalGlobalObject, trackIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue transportIdValue;
    if (isNullOrUndefined)
        transportIdValue = jsUndefined();
    else {
        transportIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transportId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transportIdValue.isUndefined()) {
        result.transportId = convert<IDLDOMString>(lexicalGlobalObject, transportIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue burstDiscardCountValue;
    if (isNullOrUndefined)
        burstDiscardCountValue = jsUndefined();
    else {
        burstDiscardCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "burstDiscardCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!burstDiscardCountValue.isUndefined()) {
        result.burstDiscardCount = convert<IDLUnsignedLong>(lexicalGlobalObject, burstDiscardCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue burstDiscardRateValue;
    if (isNullOrUndefined)
        burstDiscardRateValue = jsUndefined();
    else {
        burstDiscardRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "burstDiscardRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!burstDiscardRateValue.isUndefined()) {
        result.burstDiscardRate = convert<IDLDouble>(lexicalGlobalObject, burstDiscardRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue burstLossCountValue;
    if (isNullOrUndefined)
        burstLossCountValue = jsUndefined();
    else {
        burstLossCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "burstLossCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!burstLossCountValue.isUndefined()) {
        result.burstLossCount = convert<IDLUnsignedLong>(lexicalGlobalObject, burstLossCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue burstLossRateValue;
    if (isNullOrUndefined)
        burstLossRateValue = jsUndefined();
    else {
        burstLossRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "burstLossRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!burstLossRateValue.isUndefined()) {
        result.burstLossRate = convert<IDLDouble>(lexicalGlobalObject, burstLossRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue burstPacketsDiscardedValue;
    if (isNullOrUndefined)
        burstPacketsDiscardedValue = jsUndefined();
    else {
        burstPacketsDiscardedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "burstPacketsDiscarded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!burstPacketsDiscardedValue.isUndefined()) {
        result.burstPacketsDiscarded = convert<IDLUnsignedLong>(lexicalGlobalObject, burstPacketsDiscardedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue burstPacketsLostValue;
    if (isNullOrUndefined)
        burstPacketsLostValue = jsUndefined();
    else {
        burstPacketsLostValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "burstPacketsLost"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!burstPacketsLostValue.isUndefined()) {
        result.burstPacketsLost = convert<IDLUnsignedLong>(lexicalGlobalObject, burstPacketsLostValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesReceivedValue;
    if (isNullOrUndefined)
        bytesReceivedValue = jsUndefined();
    else {
        bytesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesReceivedValue.isUndefined()) {
        result.bytesReceived = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fractionLostValue;
    if (isNullOrUndefined)
        fractionLostValue = jsUndefined();
    else {
        fractionLostValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fractionLost"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fractionLostValue.isUndefined()) {
        result.fractionLost = convert<IDLDouble>(lexicalGlobalObject, fractionLostValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesDecodedValue;
    if (isNullOrUndefined)
        framesDecodedValue = jsUndefined();
    else {
        framesDecodedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesDecoded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesDecodedValue.isUndefined()) {
        result.framesDecoded = convert<IDLUnsignedLong>(lexicalGlobalObject, framesDecodedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue gapDiscardRateValue;
    if (isNullOrUndefined)
        gapDiscardRateValue = jsUndefined();
    else {
        gapDiscardRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "gapDiscardRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!gapDiscardRateValue.isUndefined()) {
        result.gapDiscardRate = convert<IDLDouble>(lexicalGlobalObject, gapDiscardRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue gapLossRateValue;
    if (isNullOrUndefined)
        gapLossRateValue = jsUndefined();
    else {
        gapLossRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "gapLossRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!gapLossRateValue.isUndefined()) {
        result.gapLossRate = convert<IDLDouble>(lexicalGlobalObject, gapLossRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue jitterValue;
    if (isNullOrUndefined)
        jitterValue = jsUndefined();
    else {
        jitterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "jitter"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!jitterValue.isUndefined()) {
        result.jitter = convert<IDLDouble>(lexicalGlobalObject, jitterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue packetsDiscardedValue;
    if (isNullOrUndefined)
        packetsDiscardedValue = jsUndefined();
    else {
        packetsDiscardedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsDiscarded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!packetsDiscardedValue.isUndefined()) {
        result.packetsDiscarded = convert<IDLUnsignedLong>(lexicalGlobalObject, packetsDiscardedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue packetsLostValue;
    if (isNullOrUndefined)
        packetsLostValue = jsUndefined();
    else {
        packetsLostValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsLost"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!packetsLostValue.isUndefined()) {
        result.packetsLost = convert<IDLUnsignedLong>(lexicalGlobalObject, packetsLostValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue packetsReceivedValue;
    if (isNullOrUndefined)
        packetsReceivedValue = jsUndefined();
    else {
        packetsReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!packetsReceivedValue.isUndefined()) {
        result.packetsReceived = convert<IDLUnsignedLong>(lexicalGlobalObject, packetsReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue packetsRepairedValue;
    if (isNullOrUndefined)
        packetsRepairedValue = jsUndefined();
    else {
        packetsRepairedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsRepaired"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!packetsRepairedValue.isUndefined()) {
        result.packetsRepaired = convert<IDLUnsignedLong>(lexicalGlobalObject, packetsRepairedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::InboundRTPStreamStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.associateStatsId)) {
        auto associateStatsIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.associateStatsId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "associateStatsId"), associateStatsIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.codecId)) {
        auto codecIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.codecId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecId"), codecIdValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.firCount)) {
        auto firCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.firCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "firCount"), firCountValue);
    }
    auto isRemoteValue = toJS<IDLBoolean>(dictionary.isRemote);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "isRemote"), isRemoteValue);
    if (!IDLDOMString::isNullValue(dictionary.mediaType)) {
        auto mediaTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.mediaType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mediaType"), mediaTypeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.nackCount)) {
        auto nackCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.nackCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "nackCount"), nackCountValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.pliCount)) {
        auto pliCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.pliCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pliCount"), pliCountValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.qpSum)) {
        auto qpSumValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.qpSum));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "qpSum"), qpSumValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.sliCount)) {
        auto sliCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.sliCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sliCount"), sliCountValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.ssrc)) {
        auto ssrcValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.ssrc));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ssrc"), ssrcValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.trackId)) {
        auto trackIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.trackId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "trackId"), trackIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.transportId)) {
        auto transportIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.transportId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "transportId"), transportIdValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.burstDiscardCount)) {
        auto burstDiscardCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.burstDiscardCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "burstDiscardCount"), burstDiscardCountValue);
    }
    if (!IDLDouble::isNullValue(dictionary.burstDiscardRate)) {
        auto burstDiscardRateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.burstDiscardRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "burstDiscardRate"), burstDiscardRateValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.burstLossCount)) {
        auto burstLossCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.burstLossCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "burstLossCount"), burstLossCountValue);
    }
    if (!IDLDouble::isNullValue(dictionary.burstLossRate)) {
        auto burstLossRateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.burstLossRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "burstLossRate"), burstLossRateValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.burstPacketsDiscarded)) {
        auto burstPacketsDiscardedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.burstPacketsDiscarded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "burstPacketsDiscarded"), burstPacketsDiscardedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.burstPacketsLost)) {
        auto burstPacketsLostValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.burstPacketsLost));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "burstPacketsLost"), burstPacketsLostValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesReceived)) {
        auto bytesReceivedValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesReceived"), bytesReceivedValue);
    }
    if (!IDLDouble::isNullValue(dictionary.fractionLost)) {
        auto fractionLostValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.fractionLost));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fractionLost"), fractionLostValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesDecoded)) {
        auto framesDecodedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesDecoded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesDecoded"), framesDecodedValue);
    }
    if (!IDLDouble::isNullValue(dictionary.gapDiscardRate)) {
        auto gapDiscardRateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.gapDiscardRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "gapDiscardRate"), gapDiscardRateValue);
    }
    if (!IDLDouble::isNullValue(dictionary.gapLossRate)) {
        auto gapLossRateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.gapLossRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "gapLossRate"), gapLossRateValue);
    }
    if (!IDLDouble::isNullValue(dictionary.jitter)) {
        auto jitterValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.jitter));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "jitter"), jitterValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.packetsDiscarded)) {
        auto packetsDiscardedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.packetsDiscarded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "packetsDiscarded"), packetsDiscardedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.packetsLost)) {
        auto packetsLostValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.packetsLost));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "packetsLost"), packetsLostValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.packetsReceived)) {
        auto packetsReceivedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.packetsReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "packetsReceived"), packetsReceivedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.packetsRepaired)) {
        auto packetsRepairedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.packetsRepaired));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "packetsRepaired"), packetsRepairedValue);
    }
    return result;
}

template<> RTCStatsReport::OutboundRTPStreamStats convertDictionary<RTCStatsReport::OutboundRTPStreamStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::OutboundRTPStreamStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue associateStatsIdValue;
    if (isNullOrUndefined)
        associateStatsIdValue = jsUndefined();
    else {
        associateStatsIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "associateStatsId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!associateStatsIdValue.isUndefined()) {
        result.associateStatsId = convert<IDLDOMString>(lexicalGlobalObject, associateStatsIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue codecIdValue;
    if (isNullOrUndefined)
        codecIdValue = jsUndefined();
    else {
        codecIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecIdValue.isUndefined()) {
        result.codecId = convert<IDLDOMString>(lexicalGlobalObject, codecIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue firCountValue;
    if (isNullOrUndefined)
        firCountValue = jsUndefined();
    else {
        firCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "firCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!firCountValue.isUndefined()) {
        result.firCount = convert<IDLUnsignedLong>(lexicalGlobalObject, firCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isRemoteValue;
    if (isNullOrUndefined)
        isRemoteValue = jsUndefined();
    else {
        isRemoteValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isRemote"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isRemoteValue.isUndefined()) {
        result.isRemote = convert<IDLBoolean>(lexicalGlobalObject, isRemoteValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isRemote = false;
    JSValue mediaTypeValue;
    if (isNullOrUndefined)
        mediaTypeValue = jsUndefined();
    else {
        mediaTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mediaType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mediaTypeValue.isUndefined()) {
        result.mediaType = convert<IDLDOMString>(lexicalGlobalObject, mediaTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nackCountValue;
    if (isNullOrUndefined)
        nackCountValue = jsUndefined();
    else {
        nackCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "nackCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nackCountValue.isUndefined()) {
        result.nackCount = convert<IDLUnsignedLong>(lexicalGlobalObject, nackCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pliCountValue;
    if (isNullOrUndefined)
        pliCountValue = jsUndefined();
    else {
        pliCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pliCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pliCountValue.isUndefined()) {
        result.pliCount = convert<IDLUnsignedLong>(lexicalGlobalObject, pliCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue qpSumValue;
    if (isNullOrUndefined)
        qpSumValue = jsUndefined();
    else {
        qpSumValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "qpSum"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!qpSumValue.isUndefined()) {
        result.qpSum = convert<IDLUnsignedLongLong>(lexicalGlobalObject, qpSumValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sliCountValue;
    if (isNullOrUndefined)
        sliCountValue = jsUndefined();
    else {
        sliCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sliCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sliCountValue.isUndefined()) {
        result.sliCount = convert<IDLUnsignedLong>(lexicalGlobalObject, sliCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ssrcValue;
    if (isNullOrUndefined)
        ssrcValue = jsUndefined();
    else {
        ssrcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ssrc"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ssrcValue.isUndefined()) {
        result.ssrc = convert<IDLUnsignedLong>(lexicalGlobalObject, ssrcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue trackIdValue;
    if (isNullOrUndefined)
        trackIdValue = jsUndefined();
    else {
        trackIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "trackId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!trackIdValue.isUndefined()) {
        result.trackId = convert<IDLDOMString>(lexicalGlobalObject, trackIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue transportIdValue;
    if (isNullOrUndefined)
        transportIdValue = jsUndefined();
    else {
        transportIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transportId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transportIdValue.isUndefined()) {
        result.transportId = convert<IDLDOMString>(lexicalGlobalObject, transportIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesSentValue;
    if (isNullOrUndefined)
        bytesSentValue = jsUndefined();
    else {
        bytesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesSentValue.isUndefined()) {
        result.bytesSent = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesEncodedValue;
    if (isNullOrUndefined)
        framesEncodedValue = jsUndefined();
    else {
        framesEncodedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesEncoded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesEncodedValue.isUndefined()) {
        result.framesEncoded = convert<IDLUnsignedLong>(lexicalGlobalObject, framesEncodedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue packetsSentValue;
    if (isNullOrUndefined)
        packetsSentValue = jsUndefined();
    else {
        packetsSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "packetsSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!packetsSentValue.isUndefined()) {
        result.packetsSent = convert<IDLUnsignedLong>(lexicalGlobalObject, packetsSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetBitrateValue;
    if (isNullOrUndefined)
        targetBitrateValue = jsUndefined();
    else {
        targetBitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetBitrate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetBitrateValue.isUndefined()) {
        result.targetBitrate = convert<IDLDouble>(lexicalGlobalObject, targetBitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::OutboundRTPStreamStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.associateStatsId)) {
        auto associateStatsIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.associateStatsId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "associateStatsId"), associateStatsIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.codecId)) {
        auto codecIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.codecId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecId"), codecIdValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.firCount)) {
        auto firCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.firCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "firCount"), firCountValue);
    }
    auto isRemoteValue = toJS<IDLBoolean>(dictionary.isRemote);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "isRemote"), isRemoteValue);
    if (!IDLDOMString::isNullValue(dictionary.mediaType)) {
        auto mediaTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.mediaType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mediaType"), mediaTypeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.nackCount)) {
        auto nackCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.nackCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "nackCount"), nackCountValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.pliCount)) {
        auto pliCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.pliCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pliCount"), pliCountValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.qpSum)) {
        auto qpSumValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.qpSum));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "qpSum"), qpSumValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.sliCount)) {
        auto sliCountValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.sliCount));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sliCount"), sliCountValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.ssrc)) {
        auto ssrcValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.ssrc));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ssrc"), ssrcValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.trackId)) {
        auto trackIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.trackId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "trackId"), trackIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.transportId)) {
        auto transportIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.transportId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "transportId"), transportIdValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesSent)) {
        auto bytesSentValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesSent"), bytesSentValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesEncoded)) {
        auto framesEncodedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesEncoded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesEncoded"), framesEncodedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.packetsSent)) {
        auto packetsSentValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.packetsSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "packetsSent"), packetsSentValue);
    }
    if (!IDLDouble::isNullValue(dictionary.targetBitrate)) {
        auto targetBitrateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.targetBitrate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetBitrate"), targetBitrateValue);
    }
    return result;
}

template<> RTCStatsReport::MediaStreamTrackStats convertDictionary<RTCStatsReport::MediaStreamTrackStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::MediaStreamTrackStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue audioLevelValue;
    if (isNullOrUndefined)
        audioLevelValue = jsUndefined();
    else {
        audioLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audioLevel"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!audioLevelValue.isUndefined()) {
        result.audioLevel = convert<IDLDouble>(lexicalGlobalObject, audioLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue detachedValue;
    if (isNullOrUndefined)
        detachedValue = jsUndefined();
    else {
        detachedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detached"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detachedValue.isUndefined()) {
        result.detached = convert<IDLBoolean>(lexicalGlobalObject, detachedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoReturnLossValue;
    if (isNullOrUndefined)
        echoReturnLossValue = jsUndefined();
    else {
        echoReturnLossValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoReturnLoss"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoReturnLossValue.isUndefined()) {
        result.echoReturnLoss = convert<IDLDouble>(lexicalGlobalObject, echoReturnLossValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoReturnLossEnhancementValue;
    if (isNullOrUndefined)
        echoReturnLossEnhancementValue = jsUndefined();
    else {
        echoReturnLossEnhancementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoReturnLossEnhancement"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoReturnLossEnhancementValue.isUndefined()) {
        result.echoReturnLossEnhancement = convert<IDLDouble>(lexicalGlobalObject, echoReturnLossEnhancementValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue endedValue;
    if (isNullOrUndefined)
        endedValue = jsUndefined();
    else {
        endedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ended"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endedValue.isUndefined()) {
        result.ended = convert<IDLBoolean>(lexicalGlobalObject, endedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameHeightValue;
    if (isNullOrUndefined)
        frameHeightValue = jsUndefined();
    else {
        frameHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameHeight"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameHeightValue.isUndefined()) {
        result.frameHeight = convert<IDLUnsignedLong>(lexicalGlobalObject, frameHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameWidthValue;
    if (isNullOrUndefined)
        frameWidthValue = jsUndefined();
    else {
        frameWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameWidth"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameWidthValue.isUndefined()) {
        result.frameWidth = convert<IDLUnsignedLong>(lexicalGlobalObject, frameWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesCorruptedValue;
    if (isNullOrUndefined)
        framesCorruptedValue = jsUndefined();
    else {
        framesCorruptedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesCorrupted"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesCorruptedValue.isUndefined()) {
        result.framesCorrupted = convert<IDLUnsignedLong>(lexicalGlobalObject, framesCorruptedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesDecodedValue;
    if (isNullOrUndefined)
        framesDecodedValue = jsUndefined();
    else {
        framesDecodedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesDecoded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesDecodedValue.isUndefined()) {
        result.framesDecoded = convert<IDLUnsignedLong>(lexicalGlobalObject, framesDecodedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesDroppedValue;
    if (isNullOrUndefined)
        framesDroppedValue = jsUndefined();
    else {
        framesDroppedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesDropped"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesDroppedValue.isUndefined()) {
        result.framesDropped = convert<IDLUnsignedLong>(lexicalGlobalObject, framesDroppedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesPerSecondValue;
    if (isNullOrUndefined)
        framesPerSecondValue = jsUndefined();
    else {
        framesPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesPerSecond"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesPerSecondValue.isUndefined()) {
        result.framesPerSecond = convert<IDLDouble>(lexicalGlobalObject, framesPerSecondValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesReceivedValue;
    if (isNullOrUndefined)
        framesReceivedValue = jsUndefined();
    else {
        framesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesReceivedValue.isUndefined()) {
        result.framesReceived = convert<IDLUnsignedLong>(lexicalGlobalObject, framesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue framesSentValue;
    if (isNullOrUndefined)
        framesSentValue = jsUndefined();
    else {
        framesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "framesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!framesSentValue.isUndefined()) {
        result.framesSent = convert<IDLUnsignedLong>(lexicalGlobalObject, framesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fullFramesLostValue;
    if (isNullOrUndefined)
        fullFramesLostValue = jsUndefined();
    else {
        fullFramesLostValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fullFramesLost"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fullFramesLostValue.isUndefined()) {
        result.fullFramesLost = convert<IDLUnsignedLong>(lexicalGlobalObject, fullFramesLostValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue partialFramesLostValue;
    if (isNullOrUndefined)
        partialFramesLostValue = jsUndefined();
    else {
        partialFramesLostValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "partialFramesLost"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!partialFramesLostValue.isUndefined()) {
        result.partialFramesLost = convert<IDLUnsignedLong>(lexicalGlobalObject, partialFramesLostValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue remoteSourceValue;
    if (isNullOrUndefined)
        remoteSourceValue = jsUndefined();
    else {
        remoteSourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "remoteSource"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!remoteSourceValue.isUndefined()) {
        result.remoteSource = convert<IDLBoolean>(lexicalGlobalObject, remoteSourceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue trackIdentifierValue;
    if (isNullOrUndefined)
        trackIdentifierValue = jsUndefined();
    else {
        trackIdentifierValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "trackIdentifier"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!trackIdentifierValue.isUndefined()) {
        result.trackIdentifier = convert<IDLDOMString>(lexicalGlobalObject, trackIdentifierValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::MediaStreamTrackStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.audioLevel)) {
        auto audioLevelValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.audioLevel));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "audioLevel"), audioLevelValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.detached)) {
        auto detachedValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.detached));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "detached"), detachedValue);
    }
    if (!IDLDouble::isNullValue(dictionary.echoReturnLoss)) {
        auto echoReturnLossValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.echoReturnLoss));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoReturnLoss"), echoReturnLossValue);
    }
    if (!IDLDouble::isNullValue(dictionary.echoReturnLossEnhancement)) {
        auto echoReturnLossEnhancementValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.echoReturnLossEnhancement));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoReturnLossEnhancement"), echoReturnLossEnhancementValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.ended)) {
        auto endedValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.ended));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ended"), endedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.frameHeight)) {
        auto frameHeightValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.frameHeight));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameHeight"), frameHeightValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.frameWidth)) {
        auto frameWidthValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.frameWidth));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameWidth"), frameWidthValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesCorrupted)) {
        auto framesCorruptedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesCorrupted));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesCorrupted"), framesCorruptedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesDecoded)) {
        auto framesDecodedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesDecoded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesDecoded"), framesDecodedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesDropped)) {
        auto framesDroppedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesDropped));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesDropped"), framesDroppedValue);
    }
    if (!IDLDouble::isNullValue(dictionary.framesPerSecond)) {
        auto framesPerSecondValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.framesPerSecond));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesPerSecond"), framesPerSecondValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesReceived)) {
        auto framesReceivedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesReceived"), framesReceivedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.framesSent)) {
        auto framesSentValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.framesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "framesSent"), framesSentValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.fullFramesLost)) {
        auto fullFramesLostValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.fullFramesLost));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fullFramesLost"), fullFramesLostValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.partialFramesLost)) {
        auto partialFramesLostValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.partialFramesLost));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "partialFramesLost"), partialFramesLostValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.remoteSource)) {
        auto remoteSourceValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.remoteSource));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "remoteSource"), remoteSourceValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.trackIdentifier)) {
        auto trackIdentifierValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.trackIdentifier));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "trackIdentifier"), trackIdentifierValue);
    }
    return result;
}

template<> RTCStatsReport::DataChannelStats convertDictionary<RTCStatsReport::DataChannelStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::DataChannelStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesReceivedValue;
    if (isNullOrUndefined)
        bytesReceivedValue = jsUndefined();
    else {
        bytesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesReceivedValue.isUndefined()) {
        result.bytesReceived = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesSentValue;
    if (isNullOrUndefined)
        bytesSentValue = jsUndefined();
    else {
        bytesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesSentValue.isUndefined()) {
        result.bytesSent = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue datachannelidValue;
    if (isNullOrUndefined)
        datachannelidValue = jsUndefined();
    else {
        datachannelidValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "datachannelid"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!datachannelidValue.isUndefined()) {
        result.datachannelid = convert<IDLLong>(lexicalGlobalObject, datachannelidValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue messagesReceivedValue;
    if (isNullOrUndefined)
        messagesReceivedValue = jsUndefined();
    else {
        messagesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "messagesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!messagesReceivedValue.isUndefined()) {
        result.messagesReceived = convert<IDLUnsignedLong>(lexicalGlobalObject, messagesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue messagesSentValue;
    if (isNullOrUndefined)
        messagesSentValue = jsUndefined();
    else {
        messagesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "messagesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!messagesSentValue.isUndefined()) {
        result.messagesSent = convert<IDLUnsignedLong>(lexicalGlobalObject, messagesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue protocolValue;
    if (isNullOrUndefined)
        protocolValue = jsUndefined();
    else {
        protocolValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "protocol"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!protocolValue.isUndefined()) {
        result.protocol = convert<IDLDOMString>(lexicalGlobalObject, protocolValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stateValue;
    if (isNullOrUndefined)
        stateValue = jsUndefined();
    else {
        stateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "state"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stateValue.isUndefined()) {
        result.state = convert<IDLDOMString>(lexicalGlobalObject, stateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::DataChannelStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesReceived)) {
        auto bytesReceivedValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesReceived"), bytesReceivedValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesSent)) {
        auto bytesSentValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesSent"), bytesSentValue);
    }
    if (!IDLLong::isNullValue(dictionary.datachannelid)) {
        auto datachannelidValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.datachannelid));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "datachannelid"), datachannelidValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.label)) {
        auto labelValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.label));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "label"), labelValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.messagesReceived)) {
        auto messagesReceivedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.messagesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "messagesReceived"), messagesReceivedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.messagesSent)) {
        auto messagesSentValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.messagesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "messagesSent"), messagesSentValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.protocol)) {
        auto protocolValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.protocol));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "protocol"), protocolValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.state)) {
        auto stateValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.state));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "state"), stateValue);
    }
    return result;
}

template<> RTCStatsReport::IceCandidatePairStats convertDictionary<RTCStatsReport::IceCandidatePairStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::IceCandidatePairStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue availableIncomingBitrateValue;
    if (isNullOrUndefined)
        availableIncomingBitrateValue = jsUndefined();
    else {
        availableIncomingBitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "availableIncomingBitrate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!availableIncomingBitrateValue.isUndefined()) {
        result.availableIncomingBitrate = convert<IDLDouble>(lexicalGlobalObject, availableIncomingBitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue availableOutgoingBitrateValue;
    if (isNullOrUndefined)
        availableOutgoingBitrateValue = jsUndefined();
    else {
        availableOutgoingBitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "availableOutgoingBitrate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!availableOutgoingBitrateValue.isUndefined()) {
        result.availableOutgoingBitrate = convert<IDLDouble>(lexicalGlobalObject, availableOutgoingBitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesReceivedValue;
    if (isNullOrUndefined)
        bytesReceivedValue = jsUndefined();
    else {
        bytesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesReceivedValue.isUndefined()) {
        result.bytesReceived = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesSentValue;
    if (isNullOrUndefined)
        bytesSentValue = jsUndefined();
    else {
        bytesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesSentValue.isUndefined()) {
        result.bytesSent = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue currentRoundTripTimeValue;
    if (isNullOrUndefined)
        currentRoundTripTimeValue = jsUndefined();
    else {
        currentRoundTripTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "currentRoundTripTime"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!currentRoundTripTimeValue.isUndefined()) {
        result.currentRoundTripTime = convert<IDLDouble>(lexicalGlobalObject, currentRoundTripTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue localCandidateIdValue;
    if (isNullOrUndefined)
        localCandidateIdValue = jsUndefined();
    else {
        localCandidateIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "localCandidateId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!localCandidateIdValue.isUndefined()) {
        result.localCandidateId = convert<IDLDOMString>(lexicalGlobalObject, localCandidateIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nominatedValue;
    if (isNullOrUndefined)
        nominatedValue = jsUndefined();
    else {
        nominatedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "nominated"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nominatedValue.isUndefined()) {
        result.nominated = convert<IDLBoolean>(lexicalGlobalObject, nominatedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue priorityValue;
    if (isNullOrUndefined)
        priorityValue = jsUndefined();
    else {
        priorityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "priority"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!priorityValue.isUndefined()) {
        result.priority = convert<IDLUnsignedLongLong>(lexicalGlobalObject, priorityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue readableValue;
    if (isNullOrUndefined)
        readableValue = jsUndefined();
    else {
        readableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "readable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!readableValue.isUndefined()) {
        result.readable = convert<IDLBoolean>(lexicalGlobalObject, readableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue remoteCandidateIdValue;
    if (isNullOrUndefined)
        remoteCandidateIdValue = jsUndefined();
    else {
        remoteCandidateIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "remoteCandidateId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!remoteCandidateIdValue.isUndefined()) {
        result.remoteCandidateId = convert<IDLDOMString>(lexicalGlobalObject, remoteCandidateIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue requestsReceivedValue;
    if (isNullOrUndefined)
        requestsReceivedValue = jsUndefined();
    else {
        requestsReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestsReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestsReceivedValue.isUndefined()) {
        result.requestsReceived = convert<IDLUnsignedLongLong>(lexicalGlobalObject, requestsReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue requestsSentValue;
    if (isNullOrUndefined)
        requestsSentValue = jsUndefined();
    else {
        requestsSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requestsSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestsSentValue.isUndefined()) {
        result.requestsSent = convert<IDLUnsignedLongLong>(lexicalGlobalObject, requestsSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue responsesReceivedValue;
    if (isNullOrUndefined)
        responsesReceivedValue = jsUndefined();
    else {
        responsesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "responsesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!responsesReceivedValue.isUndefined()) {
        result.responsesReceived = convert<IDLUnsignedLongLong>(lexicalGlobalObject, responsesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue responsesSentValue;
    if (isNullOrUndefined)
        responsesSentValue = jsUndefined();
    else {
        responsesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "responsesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!responsesSentValue.isUndefined()) {
        result.responsesSent = convert<IDLUnsignedLongLong>(lexicalGlobalObject, responsesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stateValue;
    if (isNullOrUndefined)
        stateValue = jsUndefined();
    else {
        stateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "state"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stateValue.isUndefined()) {
        result.state = convert<IDLEnumeration<RTCStatsReport::IceCandidatePairState>>(lexicalGlobalObject, stateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue totalRoundTripTimeValue;
    if (isNullOrUndefined)
        totalRoundTripTimeValue = jsUndefined();
    else {
        totalRoundTripTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "totalRoundTripTime"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!totalRoundTripTimeValue.isUndefined()) {
        result.totalRoundTripTime = convert<IDLDouble>(lexicalGlobalObject, totalRoundTripTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue transportIdValue;
    if (isNullOrUndefined)
        transportIdValue = jsUndefined();
    else {
        transportIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transportId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transportIdValue.isUndefined()) {
        result.transportId = convert<IDLDOMString>(lexicalGlobalObject, transportIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue writableValue;
    if (isNullOrUndefined)
        writableValue = jsUndefined();
    else {
        writableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "writable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!writableValue.isUndefined()) {
        result.writable = convert<IDLBoolean>(lexicalGlobalObject, writableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::IceCandidatePairStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.availableIncomingBitrate)) {
        auto availableIncomingBitrateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.availableIncomingBitrate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "availableIncomingBitrate"), availableIncomingBitrateValue);
    }
    if (!IDLDouble::isNullValue(dictionary.availableOutgoingBitrate)) {
        auto availableOutgoingBitrateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.availableOutgoingBitrate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "availableOutgoingBitrate"), availableOutgoingBitrateValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesReceived)) {
        auto bytesReceivedValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesReceived"), bytesReceivedValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesSent)) {
        auto bytesSentValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesSent"), bytesSentValue);
    }
    if (!IDLDouble::isNullValue(dictionary.currentRoundTripTime)) {
        auto currentRoundTripTimeValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.currentRoundTripTime));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "currentRoundTripTime"), currentRoundTripTimeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.localCandidateId)) {
        auto localCandidateIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.localCandidateId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "localCandidateId"), localCandidateIdValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.nominated)) {
        auto nominatedValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.nominated));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "nominated"), nominatedValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.priority)) {
        auto priorityValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.priority));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "priority"), priorityValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.readable)) {
        auto readableValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.readable));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "readable"), readableValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.remoteCandidateId)) {
        auto remoteCandidateIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.remoteCandidateId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "remoteCandidateId"), remoteCandidateIdValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.requestsReceived)) {
        auto requestsReceivedValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.requestsReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "requestsReceived"), requestsReceivedValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.requestsSent)) {
        auto requestsSentValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.requestsSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "requestsSent"), requestsSentValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.responsesReceived)) {
        auto responsesReceivedValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.responsesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "responsesReceived"), responsesReceivedValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.responsesSent)) {
        auto responsesSentValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.responsesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "responsesSent"), responsesSentValue);
    }
    if (!IDLEnumeration<RTCStatsReport::IceCandidatePairState>::isNullValue(dictionary.state)) {
        auto stateValue = toJS<IDLEnumeration<RTCStatsReport::IceCandidatePairState>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::IceCandidatePairState>::extractValueFromNullable(dictionary.state));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "state"), stateValue);
    }
    if (!IDLDouble::isNullValue(dictionary.totalRoundTripTime)) {
        auto totalRoundTripTimeValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.totalRoundTripTime));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "totalRoundTripTime"), totalRoundTripTimeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.transportId)) {
        auto transportIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.transportId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "transportId"), transportIdValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.writable)) {
        auto writableValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.writable));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "writable"), writableValue);
    }
    return result;
}

template<> RTCStatsReport::IceCandidateStats convertDictionary<RTCStatsReport::IceCandidateStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::IceCandidateStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue addressValue;
    if (isNullOrUndefined)
        addressValue = jsUndefined();
    else {
        addressValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "address"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressValue.isUndefined()) {
        result.address = convert<IDLDOMString>(lexicalGlobalObject, addressValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue candidateTypeValue;
    if (isNullOrUndefined)
        candidateTypeValue = jsUndefined();
    else {
        candidateTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "candidateType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!candidateTypeValue.isUndefined()) {
        result.candidateType = convert<IDLEnumeration<RTCStatsReport::IceCandidateType>>(lexicalGlobalObject, candidateTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deletedValue;
    if (isNullOrUndefined)
        deletedValue = jsUndefined();
    else {
        deletedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deleted"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deletedValue.isUndefined()) {
        result.deleted = convert<IDLBoolean>(lexicalGlobalObject, deletedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.deleted = false;
    JSValue portValue;
    if (isNullOrUndefined)
        portValue = jsUndefined();
    else {
        portValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "port"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!portValue.isUndefined()) {
        result.port = convert<IDLLong>(lexicalGlobalObject, portValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue priorityValue;
    if (isNullOrUndefined)
        priorityValue = jsUndefined();
    else {
        priorityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "priority"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!priorityValue.isUndefined()) {
        result.priority = convert<IDLLong>(lexicalGlobalObject, priorityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue protocolValue;
    if (isNullOrUndefined)
        protocolValue = jsUndefined();
    else {
        protocolValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "protocol"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!protocolValue.isUndefined()) {
        result.protocol = convert<IDLDOMString>(lexicalGlobalObject, protocolValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue transportIdValue;
    if (isNullOrUndefined)
        transportIdValue = jsUndefined();
    else {
        transportIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transportId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transportIdValue.isUndefined()) {
        result.transportId = convert<IDLDOMString>(lexicalGlobalObject, transportIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlValue.isUndefined()) {
        result.url = convert<IDLDOMString>(lexicalGlobalObject, urlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::IceCandidateStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.address)) {
        auto addressValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.address));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "address"), addressValue);
    }
    if (!IDLEnumeration<RTCStatsReport::IceCandidateType>::isNullValue(dictionary.candidateType)) {
        auto candidateTypeValue = toJS<IDLEnumeration<RTCStatsReport::IceCandidateType>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::IceCandidateType>::extractValueFromNullable(dictionary.candidateType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "candidateType"), candidateTypeValue);
    }
    auto deletedValue = toJS<IDLBoolean>(dictionary.deleted);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "deleted"), deletedValue);
    if (!IDLLong::isNullValue(dictionary.port)) {
        auto portValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.port));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "port"), portValue);
    }
    if (!IDLLong::isNullValue(dictionary.priority)) {
        auto priorityValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.priority));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "priority"), priorityValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.protocol)) {
        auto protocolValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.protocol));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "protocol"), protocolValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.transportId)) {
        auto transportIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.transportId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "transportId"), transportIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.url)) {
        auto urlValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.url));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "url"), urlValue);
    }
    return result;
}

template<> RTCStatsReport::CertificateStats convertDictionary<RTCStatsReport::CertificateStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::CertificateStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue base64CertificateValue;
    if (isNullOrUndefined)
        base64CertificateValue = jsUndefined();
    else {
        base64CertificateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "base64Certificate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!base64CertificateValue.isUndefined()) {
        result.base64Certificate = convert<IDLDOMString>(lexicalGlobalObject, base64CertificateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fingerprintValue;
    if (isNullOrUndefined)
        fingerprintValue = jsUndefined();
    else {
        fingerprintValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fingerprint"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fingerprintValue.isUndefined()) {
        result.fingerprint = convert<IDLDOMString>(lexicalGlobalObject, fingerprintValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fingerprintAlgorithmValue;
    if (isNullOrUndefined)
        fingerprintAlgorithmValue = jsUndefined();
    else {
        fingerprintAlgorithmValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fingerprintAlgorithm"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fingerprintAlgorithmValue.isUndefined()) {
        result.fingerprintAlgorithm = convert<IDLDOMString>(lexicalGlobalObject, fingerprintAlgorithmValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue issuerCertificateIdValue;
    if (isNullOrUndefined)
        issuerCertificateIdValue = jsUndefined();
    else {
        issuerCertificateIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "issuerCertificateId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!issuerCertificateIdValue.isUndefined()) {
        result.issuerCertificateId = convert<IDLDOMString>(lexicalGlobalObject, issuerCertificateIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::CertificateStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.base64Certificate)) {
        auto base64CertificateValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.base64Certificate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "base64Certificate"), base64CertificateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.fingerprint)) {
        auto fingerprintValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.fingerprint));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fingerprint"), fingerprintValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.fingerprintAlgorithm)) {
        auto fingerprintAlgorithmValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.fingerprintAlgorithm));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fingerprintAlgorithm"), fingerprintAlgorithmValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.issuerCertificateId)) {
        auto issuerCertificateIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.issuerCertificateId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "issuerCertificateId"), issuerCertificateIdValue);
    }
    return result;
}

template<> RTCStatsReport::CodecStats convertDictionary<RTCStatsReport::CodecStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::CodecStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelsValue;
    if (isNullOrUndefined)
        channelsValue = jsUndefined();
    else {
        channelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channels"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelsValue.isUndefined()) {
        result.channels = convert<IDLUnsignedLong>(lexicalGlobalObject, channelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue clockRateValue;
    if (isNullOrUndefined)
        clockRateValue = jsUndefined();
    else {
        clockRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clockRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clockRateValue.isUndefined()) {
        result.clockRate = convert<IDLUnsignedLong>(lexicalGlobalObject, clockRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue codecTypeValue;
    if (isNullOrUndefined)
        codecTypeValue = jsUndefined();
    else {
        codecTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecTypeValue.isUndefined()) {
        result.codecType = convert<IDLEnumeration<RTCStatsReport::CodecType>>(lexicalGlobalObject, codecTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue mimeTypeValue;
    if (isNullOrUndefined)
        mimeTypeValue = jsUndefined();
    else {
        mimeTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mimeType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mimeTypeValue.isUndefined()) {
        result.mimeType = convert<IDLDOMString>(lexicalGlobalObject, mimeTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue payloadTypeValue;
    if (isNullOrUndefined)
        payloadTypeValue = jsUndefined();
    else {
        payloadTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "payloadType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!payloadTypeValue.isUndefined()) {
        result.payloadType = convert<IDLUnsignedLong>(lexicalGlobalObject, payloadTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sdpFmtpLineValue;
    if (isNullOrUndefined)
        sdpFmtpLineValue = jsUndefined();
    else {
        sdpFmtpLineValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sdpFmtpLine"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sdpFmtpLineValue.isUndefined()) {
        result.sdpFmtpLine = convert<IDLDOMString>(lexicalGlobalObject, sdpFmtpLineValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue transportIdValue;
    if (isNullOrUndefined)
        transportIdValue = jsUndefined();
    else {
        transportIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transportId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transportIdValue.isUndefined()) {
        result.transportId = convert<IDLDOMString>(lexicalGlobalObject, transportIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::CodecStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.channels)) {
        auto channelsValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.channels));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channels"), channelsValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.clockRate)) {
        auto clockRateValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.clockRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "clockRate"), clockRateValue);
    }
    if (!IDLEnumeration<RTCStatsReport::CodecType>::isNullValue(dictionary.codecType)) {
        auto codecTypeValue = toJS<IDLEnumeration<RTCStatsReport::CodecType>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::CodecType>::extractValueFromNullable(dictionary.codecType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecType"), codecTypeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.mimeType)) {
        auto mimeTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.mimeType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mimeType"), mimeTypeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.payloadType)) {
        auto payloadTypeValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.payloadType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "payloadType"), payloadTypeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.sdpFmtpLine)) {
        auto sdpFmtpLineValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.sdpFmtpLine));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sdpFmtpLine"), sdpFmtpLineValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.transportId)) {
        auto transportIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.transportId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "transportId"), transportIdValue);
    }
    return result;
}

template<> RTCStatsReport::TransportStats convertDictionary<RTCStatsReport::TransportStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::TransportStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesReceivedValue;
    if (isNullOrUndefined)
        bytesReceivedValue = jsUndefined();
    else {
        bytesReceivedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesReceived"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesReceivedValue.isUndefined()) {
        result.bytesReceived = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesReceivedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bytesSentValue;
    if (isNullOrUndefined)
        bytesSentValue = jsUndefined();
    else {
        bytesSentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesSent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bytesSentValue.isUndefined()) {
        result.bytesSent = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bytesSentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue localCertificateIdValue;
    if (isNullOrUndefined)
        localCertificateIdValue = jsUndefined();
    else {
        localCertificateIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "localCertificateId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!localCertificateIdValue.isUndefined()) {
        result.localCertificateId = convert<IDLDOMString>(lexicalGlobalObject, localCertificateIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue remoteCertificateIdValue;
    if (isNullOrUndefined)
        remoteCertificateIdValue = jsUndefined();
    else {
        remoteCertificateIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "remoteCertificateId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!remoteCertificateIdValue.isUndefined()) {
        result.remoteCertificateId = convert<IDLDOMString>(lexicalGlobalObject, remoteCertificateIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue rtcpTransportStatsIdValue;
    if (isNullOrUndefined)
        rtcpTransportStatsIdValue = jsUndefined();
    else {
        rtcpTransportStatsIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rtcpTransportStatsId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rtcpTransportStatsIdValue.isUndefined()) {
        result.rtcpTransportStatsId = convert<IDLDOMString>(lexicalGlobalObject, rtcpTransportStatsIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue selectedCandidatePairIdValue;
    if (isNullOrUndefined)
        selectedCandidatePairIdValue = jsUndefined();
    else {
        selectedCandidatePairIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "selectedCandidatePairId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!selectedCandidatePairIdValue.isUndefined()) {
        result.selectedCandidatePairId = convert<IDLDOMString>(lexicalGlobalObject, selectedCandidatePairIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::TransportStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesReceived)) {
        auto bytesReceivedValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesReceived));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesReceived"), bytesReceivedValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.bytesSent)) {
        auto bytesSentValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bytesSent));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bytesSent"), bytesSentValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.localCertificateId)) {
        auto localCertificateIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.localCertificateId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "localCertificateId"), localCertificateIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.remoteCertificateId)) {
        auto remoteCertificateIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.remoteCertificateId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "remoteCertificateId"), remoteCertificateIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.rtcpTransportStatsId)) {
        auto rtcpTransportStatsIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.rtcpTransportStatsId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rtcpTransportStatsId"), rtcpTransportStatsIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.selectedCandidatePairId)) {
        auto selectedCandidatePairIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.selectedCandidatePairId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "selectedCandidatePairId"), selectedCandidatePairIdValue);
    }
    return result;
}

template<> RTCStatsReport::PeerConnectionStats convertDictionary<RTCStatsReport::PeerConnectionStats>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCStatsReport::PeerConnectionStats result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timestampValue.isUndefined()) {
        result.timestamp = convert<IDLDouble>(lexicalGlobalObject, timestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dataChannelsClosedValue;
    if (isNullOrUndefined)
        dataChannelsClosedValue = jsUndefined();
    else {
        dataChannelsClosedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dataChannelsClosed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataChannelsClosedValue.isUndefined()) {
        result.dataChannelsClosed = convert<IDLUnsignedLong>(lexicalGlobalObject, dataChannelsClosedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dataChannelsOpenedValue;
    if (isNullOrUndefined)
        dataChannelsOpenedValue = jsUndefined();
    else {
        dataChannelsOpenedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dataChannelsOpened"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataChannelsOpenedValue.isUndefined()) {
        result.dataChannelsOpened = convert<IDLUnsignedLong>(lexicalGlobalObject, dataChannelsOpenedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCStatsReport::PeerConnectionStats& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDouble::isNullValue(dictionary.timestamp)) {
        auto timestampValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.timestamp));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timestamp"), timestampValue);
    }
    if (!IDLEnumeration<RTCStatsReport::Type>::isNullValue(dictionary.type)) {
        auto typeValue = toJS<IDLEnumeration<RTCStatsReport::Type>>(lexicalGlobalObject, IDLEnumeration<RTCStatsReport::Type>::extractValueFromNullable(dictionary.type));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.dataChannelsClosed)) {
        auto dataChannelsClosedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.dataChannelsClosed));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "dataChannelsClosed"), dataChannelsClosedValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.dataChannelsOpened)) {
        auto dataChannelsOpenedValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.dataChannelsOpened));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "dataChannelsOpened"), dataChannelsOpenedValue);
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionGet(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionHas(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionEntries(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionKeys(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionValues(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionForEach(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCStatsReportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCStatsReportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCStatsReportSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCStatsReportPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCStatsReportPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCStatsReportPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCStatsReportPrototype>(vm.heap)) JSRTCStatsReportPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCStatsReportPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCStatsReportPrototype, JSRTCStatsReportPrototype::Base);

using JSRTCStatsReportConstructor = JSDOMConstructorNotConstructable<JSRTCStatsReport>;

template<> JSValue JSRTCStatsReportConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCStatsReportConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCStatsReport::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCStatsReport"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCStatsReportConstructor::s_info = { "RTCStatsReport", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCStatsReportConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCStatsReportPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCStatsReportConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCStatsReportConstructor) } },
    { "size", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCStatsReportSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "get", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCStatsReportPrototypeFunctionGet), (intptr_t) (1) } },
    { "has", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCStatsReportPrototypeFunctionHas), (intptr_t) (1) } },
    { "entries", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCStatsReportPrototypeFunctionEntries), (intptr_t) (0) } },
    { "keys", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCStatsReportPrototypeFunctionKeys), (intptr_t) (0) } },
    { "values", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCStatsReportPrototypeFunctionValues), (intptr_t) (0) } },
    { "forEach", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCStatsReportPrototypeFunctionForEach), (intptr_t) (1) } },
};

const ClassInfo JSRTCStatsReportPrototype::s_info = { "RTCStatsReportPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCStatsReportPrototype) };

void JSRTCStatsReportPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCStatsReport::info(), JSRTCStatsReportPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, getDirect(vm, vm.propertyNames->builtinNames().entriesPublicName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
}

const ClassInfo JSRTCStatsReport::s_info = { "RTCStatsReport", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCStatsReport) };

JSRTCStatsReport::JSRTCStatsReport(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCStatsReport>&& impl)
    : JSDOMWrapper<RTCStatsReport>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCStatsReport::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCStatsReport>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCStatsReport::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCStatsReportPrototype::create(vm, &globalObject, JSRTCStatsReportPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCStatsReport::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCStatsReport>(vm, globalObject);
}

JSValue JSRTCStatsReport::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCStatsReportConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCStatsReport::destroy(JSC::JSCell* cell)
{
    JSRTCStatsReport* thisObject = static_cast<JSRTCStatsReport*>(cell);
    thisObject->JSRTCStatsReport::~JSRTCStatsReport();
}

template<> inline JSRTCStatsReport* IDLAttribute<JSRTCStatsReport>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCStatsReport*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCStatsReport* IDLOperation<JSRTCStatsReport>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCStatsReport*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCStatsReportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCStatsReportPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCStatsReport::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCStatsReportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCStatsReportPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCStatsReportSizeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCStatsReport& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    JSValue result = toJS<IDLAny>(lexicalGlobalObject, throwScope, forwardSizeToMapLike(lexicalGlobalObject, thisObject));
    return result;
}

EncodedJSValue jsRTCStatsReportSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCStatsReport>::get<jsRTCStatsReportSizeGetter>(*lexicalGlobalObject, thisValue, "size");
}

static inline JSC::EncodedJSValue jsRTCStatsReportPrototypeFunctionGetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCStatsReport>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto key = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLAny>(forwardGetToMapLike(*lexicalGlobalObject, *callFrame, *castedThis, WTFMove(key))));
}

EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionGet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCStatsReport>::call<jsRTCStatsReportPrototypeFunctionGetBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsRTCStatsReportPrototypeFunctionHasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCStatsReport>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto key = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLAny>(forwardHasToMapLike(*lexicalGlobalObject, *callFrame, *castedThis, WTFMove(key))));
}

EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionHas(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCStatsReport>::call<jsRTCStatsReportPrototypeFunctionHasBody>(*lexicalGlobalObject, *callFrame, "has");
}

static inline JSC::EncodedJSValue jsRTCStatsReportPrototypeFunctionEntriesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCStatsReport>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    return JSValue::encode(toJS<IDLAny>(forwardEntriesToMapLike(*lexicalGlobalObject, *callFrame, *castedThis)));
}

EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionEntries(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCStatsReport>::call<jsRTCStatsReportPrototypeFunctionEntriesBody>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline JSC::EncodedJSValue jsRTCStatsReportPrototypeFunctionKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCStatsReport>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    return JSValue::encode(toJS<IDLAny>(forwardKeysToMapLike(*lexicalGlobalObject, *callFrame, *castedThis)));
}

EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionKeys(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCStatsReport>::call<jsRTCStatsReportPrototypeFunctionKeysBody>(*lexicalGlobalObject, *callFrame, "keys");
}

static inline JSC::EncodedJSValue jsRTCStatsReportPrototypeFunctionValuesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCStatsReport>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    return JSValue::encode(toJS<IDLAny>(forwardValuesToMapLike(*lexicalGlobalObject, *callFrame, *castedThis)));
}

EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionValues(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCStatsReport>::call<jsRTCStatsReportPrototypeFunctionValuesBody>(*lexicalGlobalObject, *callFrame, "values");
}

static inline JSC::EncodedJSValue jsRTCStatsReportPrototypeFunctionForEachBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCStatsReport>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto callback = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLAny>(forwardForEachToMapLike(*lexicalGlobalObject, *callFrame, *castedThis, WTFMove(callback))));
}

EncodedJSValue JSC_HOST_CALL jsRTCStatsReportPrototypeFunctionForEach(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCStatsReport>::call<jsRTCStatsReportPrototypeFunctionForEachBody>(*lexicalGlobalObject, *callFrame, "forEach");
}

void JSRTCStatsReport::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCStatsReport*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCStatsReportOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCStatsReportOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCStatsReport = static_cast<JSRTCStatsReport*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCStatsReport->wrapped(), jsRTCStatsReport);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCStatsReport>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RTCStatsReport.
    static_assert(!std::is_polymorphic<RTCStatsReport>::value, "RTCStatsReport is polymorphic but the IDL claims it is not");
    return createWrapper<RTCStatsReport>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCStatsReport& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCStatsReport* JSRTCStatsReport::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCStatsReport*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
