/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCTrackEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStream.h"
#include "JSMediaStreamTrack.h"
#include "JSRTCRtpReceiver.h"
#include "JSRTCRtpTransceiver.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(WEB_RTC)
#include "JSDOMConvertStrings.h"
#endif


namespace WebCore {
using namespace JSC;

template<> RTCTrackEvent::Init convertDictionary<RTCTrackEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCTrackEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue receiverValue;
    if (isNullOrUndefined)
        receiverValue = jsUndefined();
    else {
        receiverValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "receiver"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!receiverValue.isUndefined()) {
        result.receiver = convert<IDLInterface<RTCRtpReceiver>>(lexicalGlobalObject, receiverValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "receiver", "RTCTrackEventInit", "RTCRtpReceiver");
        return { };
    }
    JSValue streamsValue;
    if (isNullOrUndefined)
        streamsValue = jsUndefined();
    else {
        streamsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "streams"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!streamsValue.isUndefined()) {
        result.streams = convert<IDLSequence<IDLInterface<MediaStream>>>(lexicalGlobalObject, streamsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.streams = Converter<IDLSequence<IDLInterface<MediaStream>>>::ReturnType{ };
    JSValue trackValue;
    if (isNullOrUndefined)
        trackValue = jsUndefined();
    else {
        trackValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "track"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!trackValue.isUndefined()) {
        result.track = convert<IDLInterface<MediaStreamTrack>>(lexicalGlobalObject, trackValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "track", "RTCTrackEventInit", "MediaStreamTrack");
        return { };
    }
    JSValue transceiverValue;
    if (isNullOrUndefined)
        transceiverValue = jsUndefined();
    else {
        transceiverValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transceiver"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transceiverValue.isUndefined()) {
        result.transceiver = convert<IDLInterface<RTCRtpTransceiver>>(lexicalGlobalObject, transceiverValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "transceiver", "RTCTrackEventInit", "RTCRtpTransceiver");
        return { };
    }
    return result;
}

// Attributes

JSC::EncodedJSValue jsRTCTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCTrackEventReceiver(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCTrackEventTrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCTrackEventStreams(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCTrackEventTransceiver(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCTrackEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCTrackEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCTrackEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCTrackEventPrototype>(vm.heap)) JSRTCTrackEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCTrackEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCTrackEventPrototype, JSRTCTrackEventPrototype::Base);

using JSRTCTrackEventConstructor = JSDOMConstructor<JSRTCTrackEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSRTCTrackEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSRTCTrackEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<RTCTrackEvent::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = RTCTrackEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<RTCTrackEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSRTCTrackEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSRTCTrackEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCTrackEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCTrackEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCTrackEventConstructor::s_info = { "RTCTrackEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCTrackEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCTrackEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCTrackEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCTrackEventConstructor) } },
    { "receiver", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCTrackEventReceiver), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "track", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCTrackEventTrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "streams", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCTrackEventStreams), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transceiver", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCTrackEventTransceiver), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSRTCTrackEventPrototype::s_info = { "RTCTrackEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCTrackEventPrototype) };

void JSRTCTrackEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCTrackEvent::info(), JSRTCTrackEventPrototypeTableValues, *this);
}

const ClassInfo JSRTCTrackEvent::s_info = { "RTCTrackEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCTrackEvent) };

JSRTCTrackEvent::JSRTCTrackEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCTrackEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSRTCTrackEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCTrackEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCTrackEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCTrackEventPrototype::create(vm, &globalObject, JSRTCTrackEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSRTCTrackEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCTrackEvent>(vm, globalObject);
}

JSValue JSRTCTrackEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCTrackEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSRTCTrackEvent* IDLAttribute<JSRTCTrackEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCTrackEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsRTCTrackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCTrackEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCTrackEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCTrackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCTrackEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCTrackEventReceiverGetter(JSGlobalObject& lexicalGlobalObject, JSRTCTrackEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<RTCRtpReceiver>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.receiver());
    return result;
}

EncodedJSValue jsRTCTrackEventReceiver(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCTrackEvent>::get<jsRTCTrackEventReceiverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "receiver");
}

static inline JSValue jsRTCTrackEventTrackGetter(JSGlobalObject& lexicalGlobalObject, JSRTCTrackEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MediaStreamTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track());
    return result;
}

EncodedJSValue jsRTCTrackEventTrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCTrackEvent>::get<jsRTCTrackEventTrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "track");
}

static inline JSValue jsRTCTrackEventStreamsGetter(JSGlobalObject& lexicalGlobalObject, JSRTCTrackEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (JSValue cachedValue = thisObject.m_streams.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFrozenArray<IDLInterface<MediaStream>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.streams());
    thisObject.m_streams.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

EncodedJSValue jsRTCTrackEventStreams(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCTrackEvent>::get<jsRTCTrackEventStreamsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "streams");
}

static inline JSValue jsRTCTrackEventTransceiverGetter(JSGlobalObject& lexicalGlobalObject, JSRTCTrackEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<RTCRtpTransceiver>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transceiver());
    return result;
}

EncodedJSValue jsRTCTrackEventTransceiver(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCTrackEvent>::get<jsRTCTrackEventTransceiverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "transceiver");
}

void JSRTCTrackEvent::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSRTCTrackEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_streams);
}

void JSRTCTrackEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCTrackEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7RTCTrackEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13RTCTrackEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCTrackEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7RTCTrackEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13RTCTrackEventE[2];
#endif

    // If this fails RTCTrackEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<RTCTrackEvent>::value, "RTCTrackEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // RTCTrackEvent has subclasses. If RTCTrackEvent has subclasses that get passed
    // to toJS() we currently require RTCTrackEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<RTCTrackEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCTrackEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_RTC)
