/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(STREAMS_API)

#include "JSReadableStreamSource.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsReadableStreamSourcePrototypeFunctionStart(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsReadableStreamSourcePrototypeFunctionPull(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsReadableStreamSourcePrototypeFunctionCancel(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsReadableStreamSourceController(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSReadableStreamSourcePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSReadableStreamSourcePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSReadableStreamSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSReadableStreamSourcePrototype>(vm.heap)) JSReadableStreamSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSReadableStreamSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSReadableStreamSourcePrototype, JSReadableStreamSourcePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSReadableStreamSourcePrototypeTableValues[] =
{
    { "controller", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsReadableStreamSourceController), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "start", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsReadableStreamSourcePrototypeFunctionStart), (intptr_t) (1) } },
    { "pull", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsReadableStreamSourcePrototypeFunctionPull), (intptr_t) (1) } },
    { "cancel", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsReadableStreamSourcePrototypeFunctionCancel), (intptr_t) (1) } },
};

const ClassInfo JSReadableStreamSourcePrototype::s_info = { "ReadableStreamSourcePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSReadableStreamSourcePrototype) };

void JSReadableStreamSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSReadableStreamSource::info(), JSReadableStreamSourcePrototypeTableValues, *this);
}

const ClassInfo JSReadableStreamSource::s_info = { "ReadableStreamSource", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSReadableStreamSource) };

JSReadableStreamSource::JSReadableStreamSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ReadableStreamSource>&& impl)
    : JSDOMWrapper<ReadableStreamSource>(structure, globalObject, WTFMove(impl))
{
}

void JSReadableStreamSource::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ReadableStreamSource>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSReadableStreamSource::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSReadableStreamSourcePrototype::create(vm, &globalObject, JSReadableStreamSourcePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSReadableStreamSource::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSReadableStreamSource>(vm, globalObject);
}

void JSReadableStreamSource::destroy(JSC::JSCell* cell)
{
    JSReadableStreamSource* thisObject = static_cast<JSReadableStreamSource*>(cell);
    thisObject->JSReadableStreamSource::~JSReadableStreamSource();
}

template<> inline JSReadableStreamSource* IDLAttribute<JSReadableStreamSource>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSReadableStreamSource*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSReadableStreamSource* IDLOperation<JSReadableStreamSource>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSReadableStreamSource*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsReadableStreamSourceControllerGetter(JSGlobalObject& lexicalGlobalObject, JSReadableStreamSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.controller(lexicalGlobalObject);
}

EncodedJSValue jsReadableStreamSourceController(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSReadableStreamSource>::get<jsReadableStreamSourceControllerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "controller");
}

static inline JSC::EncodedJSValue jsReadableStreamSourcePrototypeFunctionStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSReadableStreamSource>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    return JSValue::encode(castedThis->start(*lexicalGlobalObject, *callFrame, WTFMove(promise)));
}

EncodedJSValue JSC_HOST_CALL jsReadableStreamSourcePrototypeFunctionStart(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSReadableStreamSource>::call<jsReadableStreamSourcePrototypeFunctionStartBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsReadableStreamSourcePrototypeFunctionPullBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSReadableStreamSource>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    return JSValue::encode(castedThis->pull(*lexicalGlobalObject, *callFrame, WTFMove(promise)));
}

EncodedJSValue JSC_HOST_CALL jsReadableStreamSourcePrototypeFunctionPull(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSReadableStreamSource>::call<jsReadableStreamSourcePrototypeFunctionPullBody>(*lexicalGlobalObject, *callFrame, "pull");
}

static inline JSC::EncodedJSValue jsReadableStreamSourcePrototypeFunctionCancelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSReadableStreamSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto reason = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.cancel(WTFMove(reason));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsReadableStreamSourcePrototypeFunctionCancel(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSReadableStreamSource>::call<jsReadableStreamSourcePrototypeFunctionCancelBody>(*lexicalGlobalObject, *callFrame, "cancel");
}

void JSReadableStreamSource::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSReadableStreamSource*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_controller);
}

void JSReadableStreamSource::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSReadableStreamSource*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSReadableStreamSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSReadableStreamSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsReadableStreamSource = static_cast<JSReadableStreamSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsReadableStreamSource->wrapped(), jsReadableStreamSource);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ReadableStreamSource>&& impl)
{
    return createWrapper<ReadableStreamSource>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ReadableStreamSource& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ReadableStreamSource* JSReadableStreamSource::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSReadableStreamSource*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(STREAMS_API)
