/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRemoteDOMWindow.h"

#include "ActiveDOMObject.h"
#include "DOMWindow.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSLocation.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions


// Attributes

JSC::EncodedJSValue jsRemoteDOMWindowWindow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRemoteDOMWindowSelf(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRemoteDOMWindowSelf(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRemoteDOMWindowLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRemoteDOMWindowLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRemoteDOMWindowFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRemoteDOMWindowFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRemoteDOMWindowLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRemoteDOMWindowLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRemoteDOMWindowTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRemoteDOMWindowOpener(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRemoteDOMWindowParent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRemoteDOMWindowParent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

/* Hash table */

static const struct CompactHashIndex JSRemoteDOMWindowTableIndex[34] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { 0, 32 },
    { 1, -1 },
    { 6, -1 },
    { 4, 33 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { 5, -1 },
    { -1, -1 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 3, -1 },
    { 7, -1 },
};


static const HashTableValue JSRemoteDOMWindowTableValues[] =
{
    { "window", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowWindow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "self", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowSelf), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRemoteDOMWindowSelf) } },
    { "location", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRemoteDOMWindowLocation) } },
    { "closed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowClosed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "frames", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRemoteDOMWindowFrames) } },
    { "length", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRemoteDOMWindowLength) } },
    { "top", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "opener", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowOpener), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "parent", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRemoteDOMWindowParent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRemoteDOMWindowParent) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRemoteDOMWindowInstanceFunctionClose), (intptr_t) (0) } },
    { "focus", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRemoteDOMWindowInstanceFunctionFocus), (intptr_t) (0) } },
    { "blur", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRemoteDOMWindowInstanceFunctionBlur), (intptr_t) (0) } },
    { "postMessage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRemoteDOMWindowInstanceFunctionPostMessage), (intptr_t) (2) } },
};

static const HashTable JSRemoteDOMWindowTable = { 13, 31, true, JSRemoteDOMWindow::info(), JSRemoteDOMWindowTableValues, JSRemoteDOMWindowTableIndex };
/* Hash table for prototype */

static const struct CompactHashIndex JSRemoteDOMWindowPrototypeTableIndex[1] = {
    { -1, -1 },
};


static const HashTableValue JSRemoteDOMWindowPrototypeTableValues[] =
{
    { 0, 0, NoIntrinsic, { 0, 0 } }
};

static const HashTable JSRemoteDOMWindowPrototypeTable = { 0, 0, false, JSRemoteDOMWindow::info(), JSRemoteDOMWindowPrototypeTableValues, JSRemoteDOMWindowPrototypeTableIndex };
const ClassInfo JSRemoteDOMWindowPrototype::s_info = { "WindowPrototype", &Base::s_info, &JSRemoteDOMWindowPrototypeTable, nullptr, CREATE_METHOD_TABLE(JSRemoteDOMWindowPrototype) };

const ClassInfo JSRemoteDOMWindow::s_info = { "Window", &Base::s_info, &JSRemoteDOMWindowTable, nullptr, CREATE_METHOD_TABLE(JSRemoteDOMWindow) };

JSRemoteDOMWindow::JSRemoteDOMWindow(VM& vm, Structure* structure, Ref<RemoteDOMWindow>&& impl, JSWindowProxy* proxy)
    : JSRemoteDOMWindowBase(vm, structure, WTFMove(impl), proxy)
{
}

void JSRemoteDOMWindow::finishCreation(VM& vm, JSWindowProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    static_assert(!std::is_base_of<ActiveDOMObject, RemoteDOMWindow>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

template<> inline JSRemoteDOMWindow* IDLAttribute<JSRemoteDOMWindow>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto decodedThisValue = JSValue::decode(thisValue);
    if (decodedThisValue.isUndefinedOrNull())
        decodedThisValue = JSValue(&lexicalGlobalObject).toThis(&lexicalGlobalObject, NotStrictMode);
    return toJSRemoteDOMWindow(vm, decodedThisValue);
}

template<> inline JSRemoteDOMWindow* IDLOperation<JSRemoteDOMWindow>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return toJSRemoteDOMWindow(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue().toThis(&lexicalGlobalObject, NotStrictMode));
}

static inline JSValue jsRemoteDOMWindowWindowGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WindowProxy>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.self());
    return result;
}

EncodedJSValue jsRemoteDOMWindowWindow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowWindowGetter>(*lexicalGlobalObject, thisValue, "window");
}

static inline JSValue jsRemoteDOMWindowSelfGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WindowProxy>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.self());
    return result;
}

EncodedJSValue jsRemoteDOMWindowSelf(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowSelfGetter>(*lexicalGlobalObject, thisValue, "self");
}

static inline bool setJSRemoteDOMWindowSelfSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("self"), strlen("self")), value);
}

bool setJSRemoteDOMWindowSelf(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindowSelfSetter>(*lexicalGlobalObject, thisValue, encodedValue, "self");
}

static inline JSValue jsRemoteDOMWindowLocationGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Location>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.location());
    return result;
}

EncodedJSValue jsRemoteDOMWindowLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowLocationGetter>(*lexicalGlobalObject, thisValue, "location");
}

static inline bool setJSRemoteDOMWindowLocationSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("location"), strlen("location"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("href"), strlen("href"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSRemoteDOMWindowLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindowLocationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "location");
}

static inline JSValue jsRemoteDOMWindowClosedGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.closed());
    return result;
}

EncodedJSValue jsRemoteDOMWindowClosed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowClosedGetter>(*lexicalGlobalObject, thisValue, "closed");
}

static inline JSValue jsRemoteDOMWindowFramesGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WindowProxy>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.self());
    return result;
}

EncodedJSValue jsRemoteDOMWindowFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowFramesGetter>(*lexicalGlobalObject, thisValue, "frames");
}

static inline bool setJSRemoteDOMWindowFramesSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("frames"), strlen("frames")), value);
}

bool setJSRemoteDOMWindowFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindowFramesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "frames");
}

static inline JSValue jsRemoteDOMWindowLengthGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length());
    return result;
}

EncodedJSValue jsRemoteDOMWindowLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowLengthGetter>(*lexicalGlobalObject, thisValue, "length");
}

static inline bool setJSRemoteDOMWindowLengthSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("length"), strlen("length")), value);
}

bool setJSRemoteDOMWindowLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindowLengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "length");
}

static inline JSValue jsRemoteDOMWindowTopGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.top());
    return result;
}

EncodedJSValue jsRemoteDOMWindowTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowTopGetter>(*lexicalGlobalObject, thisValue, "top");
}

static inline JSValue jsRemoteDOMWindowOpenerGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.opener());
    return result;
}

EncodedJSValue jsRemoteDOMWindowOpener(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowOpenerGetter>(*lexicalGlobalObject, thisValue, "opener");
}

static inline JSValue jsRemoteDOMWindowParentGetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parent());
    return result;
}

EncodedJSValue jsRemoteDOMWindowParent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRemoteDOMWindow>::get<jsRemoteDOMWindowParentGetter>(*lexicalGlobalObject, thisValue, "parent");
}

static inline bool setJSRemoteDOMWindowParentSetter(JSGlobalObject& lexicalGlobalObject, JSRemoteDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("parent"), strlen("parent")), value);
}

bool setJSRemoteDOMWindowParent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRemoteDOMWindow>::set<setJSRemoteDOMWindowParentSetter>(*lexicalGlobalObject, thisValue, encodedValue, "parent");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* incumbentDocument = incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame).document();
    if (!incumbentDocument)
        return JSValue::encode(jsUndefined());
    impl.close(*incumbentDocument);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunctionFocusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.focus(incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionFocus(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunctionFocusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunctionBlurBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.blur();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionBlur(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunctionBlurBody>(*lexicalGlobalObject, *callFrame, "blur");
}

static inline JSC::EncodedJSValue jsRemoteDOMWindowInstanceFunctionPostMessageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRemoteDOMWindow>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto message = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto targetOrigin = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transfer = callFrame->argument(2).isUndefined() ? Converter<IDLSequence<IDLObject>>::ReturnType{ } : convert<IDLSequence<IDLObject>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), incumbentDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *callFrame), WTFMove(message), WTFMove(targetOrigin), WTFMove(transfer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionPostMessage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRemoteDOMWindow>::call<jsRemoteDOMWindowInstanceFunctionPostMessageBody>(*lexicalGlobalObject, *callFrame, "postMessage");
}

JSC::IsoSubspace* JSRemoteDOMWindow::subspaceForImpl(JSC::VM& vm)
{
    return &static_cast<JSVMClientData*>(vm.clientData)->subspaceForJSRemoteDOMWindow();
}

void JSRemoteDOMWindow::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRemoteDOMWindow*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
