/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMWrapper.h"
#include "JSRemoteDOMWindowBase.h"

namespace WebCore {

class RemoteDOMWindow;

class JSWindowProxy;

class JSRemoteDOMWindow : public JSRemoteDOMWindowBase {
public:
    using Base = JSRemoteDOMWindowBase;
    using DOMWrapped = RemoteDOMWindow;
    static JSRemoteDOMWindow* create(JSC::VM& vm, JSC::Structure* structure, Ref<RemoteDOMWindow>&& impl, JSWindowProxy* proxy)
    {
        JSRemoteDOMWindow* ptr = new (NotNull, JSC::allocateCell<JSRemoteDOMWindow>(vm.heap)) JSRemoteDOMWindow(vm, structure, WTFMove(impl), proxy);
        ptr->finishCreation(vm, proxy);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertySlotByIndex(JSC::JSObject*, JSC::JSGlobalObject*, unsigned propertyName, JSC::PropertySlot&);
    static void getOwnPropertyNames(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyNameArray&, JSC::EnumerationMode = JSC::EnumerationMode());
    static bool put(JSC::JSCell*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static bool putByIndex(JSC::JSCell*, JSC::JSGlobalObject*, unsigned propertyName, JSC::JSValue, bool shouldThrow);
    static bool defineOwnProperty(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, const JSC::PropertyDescriptor&, bool shouldThrow);
    static bool deleteProperty(JSC::JSCell*, JSC::JSGlobalObject*, JSC::PropertyName);
    static bool deletePropertyByIndex(JSC::JSCell*, JSC::JSGlobalObject*, unsigned);
    static JSC::JSValue getPrototype(JSC::JSObject*, JSC::JSGlobalObject*);
    static String toStringName(const JSC::JSObject*, JSC::JSGlobalObject*);
    static bool preventExtensions(JSC::JSObject*, JSC::JSGlobalObject*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::GlobalObjectType, StructureFlags), info());
    }

    template<typename, JSC::SubspaceAccess> static JSC::IsoSubspace* subspaceFor(JSC::VM& vm) { return subspaceForImpl(vm); }
    static JSC::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    RemoteDOMWindow& wrapped() const
    {
        return static_cast<RemoteDOMWindow&>(Base::wrapped());
    }
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::HasStaticPropertyTable | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::IsImmutablePrototypeExoticObject | JSC::OverridesGetOwnPropertySlot | JSC::OverridesGetPropertyNames;
protected:
    JSRemoteDOMWindow(JSC::VM&, JSC::Structure*, Ref<RemoteDOMWindow>&&, JSWindowProxy*);
    void finishCreation(JSC::VM&, JSWindowProxy*);
};


class JSRemoteDOMWindowPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRemoteDOMWindowPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRemoteDOMWindowPrototype* ptr = new (NotNull, JSC::allocateCell<JSRemoteDOMWindowPrototype>(vm.heap)) JSRemoteDOMWindowPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRemoteDOMWindowPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::IsImmutablePrototypeExoticObject;
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRemoteDOMWindowPrototype, JSRemoteDOMWindowPrototype::Base);

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionFocus(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionBlur(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRemoteDOMWindowInstanceFunctionPostMessage(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRemoteDOMWindowClosed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
template<> struct JSDOMWrapperConverterTraits<RemoteDOMWindow> {
    using WrapperClass = JSRemoteDOMWindow;
    using ToWrappedReturnType = RemoteDOMWindow*;
};

} // namespace WebCore
