/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLResultSet.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSQLResultSetRowList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSQLResultSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSQLResultSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSQLResultSetRows(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLResultSetInsertId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLResultSetRowsAffected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSQLResultSetPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSQLResultSetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLResultSetPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLResultSetPrototype>(vm.heap)) JSSQLResultSetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLResultSetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLResultSetPrototype, JSSQLResultSetPrototype::Base);

using JSSQLResultSetConstructor = JSDOMConstructorNotConstructable<JSSQLResultSet>;

template<> JSValue JSSQLResultSetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLResultSetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSQLResultSet::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SQLResultSet"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSQLResultSetConstructor::s_info = { "SQLResultSet", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSQLResultSetPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSQLResultSetConstructor) } },
    { "rows", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRows), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetInsertId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rowsAffected", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRowsAffected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSQLResultSetPrototype::s_info = { "SQLResultSetPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetPrototype) };

void JSSQLResultSetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLResultSet::info(), JSSQLResultSetPrototypeTableValues, *this);
}

const ClassInfo JSSQLResultSet::s_info = { "SQLResultSet", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSet) };

JSSQLResultSet::JSSQLResultSet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLResultSet>&& impl)
    : JSDOMWrapper<SQLResultSet>(structure, globalObject, WTFMove(impl))
{
}

void JSSQLResultSet::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SQLResultSet>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSQLResultSet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSQLResultSetPrototype::create(vm, &globalObject, JSSQLResultSetPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSQLResultSet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSQLResultSet>(vm, globalObject);
}

JSValue JSSQLResultSet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLResultSetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSQLResultSet::destroy(JSC::JSCell* cell)
{
    JSSQLResultSet* thisObject = static_cast<JSSQLResultSet*>(cell);
    thisObject->JSSQLResultSet::~JSSQLResultSet();
}

template<> inline JSSQLResultSet* IDLAttribute<JSSQLResultSet>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSQLResultSet*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSQLResultSetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLResultSetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSQLResultSet::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSQLResultSetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLResultSetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSQLResultSetRowsGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SQLResultSetRowList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rows());
    return result;
}

EncodedJSValue jsSQLResultSetRows(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSQLResultSet>::get<jsSQLResultSetRowsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rows");
}

static inline JSValue jsSQLResultSetInsertIdGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.insertId());
    return result;
}

EncodedJSValue jsSQLResultSetInsertId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSQLResultSet>::get<jsSQLResultSetInsertIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "insertId");
}

static inline JSValue jsSQLResultSetRowsAffectedGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.rowsAffected());
    return result;
}

EncodedJSValue jsSQLResultSetRowsAffected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSQLResultSet>::get<jsSQLResultSetRowsAffectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rowsAffected");
}

void JSSQLResultSet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSQLResultSet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSQLResultSetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSQLResultSetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLResultSet = static_cast<JSSQLResultSet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLResultSet->wrapped(), jsSQLResultSet);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SQLResultSet>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLResultSet.
    static_assert(!std::is_polymorphic<SQLResultSet>::value, "SQLResultSet is polymorphic but the IDL claims it is not");
    return createWrapper<SQLResultSet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SQLResultSet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SQLResultSet* JSSQLResultSet::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLResultSet*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
