/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGComponentTransferFunctionElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedNumberList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGComponentTransferFunctionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGComponentTransferFunctionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementTableValues(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementSlope(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementIntercept(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementAmplitude(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementExponent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGComponentTransferFunctionElementOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGComponentTransferFunctionElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGComponentTransferFunctionElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGComponentTransferFunctionElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGComponentTransferFunctionElementPrototype>(vm.heap)) JSSVGComponentTransferFunctionElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGComponentTransferFunctionElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGComponentTransferFunctionElementPrototype, JSSVGComponentTransferFunctionElementPrototype::Base);

using JSSVGComponentTransferFunctionElementConstructor = JSDOMConstructorNotConstructable<JSSVGComponentTransferFunctionElement>;

/* Hash table for constructor */

static const HashTableValue JSSVGComponentTransferFunctionElementConstructorTableValues[] =
{
    { "SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_TABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_GAMMA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
};

template<> JSValue JSSVGComponentTransferFunctionElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGComponentTransferFunctionElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGComponentTransferFunctionElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGComponentTransferFunctionElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGComponentTransferFunctionElement::info(), JSSVGComponentTransferFunctionElementConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGComponentTransferFunctionElementConstructor::s_info = { "SVGComponentTransferFunctionElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGComponentTransferFunctionElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGComponentTransferFunctionElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGComponentTransferFunctionElementConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tableValues", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementTableValues), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "slope", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementSlope), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "intercept", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementIntercept), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "amplitude", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementAmplitude), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "exponent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementExponent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGComponentTransferFunctionElementOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_TABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_LINEAR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_FECOMPONENTTRANSFER_TYPE_GAMMA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
};

const ClassInfo JSSVGComponentTransferFunctionElementPrototype::s_info = { "SVGComponentTransferFunctionElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGComponentTransferFunctionElementPrototype) };

void JSSVGComponentTransferFunctionElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGComponentTransferFunctionElement::info(), JSSVGComponentTransferFunctionElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGComponentTransferFunctionElement::s_info = { "SVGComponentTransferFunctionElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGComponentTransferFunctionElement) };

JSSVGComponentTransferFunctionElement::JSSVGComponentTransferFunctionElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGComponentTransferFunctionElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGComponentTransferFunctionElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGComponentTransferFunctionElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGComponentTransferFunctionElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGComponentTransferFunctionElementPrototype::create(vm, &globalObject, JSSVGComponentTransferFunctionElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject)));
}

JSObject* JSSVGComponentTransferFunctionElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGComponentTransferFunctionElement>(vm, globalObject);
}

JSValue JSSVGComponentTransferFunctionElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGComponentTransferFunctionElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGComponentTransferFunctionElement* IDLAttribute<JSSVGComponentTransferFunctionElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGComponentTransferFunctionElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGComponentTransferFunctionElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGComponentTransferFunctionElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGComponentTransferFunctionElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGComponentTransferFunctionElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGComponentTransferFunctionElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGComponentTransferFunctionElementTypeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.typeAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsSVGComponentTransferFunctionElementTableValuesGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumberList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.tableValuesAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementTableValues(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementTableValuesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tableValues");
}

static inline JSValue jsSVGComponentTransferFunctionElementSlopeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.slopeAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementSlope(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementSlopeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "slope");
}

static inline JSValue jsSVGComponentTransferFunctionElementInterceptGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.interceptAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementIntercept(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementInterceptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "intercept");
}

static inline JSValue jsSVGComponentTransferFunctionElementAmplitudeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.amplitudeAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementAmplitude(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementAmplitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "amplitude");
}

static inline JSValue jsSVGComponentTransferFunctionElementExponentGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.exponentAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementExponent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementExponentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "exponent");
}

static inline JSValue jsSVGComponentTransferFunctionElementOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSSVGComponentTransferFunctionElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.offsetAnimated());
    return result;
}

EncodedJSValue jsSVGComponentTransferFunctionElementOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGComponentTransferFunctionElement>::get<jsSVGComponentTransferFunctionElementOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offset");
}

void JSSVGComponentTransferFunctionElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGComponentTransferFunctionElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
