/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMWrapper.h"
#include "JSElement.h"
#include "SVGElement.h"

namespace WebCore {

class JSSVGElement : public JSElement {
public:
    using Base = JSElement;
    using DOMWrapped = SVGElement;
    static JSSVGElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<SVGElement>&& impl)
    {
        JSSVGElement* ptr = new (NotNull, JSC::allocateCell<JSSVGElement>(globalObject->vm().heap)) JSSVGElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static SVGElement* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
#if ENABLE(CSS_TYPED_OM)
    mutable JSC::WriteBarrier<JSC::Unknown> m_attributeStyleMap;
#endif
    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    SVGElement& wrapped() const
    {
        return static_cast<SVGElement&>(Base::wrapped());
    }
protected:
    JSSVGElement(JSC::Structure*, JSDOMGlobalObject&, Ref<SVGElement>&&);

    void finishCreation(JSC::VM&);
};


template<> struct JSDOMWrapperConverterTraits<SVGElement> {
    using WrapperClass = JSSVGElement;
    using ToWrappedReturnType = SVGElement*;
};

} // namespace WebCore
