/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGFilterElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGFilterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGFilterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGFilterElementFilterUnits(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFilterElementPrimitiveUnits(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFilterElementX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFilterElementY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFilterElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFilterElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFilterElementHref(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGFilterElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGFilterElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGFilterElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGFilterElementPrototype>(vm.heap)) JSSVGFilterElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGFilterElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGFilterElementPrototype, JSSVGFilterElementPrototype::Base);

using JSSVGFilterElementConstructor = JSDOMConstructorNotConstructable<JSSVGFilterElement>;

template<> JSValue JSSVGFilterElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGFilterElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGFilterElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGFilterElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGFilterElementConstructor::s_info = { "SVGFilterElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFilterElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGFilterElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGFilterElementConstructor) } },
    { "filterUnits", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementFilterUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "primitiveUnits", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementPrimitiveUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "href", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFilterElementHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGFilterElementPrototype::s_info = { "SVGFilterElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFilterElementPrototype) };

void JSSVGFilterElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGFilterElement::info(), JSSVGFilterElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGFilterElement::s_info = { "SVGFilterElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFilterElement) };

JSSVGFilterElement::JSSVGFilterElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGFilterElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGFilterElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGFilterElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGFilterElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGFilterElementPrototype::create(vm, &globalObject, JSSVGFilterElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject)));
}

JSObject* JSSVGFilterElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGFilterElement>(vm, globalObject);
}

JSValue JSSVGFilterElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFilterElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGFilterElement* IDLAttribute<JSSVGFilterElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGFilterElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGFilterElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGFilterElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGFilterElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGFilterElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGFilterElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGFilterElementFilterUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.filterUnitsAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementFilterUnits(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementFilterUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "filterUnits");
}

static inline JSValue jsSVGFilterElementPrimitiveUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.primitiveUnitsAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementPrimitiveUnits(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementPrimitiveUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "primitiveUnits");
}

static inline JSValue jsSVGFilterElementXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline JSValue jsSVGFilterElementYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline JSValue jsSVGFilterElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.widthAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsSVGFilterElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.heightAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsSVGFilterElementHrefGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFilterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.hrefAnimated());
    return result;
}

EncodedJSValue jsSVGFilterElementHref(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFilterElement>::get<jsSVGFilterElementHrefGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "href");
}

void JSSVGFilterElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGFilterElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
