/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPreserveAspectRatio.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGPreserveAspectRatioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPreserveAspectRatioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPreserveAspectRatioAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPreserveAspectRatioAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPreserveAspectRatioMeetOrSlice(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGPreserveAspectRatioMeetOrSlice(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPreserveAspectRatioPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPreserveAspectRatioPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPreserveAspectRatioPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPreserveAspectRatioPrototype>(vm.heap)) JSSVGPreserveAspectRatioPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPreserveAspectRatioPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPreserveAspectRatioPrototype, JSSVGPreserveAspectRatioPrototype::Base);

using JSSVGPreserveAspectRatioConstructor = JSDOMConstructorNotConstructable<JSSVGPreserveAspectRatio>;

/* Hash table for constructor */

static const HashTableValue JSSVGPreserveAspectRatioConstructorTableValues[] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_PRESERVEASPECTRATIO_NONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "SVG_MEETORSLICE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_MEETORSLICE_MEET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_MEETORSLICE_SLICE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_UNKNOWN == 0, "SVG_PRESERVEASPECTRATIO_UNKNOWN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_NONE == 1, "SVG_PRESERVEASPECTRATIO_NONE in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMINYMIN == 2, "SVG_PRESERVEASPECTRATIO_XMINYMIN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMIDYMIN == 3, "SVG_PRESERVEASPECTRATIO_XMIDYMIN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMAXYMIN == 4, "SVG_PRESERVEASPECTRATIO_XMAXYMIN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMINYMID == 5, "SVG_PRESERVEASPECTRATIO_XMINYMID in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMIDYMID == 6, "SVG_PRESERVEASPECTRATIO_XMIDYMID in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMAXYMID == 7, "SVG_PRESERVEASPECTRATIO_XMAXYMID in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMINYMAX == 8, "SVG_PRESERVEASPECTRATIO_XMINYMAX in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMIDYMAX == 9, "SVG_PRESERVEASPECTRATIO_XMIDYMAX in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_PRESERVEASPECTRATIO_XMAXYMAX == 10, "SVG_PRESERVEASPECTRATIO_XMAXYMAX in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_MEETORSLICE_UNKNOWN == 0, "SVG_MEETORSLICE_UNKNOWN in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_MEETORSLICE_MEET == 1, "SVG_MEETORSLICE_MEET in SVGPreserveAspectRatioValue does not match value from IDL");
static_assert(SVGPreserveAspectRatioValue::SVG_MEETORSLICE_SLICE == 2, "SVG_MEETORSLICE_SLICE in SVGPreserveAspectRatioValue does not match value from IDL");

template<> JSValue JSSVGPreserveAspectRatioConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPreserveAspectRatioConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPreserveAspectRatio::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGPreserveAspectRatio"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGPreserveAspectRatio::info(), JSSVGPreserveAspectRatioConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGPreserveAspectRatioConstructor::s_info = { "SVGPreserveAspectRatio", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatioConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPreserveAspectRatioPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPreserveAspectRatioConstructor) } },
    { "align", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPreserveAspectRatioAlign) } },
    { "meetOrSlice", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioMeetOrSlice), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPreserveAspectRatioMeetOrSlice) } },
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_PRESERVEASPECTRATIO_NONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "SVG_MEETORSLICE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_MEETORSLICE_MEET", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_MEETORSLICE_SLICE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSSVGPreserveAspectRatioPrototype::s_info = { "SVGPreserveAspectRatioPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatioPrototype) };

void JSSVGPreserveAspectRatioPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPreserveAspectRatio::info(), JSSVGPreserveAspectRatioPrototypeTableValues, *this);
}

const ClassInfo JSSVGPreserveAspectRatio::s_info = { "SVGPreserveAspectRatio", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatio) };

JSSVGPreserveAspectRatio::JSSVGPreserveAspectRatio(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPreserveAspectRatio>&& impl)
    : JSDOMWrapper<SVGPreserveAspectRatio>(structure, globalObject, WTFMove(impl))
{
}

void JSSVGPreserveAspectRatio::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGPreserveAspectRatio>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGPreserveAspectRatio::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGPreserveAspectRatioPrototype::create(vm, &globalObject, JSSVGPreserveAspectRatioPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSVGPreserveAspectRatio::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPreserveAspectRatio>(vm, globalObject);
}

JSValue JSSVGPreserveAspectRatio::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPreserveAspectRatioConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGPreserveAspectRatio::destroy(JSC::JSCell* cell)
{
    JSSVGPreserveAspectRatio* thisObject = static_cast<JSSVGPreserveAspectRatio*>(cell);
    thisObject->JSSVGPreserveAspectRatio::~JSSVGPreserveAspectRatio();
}

template<> inline JSSVGPreserveAspectRatio* IDLAttribute<JSSVGPreserveAspectRatio>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGPreserveAspectRatio*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGPreserveAspectRatioConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPreserveAspectRatioPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPreserveAspectRatio::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGPreserveAspectRatioConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPreserveAspectRatioPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGPreserveAspectRatioAlignGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.align());
    return result;
}

EncodedJSValue jsSVGPreserveAspectRatioAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::get<jsSVGPreserveAspectRatioAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "align");
}

static inline bool setJSSVGPreserveAspectRatioAlignSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlign(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGPreserveAspectRatioAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::set<setJSSVGPreserveAspectRatioAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, "align");
}

static inline JSValue jsSVGPreserveAspectRatioMeetOrSliceGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.meetOrSlice());
    return result;
}

EncodedJSValue jsSVGPreserveAspectRatioMeetOrSlice(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::get<jsSVGPreserveAspectRatioMeetOrSliceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "meetOrSlice");
}

static inline bool setJSSVGPreserveAspectRatioMeetOrSliceSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPreserveAspectRatio& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedShort>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMeetOrSlice(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGPreserveAspectRatioMeetOrSlice(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGPreserveAspectRatio>::set<setJSSVGPreserveAspectRatioMeetOrSliceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "meetOrSlice");
}

void JSSVGPreserveAspectRatio::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPreserveAspectRatio*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGPreserveAspectRatioOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGPreserveAspectRatioOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPreserveAspectRatio = static_cast<JSSVGPreserveAspectRatio*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGPreserveAspectRatio->wrapped(), jsSVGPreserveAspectRatio);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGPreserveAspectRatio@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22SVGPreserveAspectRatioE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGPreserveAspectRatio>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SVGPreserveAspectRatio@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22SVGPreserveAspectRatioE[2];
#endif

    // If this fails SVGPreserveAspectRatio does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SVGPreserveAspectRatio>::value, "SVGPreserveAspectRatio is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SVGPreserveAspectRatio has subclasses. If SVGPreserveAspectRatio has subclasses that get passed
    // to toJS() we currently require SVGPreserveAspectRatio you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SVGPreserveAspectRatio>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGPreserveAspectRatio& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGPreserveAspectRatio* JSSVGPreserveAspectRatio::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPreserveAspectRatio*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
