/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGRenderingIntent.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGRenderingIntentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGRenderingIntentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGRenderingIntentPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGRenderingIntentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGRenderingIntentPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGRenderingIntentPrototype>(vm.heap)) JSSVGRenderingIntentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGRenderingIntentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGRenderingIntentPrototype, JSSVGRenderingIntentPrototype::Base);

using JSSVGRenderingIntentConstructor = JSDOMConstructorNotConstructable<JSSVGRenderingIntent>;

/* Hash table for constructor */

static const HashTableValue JSSVGRenderingIntentConstructorTableValues[] =
{
    { "RENDERING_INTENT_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "RENDERING_INTENT_AUTO", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "RENDERING_INTENT_PERCEPTUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "RENDERING_INTENT_RELATIVE_COLORIMETRIC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "RENDERING_INTENT_SATURATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
};

static_assert(SVGRenderingIntent::RENDERING_INTENT_UNKNOWN == 0, "RENDERING_INTENT_UNKNOWN in SVGRenderingIntent does not match value from IDL");
static_assert(SVGRenderingIntent::RENDERING_INTENT_AUTO == 1, "RENDERING_INTENT_AUTO in SVGRenderingIntent does not match value from IDL");
static_assert(SVGRenderingIntent::RENDERING_INTENT_PERCEPTUAL == 2, "RENDERING_INTENT_PERCEPTUAL in SVGRenderingIntent does not match value from IDL");
static_assert(SVGRenderingIntent::RENDERING_INTENT_RELATIVE_COLORIMETRIC == 3, "RENDERING_INTENT_RELATIVE_COLORIMETRIC in SVGRenderingIntent does not match value from IDL");
static_assert(SVGRenderingIntent::RENDERING_INTENT_SATURATION == 4, "RENDERING_INTENT_SATURATION in SVGRenderingIntent does not match value from IDL");
static_assert(SVGRenderingIntent::RENDERING_INTENT_ABSOLUTE_COLORIMETRIC == 5, "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC in SVGRenderingIntent does not match value from IDL");

template<> JSValue JSSVGRenderingIntentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGRenderingIntentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGRenderingIntent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGRenderingIntent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGRenderingIntent::info(), JSSVGRenderingIntentConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGRenderingIntentConstructor::s_info = { "SVGRenderingIntent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGRenderingIntentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGRenderingIntentPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGRenderingIntentConstructor) } },
    { "RENDERING_INTENT_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "RENDERING_INTENT_AUTO", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "RENDERING_INTENT_PERCEPTUAL", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "RENDERING_INTENT_RELATIVE_COLORIMETRIC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "RENDERING_INTENT_SATURATION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
};

const ClassInfo JSSVGRenderingIntentPrototype::s_info = { "SVGRenderingIntentPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGRenderingIntentPrototype) };

void JSSVGRenderingIntentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGRenderingIntent::info(), JSSVGRenderingIntentPrototypeTableValues, *this);
}

const ClassInfo JSSVGRenderingIntent::s_info = { "SVGRenderingIntent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGRenderingIntent) };

JSSVGRenderingIntent::JSSVGRenderingIntent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGRenderingIntent>&& impl)
    : JSDOMWrapper<SVGRenderingIntent>(structure, globalObject, WTFMove(impl))
{
}

void JSSVGRenderingIntent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGRenderingIntent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGRenderingIntent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGRenderingIntentPrototype::create(vm, &globalObject, JSSVGRenderingIntentPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSVGRenderingIntent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGRenderingIntent>(vm, globalObject);
}

JSValue JSSVGRenderingIntent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRenderingIntentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGRenderingIntent::destroy(JSC::JSCell* cell)
{
    JSSVGRenderingIntent* thisObject = static_cast<JSSVGRenderingIntent*>(cell);
    thisObject->JSSVGRenderingIntent::~JSSVGRenderingIntent();
}

EncodedJSValue jsSVGRenderingIntentConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGRenderingIntentPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGRenderingIntent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGRenderingIntentConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGRenderingIntentPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSSVGRenderingIntent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGRenderingIntent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGRenderingIntentOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGRenderingIntentOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGRenderingIntent = static_cast<JSSVGRenderingIntent*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGRenderingIntent->wrapped(), jsSVGRenderingIntent);
}

SVGRenderingIntent* JSSVGRenderingIntent::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGRenderingIntent*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
