/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGZoomEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGZoomEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGZoomEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGZoomEventZoomRectScreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGZoomEventPreviousScale(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGZoomEventPreviousTranslate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGZoomEventNewScale(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGZoomEventNewTranslate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGZoomEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGZoomEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGZoomEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGZoomEventPrototype>(vm.heap)) JSSVGZoomEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGZoomEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGZoomEventPrototype, JSSVGZoomEventPrototype::Base);

using JSSVGZoomEventConstructor = JSDOMConstructorNotConstructable<JSSVGZoomEvent>;

template<> JSValue JSSVGZoomEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSSVGZoomEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGZoomEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGZoomEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGZoomEventConstructor::s_info = { "SVGZoomEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGZoomEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGZoomEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGZoomEventConstructor) } },
    { "zoomRectScreen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomEventZoomRectScreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "previousScale", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomEventPreviousScale), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "previousTranslate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomEventPreviousTranslate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "newScale", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomEventNewScale), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "newTranslate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGZoomEventNewTranslate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGZoomEventPrototype::s_info = { "SVGZoomEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGZoomEventPrototype) };

void JSSVGZoomEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGZoomEvent::info(), JSSVGZoomEventPrototypeTableValues, *this);
}

const ClassInfo JSSVGZoomEvent::s_info = { "SVGZoomEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGZoomEvent) };

JSSVGZoomEvent::JSSVGZoomEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGZoomEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

void JSSVGZoomEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGZoomEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGZoomEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGZoomEventPrototype::create(vm, &globalObject, JSSVGZoomEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject)));
}

JSObject* JSSVGZoomEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGZoomEvent>(vm, globalObject);
}

JSValue JSSVGZoomEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGZoomEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGZoomEvent* IDLAttribute<JSSVGZoomEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGZoomEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGZoomEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGZoomEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGZoomEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGZoomEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGZoomEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGZoomEventZoomRectScreenGetter(JSGlobalObject& lexicalGlobalObject, JSSVGZoomEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJSNewlyCreated<IDLInterface<SVGRect>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.zoomRectScreen());
    return result;
}

EncodedJSValue jsSVGZoomEventZoomRectScreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGZoomEvent>::get<jsSVGZoomEventZoomRectScreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "zoomRectScreen");
}

static inline JSValue jsSVGZoomEventPreviousScaleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGZoomEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.previousScale());
    return result;
}

EncodedJSValue jsSVGZoomEventPreviousScale(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGZoomEvent>::get<jsSVGZoomEventPreviousScaleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "previousScale");
}

static inline JSValue jsSVGZoomEventPreviousTranslateGetter(JSGlobalObject& lexicalGlobalObject, JSSVGZoomEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.previousTranslate());
    return result;
}

EncodedJSValue jsSVGZoomEventPreviousTranslate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGZoomEvent>::get<jsSVGZoomEventPreviousTranslateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "previousTranslate");
}

static inline JSValue jsSVGZoomEventNewScaleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGZoomEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.newScale());
    return result;
}

EncodedJSValue jsSVGZoomEventNewScale(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGZoomEvent>::get<jsSVGZoomEventNewScaleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "newScale");
}

static inline JSValue jsSVGZoomEventNewTranslateGetter(JSGlobalObject& lexicalGlobalObject, JSSVGZoomEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.newTranslate());
    return result;
}

EncodedJSValue jsSVGZoomEventNewTranslate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGZoomEvent>::get<jsSVGZoomEventNewTranslateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "newTranslate");
}

void JSSVGZoomEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGZoomEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
