/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollBehavior.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ScrollBehavior enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auto"),
        MAKE_STATIC_STRING_IMPL("instant"),
        MAKE_STATIC_STRING_IMPL("smooth"),
    };
    static_assert(static_cast<size_t>(ScrollBehavior::Auto) == 0, "ScrollBehavior::Auto is not 0 as expected");
    static_assert(static_cast<size_t>(ScrollBehavior::Instant) == 1, "ScrollBehavior::Instant is not 1 as expected");
    static_assert(static_cast<size_t>(ScrollBehavior::Smooth) == 2, "ScrollBehavior::Smooth is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, ScrollBehavior enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<ScrollBehavior> parseEnumeration<ScrollBehavior>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "auto")
        return ScrollBehavior::Auto;
    if (stringValue == "instant")
        return ScrollBehavior::Instant;
    if (stringValue == "smooth")
        return ScrollBehavior::Smooth;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<ScrollBehavior>()
{
    return "\"auto\", \"instant\", \"smooth\"";
}

} // namespace WebCore
