/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollIntoViewOptions.h"

#include "JSDOMConvertEnumeration.h"
#include "JSScrollBehavior.h"
#include "JSScrollLogicalPosition.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ScrollIntoViewOptions convertDictionary<ScrollIntoViewOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ScrollIntoViewOptions result;
    JSValue behaviorValue;
    if (isNullOrUndefined)
        behaviorValue = jsUndefined();
    else {
        behaviorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "behavior"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!behaviorValue.isUndefined()) {
        result.behavior = convert<IDLEnumeration<ScrollBehavior>>(lexicalGlobalObject, behaviorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.behavior = ScrollBehavior::Auto;
    JSValue blockValue;
    if (isNullOrUndefined)
        blockValue = jsUndefined();
    else {
        blockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "block"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!blockValue.isUndefined()) {
        result.blockPosition = convert<IDLEnumeration<ScrollLogicalPosition>>(lexicalGlobalObject, blockValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.blockPosition = ScrollLogicalPosition::Start;
    JSValue inlineValue;
    if (isNullOrUndefined)
        inlineValue = jsUndefined();
    else {
        inlineValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inline"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!inlineValue.isUndefined()) {
        result.inlinePosition = convert<IDLEnumeration<ScrollLogicalPosition>>(lexicalGlobalObject, inlineValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.inlinePosition = ScrollLogicalPosition::Nearest;
    return result;
}

} // namespace WebCore
