/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScrollToOptions.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSScrollBehavior.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ScrollToOptions convertDictionary<ScrollToOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ScrollToOptions result;
    JSValue behaviorValue;
    if (isNullOrUndefined)
        behaviorValue = jsUndefined();
    else {
        behaviorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "behavior"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!behaviorValue.isUndefined()) {
        result.behavior = convert<IDLEnumeration<ScrollBehavior>>(lexicalGlobalObject, behaviorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.behavior = ScrollBehavior::Auto;
    JSValue leftValue;
    if (isNullOrUndefined)
        leftValue = jsUndefined();
    else {
        leftValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "left"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!leftValue.isUndefined()) {
        result.left = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, leftValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue topValue;
    if (isNullOrUndefined)
        topValue = jsUndefined();
    else {
        topValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "top"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!topValue.isUndefined()) {
        result.top = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, topValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
