/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSecurityPolicyViolationEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> SecurityPolicyViolationEvent::Init convertDictionary<SecurityPolicyViolationEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    SecurityPolicyViolationEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue blockedURIValue;
    if (isNullOrUndefined)
        blockedURIValue = jsUndefined();
    else {
        blockedURIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "blockedURI"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!blockedURIValue.isUndefined()) {
        result.blockedURI = convert<IDLUSVString>(lexicalGlobalObject, blockedURIValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.blockedURI = emptyString();
    JSValue columnNumberValue;
    if (isNullOrUndefined)
        columnNumberValue = jsUndefined();
    else {
        columnNumberValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "columnNumber"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!columnNumberValue.isUndefined()) {
        result.columnNumber = convert<IDLLong>(lexicalGlobalObject, columnNumberValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.columnNumber = 0;
    JSValue documentURIValue;
    if (isNullOrUndefined)
        documentURIValue = jsUndefined();
    else {
        documentURIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "documentURI"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!documentURIValue.isUndefined()) {
        result.documentURI = convert<IDLUSVString>(lexicalGlobalObject, documentURIValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.documentURI = emptyString();
    JSValue effectiveDirectiveValue;
    if (isNullOrUndefined)
        effectiveDirectiveValue = jsUndefined();
    else {
        effectiveDirectiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "effectiveDirective"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!effectiveDirectiveValue.isUndefined()) {
        result.effectiveDirective = convert<IDLDOMString>(lexicalGlobalObject, effectiveDirectiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.effectiveDirective = emptyString();
    JSValue lineNumberValue;
    if (isNullOrUndefined)
        lineNumberValue = jsUndefined();
    else {
        lineNumberValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lineNumber"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lineNumberValue.isUndefined()) {
        result.lineNumber = convert<IDLLong>(lexicalGlobalObject, lineNumberValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lineNumber = 0;
    JSValue originalPolicyValue;
    if (isNullOrUndefined)
        originalPolicyValue = jsUndefined();
    else {
        originalPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "originalPolicy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!originalPolicyValue.isUndefined()) {
        result.originalPolicy = convert<IDLDOMString>(lexicalGlobalObject, originalPolicyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.originalPolicy = emptyString();
    JSValue referrerValue;
    if (isNullOrUndefined)
        referrerValue = jsUndefined();
    else {
        referrerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!referrerValue.isUndefined()) {
        result.referrer = convert<IDLDOMString>(lexicalGlobalObject, referrerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.referrer = emptyString();
    JSValue sourceFileValue;
    if (isNullOrUndefined)
        sourceFileValue = jsUndefined();
    else {
        sourceFileValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sourceFile"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sourceFileValue.isUndefined()) {
        result.sourceFile = convert<IDLUSVString>(lexicalGlobalObject, sourceFileValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sourceFile = emptyString();
    JSValue statusCodeValue;
    if (isNullOrUndefined)
        statusCodeValue = jsUndefined();
    else {
        statusCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "statusCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!statusCodeValue.isUndefined()) {
        result.statusCode = convert<IDLUnsignedShort>(lexicalGlobalObject, statusCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.statusCode = 0;
    JSValue violatedDirectiveValue;
    if (isNullOrUndefined)
        violatedDirectiveValue = jsUndefined();
    else {
        violatedDirectiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "violatedDirective"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!violatedDirectiveValue.isUndefined()) {
        result.violatedDirective = convert<IDLDOMString>(lexicalGlobalObject, violatedDirectiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.violatedDirective = emptyString();
    return result;
}

// Attributes

JSC::EncodedJSValue jsSecurityPolicyViolationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSecurityPolicyViolationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSecurityPolicyViolationEventDocumentURI(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventReferrer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventBlockedURI(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventViolatedDirective(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventEffectiveDirective(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventOriginalPolicy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventSourceFile(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventStatusCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventLineNumber(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventColumnNumber(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSecurityPolicyViolationEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSecurityPolicyViolationEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSecurityPolicyViolationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSecurityPolicyViolationEventPrototype>(vm.heap)) JSSecurityPolicyViolationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSecurityPolicyViolationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSecurityPolicyViolationEventPrototype, JSSecurityPolicyViolationEventPrototype::Base);

using JSSecurityPolicyViolationEventConstructor = JSDOMConstructor<JSSecurityPolicyViolationEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSSecurityPolicyViolationEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSSecurityPolicyViolationEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<SecurityPolicyViolationEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = SecurityPolicyViolationEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<SecurityPolicyViolationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSSecurityPolicyViolationEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSSecurityPolicyViolationEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSecurityPolicyViolationEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SecurityPolicyViolationEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSecurityPolicyViolationEventConstructor::s_info = { "SecurityPolicyViolationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSecurityPolicyViolationEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSecurityPolicyViolationEventConstructor) } },
    { "documentURI", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventDocumentURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventReferrer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "blockedURI", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventBlockedURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "violatedDirective", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventViolatedDirective), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "effectiveDirective", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventEffectiveDirective), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "originalPolicy", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventOriginalPolicy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sourceFile", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventSourceFile), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "statusCode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventStatusCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lineNumber", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventLineNumber), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "columnNumber", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventColumnNumber), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSecurityPolicyViolationEventPrototype::s_info = { "SecurityPolicyViolationEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventPrototype) };

void JSSecurityPolicyViolationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSecurityPolicyViolationEvent::info(), JSSecurityPolicyViolationEventPrototypeTableValues, *this);
}

const ClassInfo JSSecurityPolicyViolationEvent::s_info = { "SecurityPolicyViolationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEvent) };

JSSecurityPolicyViolationEvent::JSSecurityPolicyViolationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSSecurityPolicyViolationEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SecurityPolicyViolationEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSecurityPolicyViolationEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSecurityPolicyViolationEventPrototype::create(vm, &globalObject, JSSecurityPolicyViolationEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSSecurityPolicyViolationEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSecurityPolicyViolationEvent>(vm, globalObject);
}

JSValue JSSecurityPolicyViolationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSecurityPolicyViolationEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSecurityPolicyViolationEvent* IDLAttribute<JSSecurityPolicyViolationEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSecurityPolicyViolationEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSecurityPolicyViolationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSecurityPolicyViolationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSecurityPolicyViolationEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSecurityPolicyViolationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSecurityPolicyViolationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSecurityPolicyViolationEventDocumentURIGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.documentURI());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventDocumentURI(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventDocumentURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "documentURI");
}

static inline JSValue jsSecurityPolicyViolationEventReferrerGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.referrer());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventReferrer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventReferrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referrer");
}

static inline JSValue jsSecurityPolicyViolationEventBlockedURIGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockedURI());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventBlockedURI(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventBlockedURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "blockedURI");
}

static inline JSValue jsSecurityPolicyViolationEventViolatedDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.violatedDirective());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventViolatedDirective(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventViolatedDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "violatedDirective");
}

static inline JSValue jsSecurityPolicyViolationEventEffectiveDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.effectiveDirective());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventEffectiveDirective(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventEffectiveDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "effectiveDirective");
}

static inline JSValue jsSecurityPolicyViolationEventOriginalPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.originalPolicy());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventOriginalPolicy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventOriginalPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "originalPolicy");
}

static inline JSValue jsSecurityPolicyViolationEventSourceFileGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.sourceFile());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventSourceFile(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventSourceFileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sourceFile");
}

static inline JSValue jsSecurityPolicyViolationEventStatusCodeGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.statusCode());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventStatusCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventStatusCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "statusCode");
}

static inline JSValue jsSecurityPolicyViolationEventLineNumberGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.lineNumber());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventLineNumber(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventLineNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineNumber");
}

static inline JSValue jsSecurityPolicyViolationEventColumnNumberGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.columnNumber());
    return result;
}

EncodedJSValue jsSecurityPolicyViolationEventColumnNumber(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEventColumnNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "columnNumber");
}

void JSSecurityPolicyViolationEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSecurityPolicyViolationEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SecurityPolicyViolationEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore28SecurityPolicyViolationEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SecurityPolicyViolationEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore28SecurityPolicyViolationEventE[2];
#endif

    // If this fails SecurityPolicyViolationEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SecurityPolicyViolationEvent>::value, "SecurityPolicyViolationEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SecurityPolicyViolationEvent has subclasses. If SecurityPolicyViolationEvent has subclasses that get passed
    // to toJS() we currently require SecurityPolicyViolationEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SecurityPolicyViolationEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SecurityPolicyViolationEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
