/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerClient.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPostMessageOptions.h"
#include "JSServiceWorkerClientType.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/IteratorOperations.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ServiceWorkerClient::FrameType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auxiliary"),
        MAKE_STATIC_STRING_IMPL("top-level"),
        MAKE_STATIC_STRING_IMPL("nested"),
        MAKE_STATIC_STRING_IMPL("none"),
    };
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::Auxiliary) == 0, "ServiceWorkerClient::FrameType::Auxiliary is not 0 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::TopLevel) == 1, "ServiceWorkerClient::FrameType::TopLevel is not 1 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::Nested) == 2, "ServiceWorkerClient::FrameType::Nested is not 2 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::None) == 3, "ServiceWorkerClient::FrameType::None is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, ServiceWorkerClient::FrameType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<ServiceWorkerClient::FrameType> parseEnumeration<ServiceWorkerClient::FrameType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "auxiliary")
        return ServiceWorkerClient::FrameType::Auxiliary;
    if (stringValue == "top-level")
        return ServiceWorkerClient::FrameType::TopLevel;
    if (stringValue == "nested")
        return ServiceWorkerClient::FrameType::Nested;
    if (stringValue == "none")
        return ServiceWorkerClient::FrameType::None;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<ServiceWorkerClient::FrameType>()
{
    return "\"auxiliary\", \"top-level\", \"nested\", \"none\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientPrototypeFunctionPostMessage(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsServiceWorkerClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSServiceWorkerClientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsServiceWorkerClientUrl(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerClientFrameType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerClientType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsServiceWorkerClientId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSServiceWorkerClientPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerClientPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerClientPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerClientPrototype>(vm.heap)) JSServiceWorkerClientPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerClientPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerClientPrototype, JSServiceWorkerClientPrototype::Base);

using JSServiceWorkerClientConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerClient>;

template<> JSValue JSServiceWorkerClientConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSServiceWorkerClientConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerClient::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Client"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSServiceWorkerClientConstructor::s_info = { "Client", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClientConstructor) };

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerClientPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerClientConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSServiceWorkerClientConstructor) } },
    { "url", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerClientUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "frameType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerClientFrameType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerClientType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsServiceWorkerClientId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "postMessage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsServiceWorkerClientPrototypeFunctionPostMessage), (intptr_t) (1) } },
};

const ClassInfo JSServiceWorkerClientPrototype::s_info = { "ClientPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClientPrototype) };

void JSServiceWorkerClientPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerClient::info(), JSServiceWorkerClientPrototypeTableValues, *this);
}

const ClassInfo JSServiceWorkerClient::s_info = { "Client", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClient) };

JSServiceWorkerClient::JSServiceWorkerClient(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerClient>&& impl)
    : JSDOMWrapper<ServiceWorkerClient>(structure, globalObject, WTFMove(impl))
{
}

void JSServiceWorkerClient::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerClient>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSServiceWorkerClient::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSServiceWorkerClientPrototype::create(vm, &globalObject, JSServiceWorkerClientPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSServiceWorkerClient::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerClient>(vm, globalObject);
}

JSValue JSServiceWorkerClient::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerClientConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSServiceWorkerClient::destroy(JSC::JSCell* cell)
{
    JSServiceWorkerClient* thisObject = static_cast<JSServiceWorkerClient*>(cell);
    thisObject->JSServiceWorkerClient::~JSServiceWorkerClient();
}

template<> inline JSServiceWorkerClient* IDLAttribute<JSServiceWorkerClient>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSServiceWorkerClient*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSServiceWorkerClient* IDLOperation<JSServiceWorkerClient>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSServiceWorkerClient*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsServiceWorkerClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerClientPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerClient::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSServiceWorkerClientConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerClientPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsServiceWorkerClientUrlGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url());
    return result;
}

EncodedJSValue jsServiceWorkerClientUrl(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClientUrlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "url");
}

static inline JSValue jsServiceWorkerClientFrameTypeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ServiceWorkerClient::FrameType>>(lexicalGlobalObject, throwScope, impl.frameType());
    return result;
}

EncodedJSValue jsServiceWorkerClientFrameType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClientFrameTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "frameType");
}

static inline JSValue jsServiceWorkerClientTypeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ServiceWorkerClientType>>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsServiceWorkerClientType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClientTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsServiceWorkerClientIdGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsServiceWorkerClientId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClientIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSC::EncodedJSValue jsServiceWorkerClientPrototypeFunctionPostMessage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerClient>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto message = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto transfer = convert<IDLSequence<IDLObject>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(transfer)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsServiceWorkerClientPrototypeFunctionPostMessage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerClient>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto message = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<PostMessageOptions>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(options)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsServiceWorkerClientPrototypeFunctionPostMessageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerClient>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        return jsServiceWorkerClientPrototypeFunctionPostMessage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
        if (distinguishingArg.isUndefined())
            return jsServiceWorkerClientPrototypeFunctionPostMessage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsServiceWorkerClientPrototypeFunctionPostMessage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (hasIteratorMethod(lexicalGlobalObject, distinguishingArg))
            return jsServiceWorkerClientPrototypeFunctionPostMessage1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject())
            return jsServiceWorkerClientPrototypeFunctionPostMessage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsServiceWorkerClientPrototypeFunctionPostMessage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSServiceWorkerClient>::call<jsServiceWorkerClientPrototypeFunctionPostMessageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "postMessage");
}

void JSServiceWorkerClient::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerClient*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerClientOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSServiceWorkerClientOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerClient = static_cast<JSServiceWorkerClient*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerClient->wrapped(), jsServiceWorkerClient);
}

ServiceWorkerClient* JSServiceWorkerClient::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerClient*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
