/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerClientType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ServiceWorkerClientType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("window"),
        MAKE_STATIC_STRING_IMPL("worker"),
        MAKE_STATIC_STRING_IMPL("sharedworker"),
        MAKE_STATIC_STRING_IMPL("all"),
    };
    static_assert(static_cast<size_t>(ServiceWorkerClientType::Window) == 0, "ServiceWorkerClientType::Window is not 0 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClientType::Worker) == 1, "ServiceWorkerClientType::Worker is not 1 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClientType::Sharedworker) == 2, "ServiceWorkerClientType::Sharedworker is not 2 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClientType::All) == 3, "ServiceWorkerClientType::All is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, ServiceWorkerClientType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<ServiceWorkerClientType> parseEnumeration<ServiceWorkerClientType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "window")
        return ServiceWorkerClientType::Window;
    if (stringValue == "worker")
        return ServiceWorkerClientType::Worker;
    if (stringValue == "sharedworker")
        return ServiceWorkerClientType::Sharedworker;
    if (stringValue == "all")
        return ServiceWorkerClientType::All;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<ServiceWorkerClientType>()
{
    return "\"window\", \"worker\", \"sharedworker\", \"all\"";
}

} // namespace WebCore

#endif // ENABLE(SERVICE_WORKER)
